/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.util;

import com.els.base.core.exception.CommonException;
import com.els.base.purchase.enumerate.PurchaseBarginTypeEnum;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public abstract class PurchaseBargainTypeCheckUtils {
    private static final String ERROR = "error:\u5355\u636e\u7684\u8bae\u4ef7\u65b9\u5f0f\u4e3a\u7a7a!";
    private static final String PATTERN = "\u53ea\u6709\u8bae\u4ef7\u65b9\u5f0f\u4e3a%s\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c%s\u64cd\u4f5c!";

    public static void require(Integer typeCode, PurchaseBarginTypeEnum type) {
        PurchaseBargainTypeCheckUtils.require(typeCode, type, String.format(PATTERN, ""));
    }

    public static void require(Integer typeCode, PurchaseBarginTypeEnum type, String operation) {
        if (typeCode == null) {
            throw new CommonException(ERROR);
        }
        if (typeCode.intValue() != type.code()) {
            throw new CommonException(String.format(PATTERN, type.desc(), operation));
        }
    }

    public static void requireAny(Integer typeCode, PurchaseBarginTypeEnum ... statuses) {
        PurchaseBargainTypeCheckUtils.requireAny(typeCode, "", statuses);
    }

    public static void requireAny(Integer typeCode, String operation, PurchaseBarginTypeEnum ... statuses) {
        if (typeCode == null) {
            throw new CommonException(ERROR);
        }
        for (PurchaseBarginTypeEnum type : statuses) {
            if (typeCode.intValue() != type.code()) continue;
            return;
        }
        Object[] desces = Arrays.asList(statuses).stream().map(PurchaseBarginTypeEnum::desc).toArray();
        throw new CommonException(String.format(PATTERN, StringUtils.join((Object[])desces, (char)'\u3001'), operation));
    }
}

