/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.util;

import com.els.base.core.exception.CommonException;
import com.els.base.purchase.enumerate.PurchaseRequisitionStatusEnum;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public abstract class PurchaseRequisitionStatusCheckUtils {
    private static final String ERROR = "error:\u5355\u636e\u72b6\u6001\u4e3a\u7a7a!";
    private static final String PATTERN = "\u53ea\u6709%s\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c%s\u64cd\u4f5c!";

    public static void require(Integer statusCode, PurchaseRequisitionStatusEnum status) {
        PurchaseRequisitionStatusCheckUtils.require(statusCode, status, String.format(PATTERN, ""));
    }

    public static void require(Integer statusCode, PurchaseRequisitionStatusEnum status, String operation) {
        if (statusCode == null) {
            throw new CommonException(ERROR);
        }
        if (statusCode.intValue() != status.code()) {
            throw new CommonException(String.format(PATTERN, status.desc(), operation));
        }
    }

    public static void requireAny(Integer statusCode, PurchaseRequisitionStatusEnum ... statuses) {
        PurchaseRequisitionStatusCheckUtils.requireAny(statusCode, "", statuses);
    }

    public static void requireAny(Integer statusCode, String operation, PurchaseRequisitionStatusEnum ... statuses) {
        if (statusCode == null) {
            throw new CommonException(ERROR);
        }
        for (PurchaseRequisitionStatusEnum status : statuses) {
            if (statusCode.intValue() != status.code()) continue;
            return;
        }
        Object[] desces = Arrays.asList(statuses).stream().map(PurchaseRequisitionStatusEnum::desc).toArray();
        throw new CommonException(String.format(PATTERN, StringUtils.join((Object[])desces, (char)'\u3001'), operation));
    }
}

