/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.cognize.service.impl;

import com.els.base.certification.cognize.dao.CompanyProductCognizeMapper;
import com.els.base.certification.cognize.entity.CompanyProductCognize;
import com.els.base.certification.cognize.entity.CompanyProductCognizeExample;
import com.els.base.certification.cognize.service.CompanyProductCognizeService;
import com.els.base.certification.contacts.entity.Contacts;
import com.els.base.certification.contacts.entity.ContactsExample;
import com.els.base.certification.contacts.service.ContactsService;
import com.els.base.certification.newcode.entity.CompanySupplierApply;
import com.els.base.certification.newcode.entity.CompanySupplierApplyExample;
import com.els.base.certification.newcode.entity.ProductTypeData;
import com.els.base.certification.newcode.service.CompanySupplierApplyService;
import com.els.base.certification.newcode.service.SupplierDataSendToSapService;
import com.els.base.certification.newcode.service.SupplierSapRelationService;
import com.els.base.certification.newcode.utils.CompanyNewCodeApplyEnum;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyProductCognizeService")
public class CompanyProductCognizeServiceImpl
implements CompanyProductCognizeService {
    private static final Logger logger = LoggerFactory.getLogger(CompanyProductCognizeServiceImpl.class);
    @Resource
    protected CompanyProductCognizeMapper companyProductCognizeMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected CompanySupplierApplyService companySupplierApplyService;
    @Resource
    private DicGroupItemService dicGroupItemService;
    @Resource
    private SupplierDataSendToSapService supplierDataSendToSapService;
    @Resource
    private SupplierSapRelationService supplierSapRelationService;
    @Resource
    protected ContactsService contactsService;
    private static final String PRODUCT_TYPE_COGNIZANCE_CODE = "PRODUCT_TYPE_COGNIZANCE_CODE";
    private static final String SAP_SUCCESS_SIGN = "SUCCESS";

    @Override
    @CacheEvict(value={"companyProductCognize"}, allEntries=true)
    public void addObj(CompanyProductCognize t) {
        this.companyProductCognizeMapper.insertSelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"companyProductCognize"}, allEntries=true)
    public void addAll(List<CompanyProductCognize> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.companyProductCognizeMapper.insertBatch(list);
    }

    @Override
    @CacheEvict(value={"companyProductCognize"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyProductCognizeMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"companyProductCognize"}, allEntries=true)
    public void modifyObj(CompanyProductCognize t) {
        Assert.isNotBlank(t.getId(), "id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.companyProductCognizeMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"companyProductCognize"}, keyGenerator="redisKeyGenerator")
    public CompanyProductCognize queryObjById(String id) {
        return this.companyProductCognizeMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"companyProductCognize"}, keyGenerator="redisKeyGenerator")
    public List<CompanyProductCognize> queryAllObjByExample(CompanyProductCognizeExample example) {
        return this.companyProductCognizeMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"companyProductCognize"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyProductCognize> queryObjByPage(CompanyProductCognizeExample example) {
        PageView<CompanyProductCognize> pageView = example.getPageView();
        pageView.setQueryResult(this.companyProductCognizeMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"companyProductCognize"}, allEntries=true)
    public void create(CompanyProductCognize data, String purCompanyId) {
        logger.debug("\u3010\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7\u3011\u6548\u9a8c\u6570\u636e!");
        this.checkSupplierData(data);
        this.isEqualToCompanySecondCompanyType(data);
        logger.debug("\u3010\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7\u3011\u53cd\u5199SAP!");
        String result = this.supplierDataSendToSapService.sendSupplierDataToSap(data);
        if (!SAP_SUCCESS_SIGN.equalsIgnoreCase(result)) {
            throw new CommonException("\u53cd\u5199SAP\u63a5\u53e3\u5f02\u5e38\uff1a" + result);
        }
        logger.debug("\u3010\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7\u3011\u4fdd\u5b58\u5355\u636e!");
        this.addObj(data);
        logger.debug("\u3010\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7\u3011\u66f4\u65b0\u4f9b\u5e94\u5546\u4e3b\u6570\u636e!");
        this.updateSupplierData(data);
        this.supplierSapRelationService.saveSupplierSapRelation(data);
        this.updateSupplierApplyProduct(data);
        this.updateProductCognizeData(data);
    }

    private void updateSupplierApplyProduct(CompanyProductCognize data) {
        CompanySupplierApplyExample example = new CompanySupplierApplyExample();
        example.createCriteria().andSupCompanyIdEqualTo(data.getSupCompanyId()).andIsEnableEqualTo(Constant.YES_INT);
        List list = this.companySupplierApplyService.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (CompanySupplierApply apply : list) {
            if (data.getProductTypeFirstCognizance() != null && data.getProductTypeFirstCognizance() == 2) {
                apply.setProductTypeFirstCognizance(Constant.YES_INT);
            }
            if (data.getProductTypeSecondCognizance() != null && data.getProductTypeSecondCognizance() == 2) {
                apply.setProductTypeSecondCognizance(Constant.YES_INT);
            }
            if (data.getProductTypeThirdCognizance() != null && data.getProductTypeThirdCognizance() == 2) {
                apply.setProductTypeThirdCognizance(Constant.YES_INT);
            }
            if (data.getProductTypeFourthCognizance() != null && data.getProductTypeFourthCognizance() == 2) {
                apply.setProductTypeFourthCognizance(Constant.YES_INT);
            }
            if (data.getProductTypeFifthCognizance() != null && data.getProductTypeFifthCognizance() == 2) {
                apply.setProductTypeFifthCognizance(Constant.YES_INT);
            }
            apply.setUpdateTime(new Date());
            this.companySupplierApplyService.modifyObj(apply);
        }
    }

    private void updateProductCognizeData(CompanyProductCognize data) {
        CompanyProductCognizeExample example = new CompanyProductCognizeExample();
        example.createCriteria().andSupCompanyIdEqualTo(data.getSupCompanyId()).andIsEnableEqualTo(Constant.YES_INT).andApplyBillNoNotEqualTo(data.getApplyBillNo());
        List<CompanyProductCognize> list = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (CompanyProductCognize companyProductCognize : list) {
            if (data.getProductTypeFirstCognizance() != null && data.getProductTypeFirstCognizance() > 1) {
                companyProductCognize.setProductTypeFirstCognizance(Constant.YES_INT);
            }
            if (data.getProductTypeSecondCognizance() != null && data.getProductTypeSecondCognizance() > 1) {
                companyProductCognize.setProductTypeSecondCognizance(Constant.YES_INT);
            }
            if (data.getProductTypeThirdCognizance() != null && data.getProductTypeThirdCognizance() > 1) {
                companyProductCognize.setProductTypeThirdCognizance(Constant.YES_INT);
            }
            if (data.getProductTypeFourthCognizance() != null && data.getProductTypeFourthCognizance() > 1) {
                companyProductCognize.setProductTypeFourthCognizance(Constant.YES_INT);
            }
            if (data.getProductTypeFifthCognizance() != null && data.getProductTypeFifthCognizance() > 1) {
                companyProductCognize.setProductTypeFifthCognizance(Constant.YES_INT);
            }
            companyProductCognize.setUpdateTime(new Date());
            this.modifyObj(companyProductCognize);
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"companyProductCognize"}, allEntries=true)
    public void modifyData(CompanyProductCognize data, String purCompanyId) {
        CompanyProductCognize oldData = this.queryObjById(data.getId());
        if (null == oldData) {
            throw new CommonException("\u65e7\u5355\u636e\u4e0d\u5b58\u5728!");
        }
        logger.debug("\u3010\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7\u3011\u6548\u9a8c\u6570\u636e!");
        this.checkSupplierData(data);
        this.isEqualToCompanySecondCompanyType(data);
        logger.debug("\u3010\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7\u3011\u53cd\u5199SAP!");
        String result = this.supplierDataSendToSapService.sendSupplierDataToSap(data);
        if (!SAP_SUCCESS_SIGN.equalsIgnoreCase(result)) {
            throw new CommonException("\u53cd\u5199SAP\u63a5\u53e3\u5f02\u5e38\uff1a" + result);
        }
        logger.debug("\u3010\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7\u3011\u66f4\u65b0\u5355\u636e!");
        data.setUpdateTime(new Date());
        this.modifyObj(data);
        logger.debug("\u3010\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7\u3011\u66f4\u65b0\u4f9b\u5e94\u5546\u4e3b\u6570\u636e!");
        this.updateSupplierData(data);
        this.supplierSapRelationService.saveSupplierSapRelation(data);
        this.updateSupplierApplyProductForUpdate(data, oldData);
        this.updateProductCognizeDataForUpdate(data, oldData);
    }

    private void updateSupplierApplyProductForUpdate(CompanyProductCognize newData, CompanyProductCognize oldData) {
        CompanySupplierApplyExample example = new CompanySupplierApplyExample();
        example.createCriteria().andSupCompanyIdEqualTo(newData.getSupCompanyId()).andIsEnableEqualTo(Constant.YES_INT);
        List list = this.companySupplierApplyService.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (CompanySupplierApply apply : list) {
            if (newData.getProductTypeFirstCognizance() != null && newData.getProductTypeFirstCognizance() == 2 && oldData.getProductTypeFirstCognizance() != null && oldData.getProductTypeFirstCognizance() == 0) {
                apply.setProductTypeFirstCognizance(Constant.YES_INT);
            } else if (oldData.getProductTypeFirstCognizance() != null && oldData.getProductTypeFirstCognizance() == 2 && newData.getProductTypeFirstCognizance() != null && newData.getProductTypeFirstCognizance() == 0) {
                apply.setProductTypeFirstCognizance(Constant.NO_INT);
            }
            if (newData.getProductTypeSecondCognizance() != null && newData.getProductTypeSecondCognizance() == 2 && oldData.getProductTypeSecondCognizance() != null && oldData.getProductTypeSecondCognizance() == 0) {
                apply.setProductTypeSecondCognizance(Constant.YES_INT);
            } else if (oldData.getProductTypeSecondCognizance() != null && oldData.getProductTypeSecondCognizance() == 2 && newData.getProductTypeSecondCognizance() != null && newData.getProductTypeSecondCognizance() == 0) {
                apply.setProductTypeSecondCognizance(Constant.NO_INT);
            }
            if (newData.getProductTypeThirdCognizance() != null && newData.getProductTypeThirdCognizance() == 2 && oldData.getProductTypeThirdCognizance() != null && oldData.getProductTypeThirdCognizance() == 0) {
                apply.setProductTypeThirdCognizance(Constant.YES_INT);
            } else if (oldData.getProductTypeThirdCognizance() != null && oldData.getProductTypeThirdCognizance() == 2 && newData.getProductTypeThirdCognizance() != null && newData.getProductTypeThirdCognizance() == 0) {
                apply.setProductTypeThirdCognizance(Constant.NO_INT);
            }
            if (newData.getProductTypeFourthCognizance() != null && newData.getProductTypeFourthCognizance() == 2 && oldData.getProductTypeFourthCognizance() != null && oldData.getProductTypeFourthCognizance() == 0) {
                apply.setProductTypeFourthCognizance(Constant.YES_INT);
            } else if (oldData.getProductTypeFourthCognizance() != null && oldData.getProductTypeFourthCognizance() == 2 && newData.getProductTypeFourthCognizance() != null && newData.getProductTypeFourthCognizance() == 0) {
                apply.setProductTypeFourthCognizance(Constant.NO_INT);
            }
            if (newData.getProductTypeFifthCognizance() != null && newData.getProductTypeFifthCognizance() == 2 && oldData.getProductTypeFifthCognizance() != null && oldData.getProductTypeFifthCognizance() == 0) {
                apply.setProductTypeFifthCognizance(Constant.YES_INT);
            } else if (oldData.getProductTypeFifthCognizance() != null && oldData.getProductTypeFifthCognizance() == 2 && newData.getProductTypeFifthCognizance() != null && newData.getProductTypeFifthCognizance() == 0) {
                apply.setProductTypeFifthCognizance(Constant.NO_INT);
            }
            apply.setUpdateTime(new Date());
            this.companySupplierApplyService.modifyObj(apply);
        }
    }

    private void updateProductCognizeDataForUpdate(CompanyProductCognize newData, CompanyProductCognize oldData) {
        CompanyProductCognizeExample example = new CompanyProductCognizeExample();
        example.createCriteria().andSupCompanyIdEqualTo(newData.getSupCompanyId()).andIsEnableEqualTo(Constant.YES_INT).andApplyBillNoNotEqualTo(newData.getApplyBillNo());
        List<CompanyProductCognize> list = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (CompanyProductCognize companyProductCognize : list) {
            if (newData.getProductTypeFirstCognizance() != null && newData.getProductTypeFirstCognizance() == 2 && oldData.getProductTypeFirstCognizance() != null && oldData.getProductTypeFirstCognizance() == 0) {
                companyProductCognize.setProductTypeFirstCognizance(Constant.YES_INT);
            } else if (oldData.getProductTypeFirstCognizance() != null && oldData.getProductTypeFirstCognizance() == 2 && newData.getProductTypeFirstCognizance() != null && newData.getProductTypeFirstCognizance() == 0) {
                companyProductCognize.setProductTypeFirstCognizance(Constant.NO_INT);
            }
            if (newData.getProductTypeSecondCognizance() != null && newData.getProductTypeSecondCognizance() == 2 && oldData.getProductTypeSecondCognizance() != null && oldData.getProductTypeSecondCognizance() == 0) {
                companyProductCognize.setProductTypeSecondCognizance(Constant.YES_INT);
            } else if (oldData.getProductTypeSecondCognizance() != null && oldData.getProductTypeSecondCognizance() == 2 && newData.getProductTypeSecondCognizance() != null && newData.getProductTypeSecondCognizance() == 0) {
                companyProductCognize.setProductTypeSecondCognizance(Constant.NO_INT);
            }
            if (newData.getProductTypeThirdCognizance() != null && newData.getProductTypeThirdCognizance() == 2 && oldData.getProductTypeThirdCognizance() != null && oldData.getProductTypeThirdCognizance() == 0) {
                companyProductCognize.setProductTypeThirdCognizance(Constant.YES_INT);
            } else if (oldData.getProductTypeThirdCognizance() != null && oldData.getProductTypeThirdCognizance() == 2 && newData.getProductTypeThirdCognizance() != null && newData.getProductTypeThirdCognizance() == 0) {
                companyProductCognize.setProductTypeThirdCognizance(Constant.NO_INT);
            }
            if (newData.getProductTypeFourthCognizance() != null && newData.getProductTypeFourthCognizance() == 2 && oldData.getProductTypeFourthCognizance() != null && oldData.getProductTypeFourthCognizance() == 0) {
                companyProductCognize.setProductTypeFourthCognizance(Constant.YES_INT);
            } else if (oldData.getProductTypeFourthCognizance() != null && oldData.getProductTypeFourthCognizance() == 2 && newData.getProductTypeFourthCognizance() != null && newData.getProductTypeFourthCognizance() == 0) {
                companyProductCognize.setProductTypeFourthCognizance(Constant.NO_INT);
            }
            if (newData.getProductTypeFifthCognizance() != null && newData.getProductTypeFifthCognizance() == 2 && oldData.getProductTypeFifthCognizance() != null && oldData.getProductTypeFifthCognizance() == 0) {
                companyProductCognize.setProductTypeFifthCognizance(Constant.YES_INT);
            } else if (oldData.getProductTypeFifthCognizance() != null && oldData.getProductTypeFifthCognizance() == 2 && newData.getProductTypeFifthCognizance() != null && newData.getProductTypeFifthCognizance() == 0) {
                companyProductCognize.setProductTypeFifthCognizance(Constant.NO_INT);
            }
            companyProductCognize.setUpdateTime(new Date());
            this.modifyObj(companyProductCognize);
        }
    }

    private void isEqualToCompanySecondCompanyType(CompanyProductCognize data) {
        Company company = (Company)this.companyService.queryObjById(data.getSupCompanyId());
        if (null == company) {
            throw new CommonException("\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728!");
        }
        if (StringUtils.isNotBlank((String)company.getSecondCompanyType()) && !company.getSecondCompanyType().equals(data.getProductServiceType())) {
            throw new CommonException("\u5f53\u524d\u5355\u636e\u7684\u4f9b\u5e94\u5546\u4ea7\u54c1\u5927\u7c7b\u4e0e\u4e3b\u6570\u636e\u4ea7\u54c1\u5927\u7c7b\u4e0d\u4e00\u81f4,\u8bf7\u91cd\u65b0\u751f\u6210\u5355\u636e!");
        }
    }

    private void updateSupplierData(CompanyProductCognize data) {
        DicGroupItem deliveryModeDicItem;
        Company company = new Company();
        company.setId(data.getSupCompanyId());
        company.setEnglishCompanyName(data.getSupCompanyEnglishName());
        company.setCompanyName(data.getSupCompanyShortName());
        company.setCompanyFullName(data.getSupCompanyName());
        company.setFax(data.getFax());
        company.setCompanyType(data.getCompanyType());
        company.setBusinessLicenseNumber(data.getBusinessLicenseNumber());
        company.setIndustryCode(data.getIndustryCode());
        company.setIndustryDesc(data.getIndustryDesc());
        company.setWebsite(data.getWebsite());
        company.setOrderCurren(data.getOrderCurren());
        if (StringUtils.isNotEmpty((String)data.getOrderCurren()) && null != (deliveryModeDicItem = this.dicGroupItemService.queryItems("zr_ordercurren", data.getOrderCurren()))) {
            company.setOrderCurrenDesc(deliveryModeDicItem.getName());
        }
        company.setExternalManufacturer(data.getTradeStyle());
        company.setPayConditionsCode(data.getBalanceStyle());
        company.setPaymentPeriod(data.getBalanceStyle());
        if (StringUtils.isNotEmpty((String)data.getBalanceStyle()) && null != (deliveryModeDicItem = this.dicGroupItemService.queryItems("zr_fukuanfangshi", data.getBalanceStyle()))) {
            company.setPayConditionsDesc(deliveryModeDicItem.getName());
            company.setPaymentPeriodDesc(deliveryModeDicItem.getName());
        }
        company.setCountry(data.getCountryCode());
        company.setPurchasingGroup(data.getPurchaseOrganization());
        company.setGroupCode(data.getSupplierDevelopLeader());
        company.setBusinessType(data.getSecondClassification());
        company.setFirstCompanyType(data.getFirstClassification());
        company.setIndustrialType(data.getSapIndustryCode());
        company.setClassificationThree(data.getThirdClassification());
        company.setDelegateType(data.getCompanyTypeDesc());
        company.setProvince(data.getArea());
        company.setPurchaseCycle(data.getPurchaseCycle());
        company.setSupplierDevelopLeader(data.getSupplierDevelopLeader());
        company.setSqaLeader(data.getSqaLeader());
        company.setIsWriteSapSuccess(Constant.YES_INT);
        if (data.getProductTypeFirstCognizance() > 0) {
            company.setProductTypeFirstCognizance(Constant.YES_INT);
        } else {
            company.setProductTypeFirstCognizance(Constant.NO_INT);
        }
        if (data.getProductTypeSecondCognizance() > 0) {
            company.setProductTypeSecondCognizance(Constant.YES_INT);
        } else {
            company.setProductTypeSecondCognizance(Constant.NO_INT);
        }
        if (data.getProductTypeThirdCognizance() > 0) {
            company.setProductTypeThirdCognizance(Constant.YES_INT);
        } else {
            company.setProductTypeThirdCognizance(Constant.NO_INT);
        }
        if (data.getProductTypeFourthCognizance() > 0) {
            company.setProductTypeFourthCognizance(Constant.YES_INT);
        } else {
            company.setProductTypeFourthCognizance(Constant.NO_INT);
        }
        if (data.getProductTypeFifthCognizance() > 0) {
            company.setProductTypeFifthCognizance(Constant.YES_INT);
        } else {
            company.setProductTypeFifthCognizance(Constant.NO_INT);
        }
        this.companyService.modifyObj(company);
    }

    private void checkSupplierData(CompanyProductCognize data) {
        if (StringUtils.isEmpty((String)data.getSupCompanySapCode())) {
            throw new CommonException("\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getCompanyCode())) {
            throw new CommonException("\u516c\u53f8\u4ee3\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getPurchaseOrganization())) {
            throw new CommonException("\u91c7\u8d2d\u7ec4\u7ec7\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getSupplierAccountGroup())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u8d26\u6237\u7ec4\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getSupCompanyName())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u4e2d\u6587\u540d\u79f0\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getSupCompanyShortName())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u7b80\u79f0\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getSupCompanyAddress())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u5730\u5740\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getCountryCode())) {
            throw new CommonException("\u56fd\u5bb6\u4ee3\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getArea())) {
            throw new CommonException("\u5730\u533a\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getTelephone())) {
            throw new CommonException("\u7535\u8bdd\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getFax())) {
            throw new CommonException("\u4f20\u771f\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getEmail())) {
            throw new CommonException("\u90ae\u4ef6\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getSupplierDevelopLeader())) {
            throw new CommonException("\u5f00\u53d1\u90e8\u62c5\u5f53\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (data.getSupplierDevelopLeader().length() > 10) {
            throw new CommonException("SAP\u8981\u6c42\u8f93\u5165\u7684\u5f00\u53d1\u90e8\u62c5\u5f53\u5b57\u6570\u4e0d\u80fd\u8d85\u8fc710!");
        }
        if (StringUtils.isEmpty((String)data.getCompanyType())) {
            throw new CommonException("\u4f01\u4e1a\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)data.getCompanyTypeDesc())) {
            throw new CommonException("\u4f01\u4e1a\u7c7b\u578b\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)data.getSecondClassification())) {
            throw new CommonException("\u5206\u7c7b2\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getSapIndustryCode())) {
            throw new CommonException("\u5de5\u4e1a\u7c7b\u578b\u4ee3\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getIndustryCode())) {
            throw new CommonException("\u884c\u4e1a\u4ee3\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getTradeStyle())) {
            throw new CommonException("\u4ea4\u6613\u65b9\u5f0f\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getBalanceStyle())) {
            throw new CommonException("\u7ed3\u7b97\u65b9\u5f0f\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getOrderCurren())) {
            throw new CommonException("\u8d27\u5e01\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
    }

    @Override
    public void setProductTypeJsonData(CompanyProductCognize data) {
        ArrayList<ProductTypeData> list = null;
        if (StringUtils.isNotBlank((String)data.getProductTypeFirst())) {
            list = new ArrayList<ProductTypeData>();
            ProductTypeData firstCompanyType = new ProductTypeData();
            firstCompanyType.setCode(data.getProductTypeFirst());
            firstCompanyType.setDesc(data.getProductTypeFirstDesc());
            firstCompanyType.setFlag(data.getProductTypeFirstCognizance());
            list.add(firstCompanyType);
            if (StringUtils.isNotBlank((String)data.getProductTypeSecond())) {
                ProductTypeData secondCompanyType = new ProductTypeData();
                secondCompanyType.setCode(data.getProductTypeSecond());
                secondCompanyType.setDesc(data.getProductTypeSecondDesc());
                secondCompanyType.setFlag(data.getProductTypeSecondCognizance());
                list.add(secondCompanyType);
                if (StringUtils.isNotBlank((String)data.getProductTypeThird())) {
                    ProductTypeData thirdCompanyType = new ProductTypeData();
                    thirdCompanyType.setCode(data.getProductTypeThird());
                    thirdCompanyType.setDesc(data.getProductTypeThirdDesc());
                    thirdCompanyType.setFlag(data.getProductTypeThirdCognizance());
                    list.add(thirdCompanyType);
                    if (StringUtils.isNotBlank((String)data.getProductTypeFourth())) {
                        ProductTypeData fourthCompanyType = new ProductTypeData();
                        fourthCompanyType.setCode(data.getProductTypeFourth());
                        fourthCompanyType.setDesc(data.getProductTypeFourthDesc());
                        fourthCompanyType.setFlag(data.getProductTypeFourthCognizance());
                        list.add(fourthCompanyType);
                        if (StringUtils.isNotBlank((String)data.getProductTypeFifth())) {
                            ProductTypeData fifthCompanyType = new ProductTypeData();
                            fifthCompanyType.setCode(data.getProductTypeFifth());
                            fifthCompanyType.setDesc(data.getProductTypeFifthDesc());
                            fifthCompanyType.setFlag(data.getProductTypeFifthCognizance());
                            list.add(fifthCompanyType);
                        }
                    }
                }
            }
        }
        data.setProductTypeJson(list);
    }

    @Override
    public CompanyProductCognize generateBillInfo(Company company) {
        DicGroupItem areaItem;
        DicGroupItem companyTypeItem;
        if (null == company) {
            throw new CommonException("\u4f20\u9012\u7684\u53c2\u6570\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)company.getId())) {
            throw new CommonException("\u4f20\u9012\u7684\u4f9b\u5e94\u5546id\u4e3a\u7a7a!");
        }
        Company com = (Company)this.companyService.queryObjById(company.getId());
        if (null == com) {
            throw new CommonException("\u67e5\u8be2\u4e0d\u5230\u4f9b\u5e94\u5546\u6570\u636e!");
        }
        CompanyProductCognize data = new CompanyProductCognize();
        data.setId(UUIDGenerator.generateUUID());
        Company purCompany = this.companyService.queryPurchaseCompanies(company.getId());
        data.setPurCompanyId(purCompany.getId());
        data.setPurCompanySrmCode(purCompany.getCompanyCode());
        data.setPurCompanyName(purCompany.getCompanyFullName());
        data.setPurCompanyShortName(purCompany.getCompanyName());
        data.setSupCompanyId(com.getId());
        data.setSupCompanySapCode(com.getCompanySapCode());
        data.setSupCompanySrmCode(com.getCompanyCode());
        data.setSupCompanyName(com.getCompanyFullName());
        data.setSupCompanyShortName(com.getCompanyName());
        data.setSupCompanyEnglishName(com.getEnglishCompanyName());
        data.setSupCompanyEnglishShortName(com.getCompanyEnglishAbbreviation());
        data.setSupCompanyAddress(com.getAddress());
        data.setSupCompanyEnglishAddress(com.getEnglishAddress());
        String applyBillNo = this.generateCodeService.getNextCode(PRODUCT_TYPE_COGNIZANCE_CODE);
        data.setApplyBillNo(applyBillNo);
        if (StringUtils.isNotBlank((String)com.getCompanyType()) && null != (companyTypeItem = this.dicGroupItemService.queryItems("company_type", com.getCompanyType()))) {
            data.setCompanyType(com.getCompanyType());
            data.setCompanyTypeDesc(companyTypeItem.getDescription());
        }
        data.setBusinessLicenseNumber(com.getBusinessLicenseNumber());
        data.setProductServiceType(com.getSecondCompanyType());
        data.setProductServiceDesc(com.getSecondCompanyTypeDesc());
        data.setProductTypeFirst(com.getProductTypeFirst());
        data.setProductTypeFirstDesc(com.getProductTypeFirstDesc());
        data.setProductTypeFirstCognizance(com.getProductTypeFirstCognizance());
        data.setProductTypeSecond(com.getProductTypeSecond());
        data.setProductTypeSecondDesc(com.getProductTypeSecondDesc());
        data.setProductTypeSecondCognizance(com.getProductTypeSecondCognizance());
        data.setProductTypeThird(com.getProductTypeThird());
        data.setProductTypeThirdDesc(com.getProductTypeThirdDesc());
        data.setProductTypeThirdCognizance(com.getProductTypeThirdCognizance());
        data.setProductTypeFourth(com.getProductTypeFourth());
        data.setProductTypeFourthDesc(com.getProductTypeFourthDesc());
        data.setProductTypeFourthCognizance(com.getProductTypeFourthCognizance());
        data.setProductTypeFifth(com.getProductTypeFifth());
        data.setProductTypeFifthDesc(com.getProductTypeFifthDesc());
        data.setProductTypeFifthCognizance(com.getProductTypeFifthCognizance());
        data.setCompanyCode("3000");
        if (StringUtils.isNotEmpty((String)com.getCountry())) {
            data.setCountryCode(com.getCountry());
        } else {
            data.setCountryCode("CN");
        }
        data.setGroupCode(com.getGroupCode());
        data.setPurchaseOrganization(com.getPurchasingGroup());
        data.setIndustryCode(com.getIndustryCode());
        data.setFirstClassification(com.getFirstCompanyType());
        data.setThirdClassification(com.getClassificationThree());
        data.setSecondClassification(com.getBusinessType());
        data.setSapIndustryCode(com.getIndustrialType());
        data.setTradeStyle(com.getExternalManufacturer());
        data.setMobilephone(com.getMobilephone());
        data.setTelephone(com.getTelephone());
        data.setFax(com.getFax());
        data.setEmail(com.getEmail());
        data.setWebsite(com.getWebsite());
        data.setSapIndustryCode(com.getIndustrialType());
        data.setOrderCurren("CNY");
        data.setBalanceStyle(com.getPayConditionsCode());
        data.setPurchaseCycle(com.getPurchaseCycle());
        data.setSearchItem(com.getCompanyName());
        data.setSupplierAccountGroup("FGE1");
        if (StringUtils.isNotBlank((String)com.getProvince()) && null != (areaItem = this.dicGroupItemService.queryItems("area_code", com.getProvince()))) {
            data.setArea(com.getProvince());
            data.setAreaName(areaItem.getValue());
        }
        data.setApproveStatus(CompanyNewCodeApplyEnum.STATUS_UN_APPROVE.getStatus());
        data.setIsEnable(Constant.YES_INT);
        data.setCreateBillTime(new Date());
        data.setCreateTime(new Date());
        List<Contacts> list = this.findContactsByCompanyId(com.getId());
        if (CollectionUtils.isNotEmpty(list)) {
            data.setContacts(list.get(0).getName());
        }
        data.setSupplierDevelopLeader(com.getSupplierDevelopLeader());
        data.setSqaLeader(com.getSqaLeader());
        this.setProductTypeJsonData(data);
        if (StringUtils.isNotEmpty((String)com.getCompanySapCode()) && com.getCompanySapCode().startsWith("1")) {
            data.setSupplierType("1");
        } else if (StringUtils.isNotEmpty((String)com.getCompanySapCode()) && com.getCompanySapCode().startsWith("2")) {
            data.setSupplierType("2");
        }
        return data;
    }

    private List<Contacts> findContactsByCompanyId(String companyId) {
        if (StringUtils.isEmpty((String)companyId)) {
            return null;
        }
        ContactsExample example = new ContactsExample();
        example.createCriteria().andSupCompanyIdEqualTo(companyId);
        List<Contacts> list = this.contactsService.queryAllObjByExample(example);
        return list;
    }
}

