/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.newcode.utils;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.utils.pdf.HtmlToPdfUtils;
import com.els.base.utils.template.BeetlTemplateUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompanyNewCodeApplyUtils {
    private static final Logger log = LoggerFactory.getLogger(CompanyNewCodeApplyUtils.class);

    public static FileData generatePdf(String projectId, String companyId, Map<String, Object> params, String printType) throws Exception {
        log.debug("\u3010\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u6253\u5370\u3011");
        String filename = null;
        FileData pdfFile = null;
        String html = null;
        switch (printType) {
            case "A4": {
                html = BeetlTemplateUtils.renderFromFile((String)"new_code.html", params);
                filename = "\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7\u8868_A4_" + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm");
                pdfFile = CompanyNewCodeApplyUtils.createEmptyPDF(projectId, companyId, filename);
                HtmlToPdfUtils.generatePdf((String)html, (File)pdfFile.toFile(), (String)"A4", (boolean)false, (String)filename);
                break;
            }
            default: {
                throw new CommonException("\u4e0d\u652f\u6301\u5f53\u524d\u6253\u5370\u7c7b\u578b[" + printType + "]");
            }
        }
        return pdfFile;
    }

    private static FileData createEmptyPDF(String projectId, String companyId, String filename) throws IOException {
        FileData pdfFile = new FileData();
        pdfFile.setProjectId(projectId);
        pdfFile.setCompanyId(companyId);
        pdfFile.setFileName(filename + ".pdf");
        pdfFile.setFileSuffix("pdf");
        pdfFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
        pdfFile.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
        pdfFile = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), pdfFile);
        return pdfFile;
    }
}

