/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.relation.web.controller;

import com.els.base.certification.common.CompanyFinishFlag;
import com.els.base.certification.relation.entity.CompanySupplyRelation;
import com.els.base.certification.relation.entity.CompanySupplyRelationExample;
import com.els.base.certification.relation.service.CompanySupplyRelationService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f9b\u5e94\u5546\u51c6\u5165-\u5458\u5de5\u4f9b\u8d27\u5173\u7cfb")
@Controller
@RequestMapping(value={"companySupplyRelation"})
public class CompanySupplyRelationController {
    @Resource
    private CompanySupplyRelationService companySupplyRelationService;
    @Resource
    private CompanyService companyService;

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u521b\u5efa\u5458\u5de5\u4f9b\u8d27\u5173\u7cfb")
    @RequestMapping(value={"service/batchInsert"})
    @ResponseBody
    public ResponseResult<CompanyFinishFlag> batchInsert(@RequestBody List<CompanySupplyRelation> companySupplyRelationList) {
        if (CollectionUtils.isEmpty(companySupplyRelationList)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        Integer relationStatus = this.companySupplyRelationService.batchInsert(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(), companySupplyRelationList);
        CompanyFinishFlag companyFinishFlag = new CompanyFinishFlag();
        companyFinishFlag.setEmployeeSupplyRelationship(relationStatus);
        return ResponseResult.success(companyFinishFlag);
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u5458\u5de5\u4f9b\u8d27\u5173\u7cfb")
    @RequestMapping(value={"service/deleteObjByIds"})
    @ResponseBody
    public ResponseResult<String> deleteObjByIds(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companySupplyRelationService.deleteObjByIds(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(), ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5458\u5de5\u4f9b\u8d27\u5173\u7cfb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="supCompanySrmCode", required=false, value="\u4f9b\u5e94\u5546SRM\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanySupplyRelation", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanySupplyRelation>> findByPage(@RequestParam(required=false) String supCompanySrmCode, @RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanySupplyRelationExample example = new CompanySupplyRelationExample();
        example.setPageView(new PageView<CompanySupplyRelation>(pageNo, pageSize));
        CompanySupplyRelationExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isBlank((String)supCompanySrmCode)) {
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsEnableEqualTo(Constant.YES_INT);
        } else {
            Company company = this.companyService.queryCompanyByCode(supCompanySrmCode);
            if (company == null) {
                throw new CommonException("\u516c\u53f8\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        }
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.companySupplyRelationService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5168\u90e8\u5458\u5de5\u4f9b\u8d27\u5173\u7cfb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="supCompanySrmCode", required=false, value="\u4f9b\u5e94\u5546SRM\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanySupplyRelation", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findAll"})
    @ResponseBody
    public ResponseResult<List<CompanySupplyRelation>> findAll(@RequestParam(required=false) String supCompanySrmCode, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanySupplyRelationExample example = new CompanySupplyRelationExample();
        CompanySupplyRelationExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isBlank((String)supCompanySrmCode)) {
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsEnableEqualTo(Constant.YES_INT);
        } else {
            Company company = this.companyService.queryCompanyByCode(supCompanySrmCode);
            if (company == null) {
                throw new CommonException("\u516c\u53f8\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        }
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        List companySupplyRelationList = this.companySupplyRelationService.queryAllObjByExample(example);
        return ResponseResult.success(companySupplyRelationList);
    }
}

