
CREATE TABLE "T_BASE_COMPANY_AUTH" (
"ID" VARCHAR2(32 BYTE) DEFAULT ''  NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) DEFAULT ''  NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"CERTIFICATE_TYPE_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"CERTIFICATE_TYPE_CODE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"CERTIFICATE_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"CERTIFICATION_AUTHORITY" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"CERTIFICATE_CREATE_TIME" DATE NULL ,
"START_TIME" DATE NULL ,
"END_TIME" DATE NULL ,
"CREATE_TIME" DATE NULL ,
"UPDATE_TIME" DATE NULL,
"EFFECTIVE_DATE" NUMBER(7) NULL ,
"REMARK" VARCHAR2(1000 BYTE) NULL ,
"CERTIFICATE_FILE" VARCHAR2(1000 BYTE) NULL ,
"FINISH_FLAG" NUMBER(7) DEFAULT 0  NULL ,
"IS_ENABLE" NUMBER(7) DEFAULT 1  NULL
);


COMMENT ON TABLE "T_BASE_COMPANY_AUTH" IS '企业通过的认证';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."CERTIFICATE_TYPE_NAME" IS '证书类型名称';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."CERTIFICATE_TYPE_CODE" IS '证书类型CODE值';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."CERTIFICATE_NAME" IS '证书名称,类型';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."CERTIFICATION_AUTHORITY" IS '认证机构';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."CERTIFICATE_CREATE_TIME" IS '证书签发日期';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."START_TIME" IS '证书开始时间';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."END_TIME" IS '结束时间';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."CREATE_TIME" IS '上传时间';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."EFFECTIVE_DATE" IS '有效天数(天)';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."CERTIFICATE_FILE" IS '证书文件';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."FINISH_FLAG" IS '完成标识符(0=未完成，1=已完成)';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN "T_BASE_COMPANY_AUTH"."UPDATE_TIME" IS '更新时间';


ALTER TABLE "T_BASE_COMPANY_AUTH" ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE "T_BASE_COMPANY_AUTH" ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE "T_BASE_COMPANY_AUTH" ADD PRIMARY KEY ("ID");
