
CREATE TABLE T_BASE_COMPANY_SUPPLIER_APPLY (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SHORT_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SHORT_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ENGLISH_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ENGLISH_SHORT_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ADDRESS" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ENGLISH_ADDRESS" VARCHAR2(255 BYTE) NULL ,
"APPLY_BILL_NO" VARCHAR2(255 BYTE) NULL ,
"COMPANY_TYPE" VARCHAR2(255 BYTE) NULL ,
"BUSINESS_LICENSE_NUMBER" VARCHAR2(255 BYTE) NULL ,
"PRODUCT_SERVICE_TYPE" VARCHAR2(255 BYTE) NULL ,
"PRODUCT_SERVICE_DESC" VARCHAR2(255 BYTE) NULL ,
"MOBILEPHONE" VARCHAR2(255 BYTE) NULL ,
"TELEPHONE" VARCHAR2(255 BYTE) NULL ,
"FAX" VARCHAR2(255 BYTE) NULL ,
"EMAIL" VARCHAR2(255 BYTE) NULL ,
"WEBSITE" VARCHAR2(255 BYTE) NULL ,
"TAX_RATE" VARCHAR2(255 BYTE) NULL ,
"ORDER_CURREN" VARCHAR2(255 BYTE) NULL ,
"TRADE_STYLE" VARCHAR2(255 BYTE) NULL ,
"TRADE_STYLE_DESC" VARCHAR2(255 BYTE) NULL ,
"BALANCE_STYLE" VARCHAR2(255 BYTE) NULL ,
"PURCHASE_CYCLE" VARCHAR2(255 BYTE) NULL ,
"OTHER_INFO" VARCHAR2(255 BYTE) NULL ,
"FIRST_CLASSIFICATION" VARCHAR2(255 BYTE) NULL ,
"SECOND_CLASSIFICATION" VARCHAR2(255 BYTE) NULL ,
"SECOND_CLASSIFICATION_DESC" VARCHAR2(255 BYTE) NULL ,
"THIRD_CLASSIFICATION" VARCHAR2(255 BYTE) NULL ,
"FOUTH_CLASSIFICATION" VARCHAR2(255 BYTE) NULL ,
"COMPANY_CODE" VARCHAR2(255 BYTE) NULL ,
"PURCHASE_ORGANIZATION" VARCHAR2(255 BYTE) NULL ,
"SUPPLIER_ACCOUNT_GROUP" VARCHAR2(255 BYTE) NULL ,
"SEARCH_ITEM" VARCHAR2(255 BYTE) NULL ,
"COUNTRY_CODE" VARCHAR2(255 BYTE) NULL ,
"AREA" VARCHAR2(255 BYTE) NULL ,
"GROUP_CODE" VARCHAR2(255 BYTE) NULL ,
"REPRESENT_NAME" VARCHAR2(255 BYTE) NULL ,
"INDUSTRY_CODE" VARCHAR2(255 BYTE) NULL ,
"INDUSTRY_DESC" VARCHAR2(255 BYTE) NULL ,
"SAP_INDUSTRY_CODE" VARCHAR2(255 BYTE) NULL ,
"SAP_INDUSTRY_DESC" VARCHAR2(255 BYTE) NULL ,
"PROPOSER" VARCHAR2(255 BYTE) NULL ,
"SUPPLIER_TYPE" NUMBER(7) NULL ,
"CREATE_BILL_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"CREATE_BILL_TIME" DATE NULL ,
"APPROVE_SUGGESTION" VARCHAR2(1000 BYTE) NULL ,
"CONTACTS" VARCHAR2(255 BYTE) NULL ,
"APPROVE_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"APPROVE_TIME" DATE NULL ,
"APPROVE_STATUS" NUMBER(7) DEFAULT 1  NULL ,
"IS_ENABLE" NUMBER(7) DEFAULT 1  NULL ,
"REMARK" VARCHAR2(1000 BYTE) NULL ,
"CREATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"UPDATE_TIME" DATE NULL 
)

;
COMMENT ON TABLE T_BASE_COMPANY_SUPPLIER_APPLY IS '新供应商编码申请';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."ID" IS '主键';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."PUR_COMPANY_ID" IS '采购商id';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."PUR_COMPANY_NAME" IS '采购商全称';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."PUR_COMPANY_SHORT_NAME" IS '采购商简称';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."SUP_COMPANY_ID" IS '供应商的id';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."SUP_COMPANY_SAP_CODE" IS '供应商的SAP编码';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."SUP_COMPANY_SRM_CODE" IS '供应商的SRM编码';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."SUP_COMPANY_NAME" IS '供应商的中文全称';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."SUP_COMPANY_SHORT_NAME" IS '供应商的中文简称';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."SUP_COMPANY_ENGLISH_NAME" IS '供应商的英文全称';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."SUP_COMPANY_ENGLISH_SHORT_NAME" IS '供应商的英文简称';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."SUP_COMPANY_ADDRESS" IS '供应商的中文地址';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."SUP_COMPANY_ENGLISH_ADDRESS" IS '供应商的英文地址';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."APPLY_BILL_NO" IS '单据号';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."COMPANY_TYPE" IS '企业类型';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."BUSINESS_LICENSE_NUMBER" IS '营业执照号';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."PRODUCT_SERVICE_TYPE" IS '产品服务类型';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."PRODUCT_SERVICE_DESC" IS '产品服务描述';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."MOBILEPHONE" IS '移动电话';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."TELEPHONE" IS '固定电话';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."FAX" IS '传真';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."EMAIL" IS '邮箱';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."WEBSITE" IS '网址';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."TAX_RATE" IS '税率';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."ORDER_CURREN" IS '币别';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."TRADE_STYLE" IS '交易方式(存放外部制造商编码)';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."TRADE_STYLE_DESC" IS '交易方式(存放外部制造商描述)';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."BALANCE_STYLE" IS '结算方式';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."PURCHASE_CYCLE" IS '采购周期';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."OTHER_INFO" IS '其他信息';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."FIRST_CLASSIFICATION" IS '分类1';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."SECOND_CLASSIFICATION" IS '分类2(存放业务类型代码)';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."SECOND_CLASSIFICATION_DESC" IS '分类2(存放业务类型描述)';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."THIRD_CLASSIFICATION" IS '分类3';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."FOUTH_CLASSIFICATION" IS '分类4';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."COMPANY_CODE" IS '公司代码';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."PURCHASE_ORGANIZATION" IS '采购组织';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."SUPPLIER_ACCOUNT_GROUP" IS '供应商账户组';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."SEARCH_ITEM" IS '检索项';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."COUNTRY_CODE" IS '国家代码';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."AREA" IS '地区';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."GROUP_CODE" IS '组代码';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."REPRESENT_NAME" IS '代表名称';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."INDUSTRY_CODE" IS '行业代码';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."INDUSTRY_DESC" IS '行业描述';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."SAP_INDUSTRY_CODE" IS '工业类型代码';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."SAP_INDUSTRY_DESC" IS '工业类型描述';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."PROPOSER" IS '申请人';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."SUPPLIER_TYPE" IS '供应商类别(1=内购,2=外购)';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."CREATE_BILL_USER_NAME" IS '制单人';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."CREATE_BILL_TIME" IS '制单时间';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."APPROVE_SUGGESTION" IS '审批意见';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."CONTACTS" IS '联系人';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."APPROVE_USER_NAME" IS '审批人';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."APPROVE_TIME" IS '审批时间';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."APPROVE_STATUS" IS '审批状态（1=未审核,2=正在审核,3=审核通过,4=驳回）';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."REMARK" IS '备注';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN T_BASE_COMPANY_SUPPLIER_APPLY."UPDATE_TIME" IS '修改时间';


ALTER TABLE T_BASE_COMPANY_SUPPLIER_APPLY ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE T_BASE_COMPANY_SUPPLIER_APPLY ADD CHECK ("ID" IS NOT NULL);


ALTER TABLE T_BASE_COMPANY_SUPPLIER_APPLY ADD PRIMARY KEY ("ID");
