CREATE TABLE T_BASE_COMPANY_PRODUCT_SERVICE (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"PRODUCT_SERVICE_NAME" VARCHAR2(255 BYTE) NULL ,
"PRODUCT_QUANTITY" NUMBER(20,2) NULL ,
"SALE_AMOUNT" NUMBER(20,2) NULL ,
"SALE_PERCENT" NUMBER(20,2) NULL ,
"SURPLUS_CAPACITY_PERCENT" NUMBER(20,2) NULL ,
"MP_TIME" VARCHAR2(255 BYTE) NULL ,
"PURCHASE_CYCLE" VARCHAR2(255 BYTE) NULL ,
"EXPLAINATION"  VARCHAR2(1000 BYTE) NULL ,
"IS_ENABLE" NUMBER(7,0) DEFAULT 1 NULL,
"FINISH_FLAG" NUMBER(7,0) DEFAULT 0 NULL,
"CREATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"UPDATE_TIME" DATE NULL 
)
;

COMMENT ON TABLE T_BASE_COMPANY_PRODUCT_SERVICE IS '供应商准入-主要产品/服务';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_SERVICE."ID" IS '主键';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_SERVICE."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_SERVICE."PUR_COMPANY_ID" IS '采购商公司ID';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_SERVICE."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_SERVICE."PUR_COMPANY_NAME" IS '采购商名称';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_SERVICE."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_SERVICE."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_SERVICE."SUP_COMPANY_NAME" IS '供应商名称';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_SERVICE."PRODUCT_SERVICE_NAME" IS '主要产品/服务名称';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_SERVICE."PRODUCT_QUANTITY" IS '年生产数量';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_SERVICE."SALE_AMOUNT" IS '销售额';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_SERVICE."SALE_PERCENT" IS '该产品/服务占企业总销售额的百分比';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_SERVICE."SURPLUS_CAPACITY_PERCENT" IS '剩余产能百分比';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_SERVICE."PURCHASE_CYCLE" IS '正常采购周期';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_SERVICE."MP_TIME" IS '产品量产的时间';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_SERVICE."EXPLAINATION" IS '说明';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_SERVICE."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_SERVICE."FINISH_FLAG" IS '完成标识符(0=未完成，1=已完成)';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_SERVICE."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_SERVICE."UPDATE_TIME" IS '修改时间';


ALTER TABLE T_BASE_COMPANY_PRODUCT_SERVICE ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE T_BASE_COMPANY_PRODUCT_SERVICE ADD PRIMARY KEY ("ID");
