/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.cognize.service.impl;

import com.els.base.certification.cognize.entity.CompanyProductCognize;
import com.els.base.certification.cognize.entity.CompanyProductCognizeExample;
import com.els.base.certification.cognize.service.CompanyProductCognizeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyProductType;
import com.els.base.company.service.CertificationProductCognizeService;
import com.els.base.core.utils.Constant;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;

@Service(value="CertificationProductCognizeService")
public class CertificationProductCognizeServiceImpl
implements CertificationProductCognizeService {
    private static final Integer FLAG = 2;
    @Resource
    private CompanyProductCognizeService companyProductCognizeService;

    @Override
    @CacheEvict(value={"companyProductCognize"}, allEntries=true)
    public void updateProductCognizeProductType(Company company) {
        CompanyProductCognizeExample example = new CompanyProductCognizeExample();
        example.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        List list = this.companyProductCognizeService.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (CompanyProductCognize companyProductCognize : list) {
            CompanyProductCognize data = new CompanyProductCognize();
            data.setId(companyProductCognize.getId());
            data.setProductServiceType(company.getSecondCompanyType());
            data.setProductServiceDesc(company.getSecondCompanyTypeDesc());
            this.cleanSupplierCompanyType(data);
            Map<String, Integer> map = this.generateFlagMap(companyProductCognize);
            this.setFiveProductType(data, company.getProductTypeJson(), map);
            data.setUpdateTime(new Date());
            this.companyProductCognizeService.modifyObj(data);
        }
    }

    private void setFiveProductType(CompanyProductCognize apply, List<CompanyProductType> list, Map<String, Integer> map) {
        apply.setProductTypeFirst(list.get(0).getCode());
        apply.setProductTypeFirstDesc(list.get(0).getDesc());
        if (map.containsKey(list.get(0).getCode())) {
            apply.setProductTypeFirstCognizance(FLAG);
        } else {
            apply.setProductTypeFirstCognizance(list.get(0).getFlag());
        }
        if (list.size() >= 2) {
            apply.setProductTypeSecond(list.get(1).getCode());
            apply.setProductTypeSecondDesc(list.get(1).getDesc());
            if (map.containsKey(list.get(1).getCode())) {
                apply.setProductTypeSecondCognizance(FLAG);
            } else {
                apply.setProductTypeSecondCognizance(list.get(1).getFlag());
            }
            if (list.size() >= 3) {
                apply.setProductTypeThird(list.get(2).getCode());
                apply.setProductTypeThirdDesc(list.get(2).getDesc());
                if (map.containsKey(list.get(2).getCode())) {
                    apply.setProductTypeThirdCognizance(FLAG);
                } else {
                    apply.setProductTypeThirdCognizance(list.get(2).getFlag());
                }
                if (list.size() >= 4) {
                    apply.setProductTypeFourth(list.get(3).getCode());
                    apply.setProductTypeFourthDesc(list.get(3).getDesc());
                    if (map.containsKey(list.get(3).getCode())) {
                        apply.setProductTypeFourthCognizance(FLAG);
                    } else {
                        apply.setProductTypeFourthCognizance(list.get(3).getFlag());
                    }
                    if (list.size() >= 5) {
                        apply.setProductTypeFifth(list.get(4).getCode());
                        apply.setProductTypeFifthDesc(list.get(4).getDesc());
                        if (map.containsKey(list.get(4).getCode())) {
                            apply.setProductTypeFifthCognizance(FLAG);
                        } else {
                            apply.setProductTypeFourthCognizance(list.get(4).getFlag());
                        }
                    }
                }
            }
        }
    }

    private Map<String, Integer> generateFlagMap(CompanyProductCognize companySupplierApply) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (StringUtils.isNotBlank((String)companySupplierApply.getProductTypeFirst()) && companySupplierApply.getProductTypeFirstCognizance() != null && companySupplierApply.getProductTypeFirstCognizance() == 2) {
            map.put(companySupplierApply.getProductTypeFirst(), companySupplierApply.getProductTypeFirstCognizance());
        }
        if (StringUtils.isNotBlank((String)companySupplierApply.getProductTypeSecond()) && companySupplierApply.getProductTypeSecondCognizance() != null && companySupplierApply.getProductTypeSecondCognizance() == 2) {
            map.put(companySupplierApply.getProductTypeSecond(), companySupplierApply.getProductTypeSecondCognizance());
        }
        if (StringUtils.isNotBlank((String)companySupplierApply.getProductTypeThird()) && companySupplierApply.getProductTypeThirdCognizance() != null && companySupplierApply.getProductTypeThirdCognizance() == 2) {
            map.put(companySupplierApply.getProductTypeThird(), companySupplierApply.getProductTypeThirdCognizance());
        }
        if (StringUtils.isNotBlank((String)companySupplierApply.getProductTypeFourth()) && companySupplierApply.getProductTypeFourthCognizance() != null && companySupplierApply.getProductTypeFourthCognizance() == 2) {
            map.put(companySupplierApply.getProductTypeFourth(), companySupplierApply.getProductTypeFourthCognizance());
        }
        if (StringUtils.isNotBlank((String)companySupplierApply.getProductTypeFifth()) && companySupplierApply.getProductTypeFifthCognizance() != null && companySupplierApply.getProductTypeFifthCognizance() == 2) {
            map.put(companySupplierApply.getProductTypeFifth(), companySupplierApply.getProductTypeFifthCognizance());
        }
        return map;
    }

    private void cleanSupplierCompanyType(CompanyProductCognize apply) {
        apply.setProductTypeFirst("");
        apply.setProductTypeFirstDesc("");
        apply.setProductTypeFirstCognizance(Constant.NO_INT);
        apply.setProductTypeSecond("");
        apply.setProductTypeSecondDesc("");
        apply.setProductTypeSecondCognizance(Constant.NO_INT);
        apply.setProductTypeThird("");
        apply.setProductTypeThirdDesc("");
        apply.setProductTypeThirdCognizance(Constant.NO_INT);
        apply.setProductTypeFourth("");
        apply.setProductTypeFourthDesc("");
        apply.setProductTypeFourthCognizance(Constant.NO_INT);
        apply.setProductTypeFifth("");
        apply.setProductTypeFifthDesc("");
        apply.setProductTypeFifthCognizance(Constant.NO_INT);
    }
}

