/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.company.service.impl;

import com.els.base.auth.entity.User;
import com.els.base.certification.auth.entity.CompanyAuthExample;
import com.els.base.certification.auth.service.CompanyAuthService;
import com.els.base.certification.company.service.SupplierService;
import com.els.base.certification.company.util.CompanyInfoUtils;
import com.els.base.certification.contacts.entity.ContactsExample;
import com.els.base.certification.contacts.service.ContactsService;
import com.els.base.certification.contrast.utils.CompanyContrastApproveEnum;
import com.els.base.certification.customer.entity.CompanyCustomerExample;
import com.els.base.certification.customer.service.CompanyCustomerService;
import com.els.base.certification.device.entity.CompanyProductDeviceExample;
import com.els.base.certification.device.service.CompanyProductDeviceService;
import com.els.base.certification.equipment.entity.CompanyEquipmentExample;
import com.els.base.certification.equipment.service.CompanyEquipmentService;
import com.els.base.certification.file.service.CompanyFileService;
import com.els.base.certification.finance.entity.CompanyFinanceExample;
import com.els.base.certification.finance.service.CompanyFinanceService;
import com.els.base.certification.patents.entity.CompanyPatentsExample;
import com.els.base.certification.patents.service.CompanyPatentsService;
import com.els.base.certification.productservice.entity.CompanyProductServiceExample;
import com.els.base.certification.productservice.service.CompanyProductServiceService;
import com.els.base.certification.rawmaterial.entity.CompanyRawMaterialExample;
import com.els.base.certification.rawmaterial.service.CompanyRawMaterialService;
import com.els.base.certification.relation.entity.CompanySupplyRelationExample;
import com.els.base.certification.relation.service.CompanySupplyRelationService;
import com.els.base.certification.technology.entity.CompanyTechnologyExample;
import com.els.base.certification.technology.service.CompanyTechnologyService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyExecutionEnum;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultSupplierService")
public class SupplierServiceImpl
implements SupplierService {
    @Resource
    private CompanyService companyService;
    @Resource
    private CompanyAuthService companyAuthService;
    @Resource
    private CompanyPatentsService companyPatentsService;
    @Resource
    private CompanyFinanceService companyFinanceService;
    @Resource
    private CompanySupplyRelationService companySupplyRelationService;
    @Resource
    private CompanyFileService companyFileService;
    @Resource
    private CompanyEquipmentService companyEquipmentService;
    @Resource
    private CompanyProductDeviceService companyProductDeviceService;
    @Resource
    private CompanyTechnologyService companyTechnologyService;
    @Resource
    private CompanyRawMaterialService companyRawMaterialService;
    @Resource
    private CompanyCustomerService companyCustomerService;
    @Resource
    private CompanyProductServiceService companyProductServiceService;
    @Resource
    private ContactsService contactsService;

    @Override
    @Transactional
    public void audit(Project project, Company company, User loginUser) {
        List<Integer> finish = this.getFinishStatus(project, company);
        if (CollectionUtils.isEmpty(finish)) {
            throw new CommonException("\u8d44\u6599\u5b8c\u6210\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (finish.contains(Constant.NO_INT)) {
            throw new CommonException("\u6709\u8d44\u6599\u8fd8\u6ca1\u6709\u586b\u5199\u5b8c\uff0c\u63d0\u4ea4\u8d44\u6599\u5931\u8d25\u3002\u8bf7\u91cd\u65b0\u68c0\u67e5\u8d44\u6599\u662f\u5426\u5df2\u7ecf\u586b\u5199\u5b8c\u6574\uff0c\u8c22\u8c22!");
        }
        company.setApproveStatus(CompanyContrastApproveEnum.STATUS_APPROVING.getStatus());
        company.setApproveTime(new Date());
        company.setApproveUserName(loginUser.getNickName());
        company.setExecution(CompanyExecutionEnum.STATUS_SUBMIT.getStatus());
        this.companyService.modifyObj(company);
    }

    private List<Integer> getFinishStatus(Project project, Company company) {
        ArrayList<Integer> finish = new ArrayList<Integer>();
        finish.add(this.companyService.isFinish(company));
        Integer contactFinishFlag = this.contactsService.isFinish(project, company);
        if (contactFinishFlag != null && contactFinishFlag == 0) {
            throw new CommonException("\u8054\u7cfb\u4eba\u6a21\u5757\u91cc\u8fd8\u6709\u6570\u636e\u672a\u586b\u5199\u5b8c\u6210,\u65e0\u6cd5\u63d0\u4ea4\u8d44\u6599!");
        }
        finish.add(contactFinishFlag);
        Integer productFinishFlag = this.companyProductServiceService.isFinish(project, company);
        if (productFinishFlag != null && productFinishFlag == 0) {
            throw new CommonException("\u4e3b\u8981\u4ea7\u54c1/\u670d\u52a1\u6a21\u5757\u91cc\u8fd8\u6709\u6570\u636e\u672a\u586b\u5199\u5b8c\u6210,\u65e0\u6cd5\u63d0\u4ea4\u8d44\u6599!");
        }
        finish.add(productFinishFlag);
        Integer customerFinishFlag = this.companyCustomerService.isFinish(project, company);
        if (customerFinishFlag != null && customerFinishFlag == 0) {
            throw new CommonException("\u4e3b\u8981\u5ba2\u6237\u6a21\u5757\u91cc\u8fd8\u6709\u6570\u636e\u672a\u586b\u5199\u5b8c\u6210,\u65e0\u6cd5\u63d0\u4ea4\u8d44\u6599!");
        }
        finish.add(customerFinishFlag);
        Integer mainSupplierFinishFlag = this.companyRawMaterialService.isFinish(project, company);
        if (mainSupplierFinishFlag != null && mainSupplierFinishFlag == 0) {
            throw new CommonException("\u4e3b\u8981\u4f9b\u5e94\u5546/\u539f\u6750\u6599\u6a21\u5757\u91cc\u8fd8\u6709\u6570\u636e\u672a\u586b\u5199\u5b8c\u6210,\u65e0\u6cd5\u63d0\u4ea4\u8d44\u6599!");
        }
        finish.add(mainSupplierFinishFlag);
        Integer technologyFinishFlag = this.companyTechnologyService.isFinish(project, company);
        if (technologyFinishFlag != null && technologyFinishFlag == 0) {
            throw new CommonException("\u4e3b\u8981\u6280\u672f\u6a21\u5757\u91cc\u8fd8\u6709\u6570\u636e\u672a\u586b\u5199\u5b8c\u6210,\u65e0\u6cd5\u63d0\u4ea4\u8d44\u6599!");
        }
        finish.add(technologyFinishFlag);
        Integer productServicesFinishFlag = this.companyProductDeviceService.isFinish(project, company);
        if (productServicesFinishFlag != null && productServicesFinishFlag == 0) {
            throw new CommonException("\u5173\u952e\u751f\u4ea7\u8bbe\u5907\u6a21\u5757\u8fd8\u6709\u6570\u636e\u672a\u586b\u5199\u5b8c\u6210,\u65e0\u6cd5\u63d0\u4ea4\u8d44\u6599!");
        }
        finish.add(productServicesFinishFlag);
        Integer mainTestServiceFinishFlag = this.companyEquipmentService.isFinish(project, company);
        if (mainTestServiceFinishFlag != null && mainTestServiceFinishFlag == 0) {
            throw new CommonException("\u5173\u952e\u8bd5\u9a8c/\u68c0\u6d4b\u8bbe\u5907\u6a21\u5757\u8fd8\u6709\u6570\u636e\u672a\u586b\u5199\u5b8c\u6210,\u65e0\u6cd5\u63d0\u4ea4\u8d44\u6599!");
        }
        finish.add(mainTestServiceFinishFlag);
        Integer companyCognizationFinishFlag = this.companyAuthService.isFinish(project, company);
        if (companyCognizationFinishFlag != null && companyCognizationFinishFlag == 0) {
            throw new CommonException("\u4f01\u4e1a\u901a\u8fc7\u7684\u8ba4\u8bc1\u6a21\u5757\u8fd8\u6709\u6570\u636e\u672a\u586b\u5199\u5b8c\u6210,\u65e0\u6cd5\u63d0\u4ea4\u8d44\u6599!");
        }
        finish.add(companyCognizationFinishFlag);
        Integer patentFinishFlag = this.companyPatentsService.isFinish(project, company);
        if (patentFinishFlag != null && patentFinishFlag == 0) {
            throw new CommonException("\u4e13\u5229/\u4e13\u6709\u6280\u672f/\u8bb8\u53ef\u6a21\u5757\u8fd8\u6709\u6570\u636e\u672a\u586b\u5199\u5b8c\u6210,\u65e0\u6cd5\u63d0\u4ea4\u8d44\u6599!");
        }
        finish.add(patentFinishFlag);
        Integer financeFinishFlag = this.companyFinanceService.isFinish(project, company);
        if (financeFinishFlag != null && financeFinishFlag == 0) {
            throw new CommonException("\u8d22\u52a1\u4fe1\u606f\u6a21\u5757\u8fd8\u6709\u6570\u636e\u672a\u586b\u5199\u5b8c\u6210,\u65e0\u6cd5\u63d0\u4ea4\u8d44\u6599!");
        }
        finish.add(financeFinishFlag);
        Integer staffFinishFlag = this.companySupplyRelationService.isFinish(project, company);
        if (staffFinishFlag != null && staffFinishFlag == 0) {
            throw new CommonException("\u5458\u5de5\u4f9b\u8d27\u5173\u7cfb\u6a21\u5757\u8fd8\u6709\u6570\u636e\u672a\u586b\u5199\u5b8c\u6210,\u65e0\u6cd5\u63d0\u4ea4\u8d44\u6599!");
        }
        finish.add(staffFinishFlag);
        Integer attachmentFinishFlag = this.companyFileService.isFinish(project, company);
        if (attachmentFinishFlag != null && attachmentFinishFlag == 0) {
            throw new CommonException("\u9644\u4ef6\u6a21\u5757\u8fd8\u6709\u6570\u636e\u672a\u586b\u5199\u5b8c\u6210,\u65e0\u6cd5\u63d0\u4ea4\u8d44\u6599!");
        }
        finish.add(attachmentFinishFlag);
        return finish;
    }

    @Override
    @CacheEvict(value={"supplier"}, allEntries=true)
    public FileData print(String projectId, String companyId, List<Company> companyList) {
        Assert.isNotEmpty(companyList, "\u4f20\u8f93\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u6253\u5370");
        FileData fileData = null;
        for (Company com : companyList) {
            Assert.isNotBlank(com.getCompanyCode(), "\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u7a7a");
            Company company = this.companyService.queryCompanyByCode(com.getCompanyCode());
            Assert.isNotNull(company, "\u6839\u636e\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6253\u5370");
            ContactsExample contactsExample = new ContactsExample();
            contactsExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
            List contactsList = this.contactsService.queryAllObjByExample(contactsExample);
            CompanyProductServiceExample productServiceExample = new CompanyProductServiceExample();
            productServiceExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
            List productList = this.companyProductServiceService.queryAllObjByExample(productServiceExample);
            CompanyCustomerExample customerExample = new CompanyCustomerExample();
            customerExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
            List customerList = this.companyCustomerService.queryAllObjByExample(customerExample);
            CompanyRawMaterialExample rawMaterialExample = new CompanyRawMaterialExample();
            rawMaterialExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
            List rawMaterialList = this.companyRawMaterialService.queryAllObjByExample(rawMaterialExample);
            CompanyTechnologyExample technologyExample = new CompanyTechnologyExample();
            technologyExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
            List technologyList = this.companyTechnologyService.queryAllObjByExample(technologyExample);
            CompanyProductDeviceExample deviceExample = new CompanyProductDeviceExample();
            deviceExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
            List deviceList = this.companyProductDeviceService.queryAllObjByExample(deviceExample);
            CompanyEquipmentExample equipmentExample = new CompanyEquipmentExample();
            equipmentExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
            List equipmentList = this.companyEquipmentService.queryAllObjByExample(equipmentExample);
            CompanyAuthExample authExample = new CompanyAuthExample();
            authExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
            List authList = this.companyAuthService.queryAllObjByExample(authExample);
            CompanyPatentsExample patentsExample = new CompanyPatentsExample();
            patentsExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
            List patentsList = this.companyPatentsService.queryAllObjByExample(patentsExample);
            CompanyFinanceExample financeExample = new CompanyFinanceExample();
            financeExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
            List financeList = this.companyFinanceService.queryAllObjByExample(financeExample);
            CompanySupplyRelationExample supplyExample = new CompanySupplyRelationExample();
            supplyExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
            List supplyList = this.companySupplyRelationService.queryAllObjByExample(supplyExample);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("company", company);
            params.put("contacts", contactsList);
            params.put("productList", productList);
            params.put("customerList", customerList);
            params.put("rawMaterialList", rawMaterialList);
            params.put("technologyList", technologyList);
            params.put("deviceList", deviceList);
            params.put("equipmentList", equipmentList);
            params.put("authList", authList);
            params.put("patentsList", patentsList);
            params.put("financeList", financeList);
            params.put("supplyList", supplyList);
            try {
                fileData = CompanyInfoUtils.generatePdf(projectId, companyId, params, "A4");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fileData;
    }

    @Override
    @CacheEvict(value={"supplier"}, allEntries=true)
    public List<TitleAndModelKey> createExcelHeaderForPur() {
        DateConverter dateConverter = new DateConverter();
        dateConverter.setDateFormat("yyyy-MM-dd");
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"SRM\u4f9b\u5e94\u5546\u7f16\u7801", (String)"companyCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"SAP\u4f9b\u5e94\u5546\u7f16\u7801", (String)"companySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7b80\u79f0", (String)"companyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ea7\u54c1\u5927\u7c7b1", (String)"secondCompanyTypeDesc1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ea7\u54c1\u5927\u7c7b2", (String)"secondCompanyTypeDesc2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ea7\u54c1\u5927\u7c7b3", (String)"secondCompanyTypeDesc3"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ea7\u54c1\u5927\u7c7b4", (String)"secondCompanyTypeDesc4"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ea7\u54c1\u5927\u7c7b5", (String)"secondCompanyTypeDesc5"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u670d\u52a1\u7c7b", (String)"firstCompanyTypeDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u98ce\u9669\u7c7b", (String)"businessTypeDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u8d44\u67e5\u7c7b", (String)"classificationThreeDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u82f1\u6587\u7b80\u79f0", (String)"companyEnglishAbbreviation"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u5168\u79f0", (String)"companyFullName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u82f1\u6587\u5168\u79f0", (String)"englishCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ee3\u7406\u54c1\u724c", (String)"actingBrand"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"ISO9001\u4f53\u7cfb\u8bc1\u4e66", (String)"ISO9001FileName"));
        TitleAndModelKey ISO9001EndTime = ExcelUtils.createTitleAndModelKey((String)"ISO9001\u4f53\u7cfb\u8bc1\u4e66\u6709\u6548\u671f", (String)"ISO9001EndTime");
        ISO9001EndTime.setToObjConverter((StrToObjConverter)dateConverter);
        ISO9001EndTime.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(ISO9001EndTime);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"IATF16949\u4f53\u7cfb\u8bc1\u4e66", (String)"IATF16949FileName"));
        TitleAndModelKey IATF16949EndTime = ExcelUtils.createTitleAndModelKey((String)"IATF16949\u4f53\u7cfb\u8bc1\u4e66\u6709\u6548\u671f", (String)"IATF16949EndTime");
        IATF16949EndTime.setToObjConverter((StrToObjConverter)dateConverter);
        IATF16949EndTime.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(IATF16949EndTime);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"ISO14000\u4f53\u7cfb\u8bc1\u4e66", (String)"ISO14000FileName"));
        TitleAndModelKey ISO14000EndTime = ExcelUtils.createTitleAndModelKey((String)"ISO14000\u8bc1\u4e66\u6709\u6548\u671f", (String)"ISO14000EndTime");
        ISO14000EndTime.setToObjConverter((StrToObjConverter)dateConverter);
        ISO14000EndTime.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(ISO14000EndTime);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d1f\u8d23\u4eba", (String)"contacts"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"E-MAIL", (String)"email"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"TEL(\u4e00)", (String)"telephone"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"FAXNO", (String)"fax"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8054\u7cfb\u5730\u5740(\u4e2d\u6587)", (String)"address"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u82f1\u6587\u5730\u5740", (String)"englishAddress"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7ecf\u8425\u8303\u56f4", (String)"businessScope"));
        TitleAndModelKey createTime = ExcelUtils.createTitleAndModelKey((String)"\u6ce8\u518c\u65f6\u95f4", (String)"createTime");
        createTime.setToObjConverter((StrToObjConverter)dateConverter);
        createTime.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(createTime);
        return titleAndModelKeys;
    }
}

