/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.company.service.impl;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.entity.UserRoleExample;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.certification.company.im.SupplierStatusImTemplete;
import com.els.base.certification.company.service.SupplierStatusChangeService;
import com.els.base.certification.company.util.ChangeEventEnum;
import com.els.base.certification.company.vo.SupplierStatusChangeVO;
import com.els.base.certification.log.entity.CompanyStatusChangeLog;
import com.els.base.certification.log.service.CompanyStatusChangeLogService;
import com.els.base.company.dao.CompanyPartnerMapper;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyPartner;
import com.els.base.company.entity.CompanyPartnerExample;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="SupplierStatusChangeService")
public class SupplierStatusChangeServiceImpl
implements SupplierStatusChangeService {
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String IM_CODE = "UNQUALIFIED_NOTIFY";
    @Resource
    private CompanyPartnerMapper companyPartnerMapper;
    @Resource
    private CompanyService companyService;
    @Resource
    private RoleService roleService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private UserRoleService userRoleService;
    @Resource
    private CompanyStatusChangeLogService companyStatusChangeLogService;
    @Resource
    protected ThreadPoolTaskExecutor defaultThreadPool;

    @Override
    @Transactional
    public void changeSupplierStatus(SupplierStatusChangeVO vo, String purCompanyId, com.els.base.auth.entity.User loginUser, Company purCompany) {
        CompanyStatusChangeLog log = new CompanyStatusChangeLog();
        this.isExistSupplierCompany(vo, log);
        this.isSatisfied(vo, purCompanyId);
        this.changeSupplierCompanyStatus(vo, purCompanyId, log);
        this.changeSupplierAuthority(vo, purCompanyId);
        this.notifySupplier(vo, purCompany, loginUser);
        this.addCompanyStatusChangeLogData(log, loginUser, vo);
    }

    private void isExistSupplierCompany(SupplierStatusChangeVO vo, CompanyStatusChangeLog log) {
        Company company = (Company)this.companyService.queryObjById(vo.getSupCompanyId());
        if (null == company) {
            throw new CommonException("\u8be5\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728!");
        }
        log.setSupCompanyId(vo.getSupCompanyId());
        log.setSupCompanySrmCode(company.getCompanyCode());
        log.setSupCompanySapCode(company.getCompanySapCode());
        log.setSupCompanyFullName(company.getCompanyFullName());
        log.setSupCompanyName(company.getCompanyName());
    }

    private void isSatisfied(SupplierStatusChangeVO vo, String purCompanyId) {
        CompanyPartnerExample example = new CompanyPartnerExample();
        CompanyPartnerExample.Criteria criteria = example.createCriteria();
        criteria.andCompanyIdEqualTo(purCompanyId).andPartnerCompanyIdEqualTo(vo.getSupCompanyId());
        switch (vo.getChangeEvent()) {
            case "qualified": {
                ArrayList<String> supplierStatus = new ArrayList<String>();
                supplierStatus.add(PartnerRoleEnum.BOUNDED.getCode());
                supplierStatus.add(PartnerRoleEnum.POTENIAL.getCode());
                criteria.andPartnerRoleCodeIn(supplierStatus);
                if (this.companyPartnerMapper.countByExample(example) > 0) break;
                throw new CommonException("\u53ea\u6709\u53d7\u9650\u4f9b\u5e94\u5546\u3001\u6f5c\u5728\u4f9b\u5e94\u5546\u624d\u53ef\u4ee5\u8f6c\u6210\u5408\u683c\u4f9b\u5e94\u5546!");
            }
            case "potenial": {
                criteria.andPartnerRoleCodeEqualTo(PartnerRoleEnum.STRANGER.getCode());
                if (this.companyPartnerMapper.countByExample(example) <= 0) {
                    throw new CommonException("\u53ea\u6709\u964c\u751f\u4f9b\u5e94\u5546\u624d\u53ef\u4ee5\u8f6c\u6210\u6f5c\u5728\u4f9b\u5e94\u5546!");
                }
                example.clear();
                example.createCriteria().andCompanyIdEqualTo(purCompanyId).andPartnerCompanyIdEqualTo(vo.getSupCompanyId()).andIsUnqualifiedEqualTo(Constant.NO_INT);
                if (this.companyPartnerMapper.countByExample(example) <= 0) break;
                throw new CommonException("\u4e0d\u5408\u683c\u4f9b\u5e94\u5546\u65e0\u6cd5\u8f6c\u4e3a\u6f5c\u5728\u4f9b\u5e94\u5546!");
            }
            case "stranger": {
                break;
            }
            case "eliminate": {
                criteria.andPartnerRoleCodeEqualTo(PartnerRoleEnum.WAIT_ELIMINATE.getCode());
                if (this.companyPartnerMapper.countByExample(example) > 0) break;
                throw new CommonException("\u53ea\u6709\u5f85\u6dd8\u6c70\u4f9b\u5e94\u5546\u624d\u53ef\u4ee5\u8f6c\u6210\u6dd8\u6c70\u4f9b\u5e94\u5546!");
            }
            case "bounded": {
                ArrayList<String> supplierStatusArr = new ArrayList<String>();
                supplierStatusArr.add(PartnerRoleEnum.QUALIFIED.getCode());
                supplierStatusArr.add(PartnerRoleEnum.POTENIAL.getCode());
                criteria.andPartnerRoleCodeIn(supplierStatusArr);
                if (this.companyPartnerMapper.countByExample(example) > 0) break;
                throw new CommonException("\u53ea\u6709\u5408\u683c\u4f9b\u5e94\u5546\u3001\u6f5c\u5728\u4f9b\u5e94\u5546\u624d\u53ef\u4ee5\u8f6c\u6210\u53d7\u9650\u4f9b\u5e94\u5546!");
            }
            case "wait_eliminate": {
                ArrayList<String> supplierStatusList = new ArrayList<String>();
                supplierStatusList.add(PartnerRoleEnum.QUALIFIED.getCode());
                supplierStatusList.add(PartnerRoleEnum.BOUNDED.getCode());
                criteria.andPartnerRoleCodeIn(supplierStatusList);
                if (this.companyPartnerMapper.countByExample(example) > 0) break;
                throw new CommonException("\u53ea\u6709\u5408\u683c\u4f9b\u5e94\u5546\u3001\u53d7\u9650\u4f9b\u5e94\u5546\u624d\u53ef\u4ee5\u8f6c\u6210\u5f85\u6dd8\u6c70\u4f9b\u5e94\u5546!");
            }
            case "unqualified": {
                criteria.andPartnerRoleCodeEqualTo(PartnerRoleEnum.STRANGER.getCode());
                if (this.companyPartnerMapper.countByExample(example) <= 0) {
                    throw new CommonException("\u53ea\u6709\u964c\u751f\u4f9b\u5e94\u5546\u624d\u53ef\u4ee5\u901a\u77e5\u4e3a\u4e0d\u5408\u683c\u72b6\u6001!");
                }
                example.clear();
                example.createCriteria().andCompanyIdEqualTo(purCompanyId).andPartnerCompanyIdEqualTo(vo.getSupCompanyId()).andIsUnqualifiedEqualTo(Constant.NO_INT);
                if (this.companyPartnerMapper.countByExample(example) <= 0) break;
                throw new CommonException("\u8be5\u4f9b\u5e94\u5546\u5df2\u7ecf\u662f\u4e0d\u5408\u683c\u4f9b\u5e94\u5546,\u65e0\u9700\u91cd\u590d\u64cd\u4f5c!");
            }
        }
    }

    private void changeSupplierCompanyStatus(SupplierStatusChangeVO vo, String purCompanyId, CompanyStatusChangeLog log) {
        CompanyPartnerExample example = new CompanyPartnerExample();
        example.createCriteria().andCompanyIdEqualTo(purCompanyId).andPartnerCompanyIdEqualTo(vo.getSupCompanyId());
        CompanyPartner cp = new CompanyPartner();
        cp.setRemark(vo.getRemark());
        cp.setChangeTime(new Date());
        switch (vo.getChangeEvent()) {
            case "qualified": {
                cp.setPartnerRoleCode(PartnerRoleEnum.QUALIFIED.getCode());
                cp.setPartnerRoleName(PartnerRoleEnum.QUALIFIED.getName());
                log.setOperateEvent(ChangeEventEnum.QUALIFIED.getCode());
                log.setOperateEventDesc(ChangeEventEnum.QUALIFIED.getName());
                break;
            }
            case "potenial": {
                cp.setPartnerRoleCode(PartnerRoleEnum.POTENIAL.getCode());
                cp.setPartnerRoleName(PartnerRoleEnum.POTENIAL.getName());
                log.setOperateEvent(ChangeEventEnum.POTENIAL.getCode());
                log.setOperateEventDesc(ChangeEventEnum.POTENIAL.getName());
                break;
            }
            case "stranger": {
                break;
            }
            case "eliminate": {
                cp.setPartnerRoleCode(PartnerRoleEnum.ELIMINATE.getCode());
                cp.setPartnerRoleName(PartnerRoleEnum.ELIMINATE.getName());
                log.setOperateEvent(ChangeEventEnum.ELIMINATE.getCode());
                log.setOperateEventDesc(ChangeEventEnum.ELIMINATE.getName());
                break;
            }
            case "bounded": {
                cp.setPartnerRoleCode(PartnerRoleEnum.BOUNDED.getCode());
                cp.setPartnerRoleName(PartnerRoleEnum.BOUNDED.getName());
                log.setOperateEvent(ChangeEventEnum.BOUNDED.getCode());
                log.setOperateEventDesc(ChangeEventEnum.BOUNDED.getName());
                break;
            }
            case "wait_eliminate": {
                cp.setPartnerRoleCode(PartnerRoleEnum.WAIT_ELIMINATE.getCode());
                cp.setPartnerRoleName(PartnerRoleEnum.WAIT_ELIMINATE.getName());
                log.setOperateEvent(ChangeEventEnum.WAIT_ELIMINATE.getCode());
                log.setOperateEventDesc(ChangeEventEnum.WAIT_ELIMINATE.getName());
                break;
            }
            case "unqualified": {
                cp.setIsUnqualified(Constant.NO_INT);
                cp.setUnqualifiedReply(formatter.format(new Date()));
                log.setOperateEvent(ChangeEventEnum.UNQUALIFIED.getCode());
                log.setOperateEventDesc(ChangeEventEnum.UNQUALIFIED.getName());
                break;
            }
        }
        this.companyService.updatePartnerRole(cp, example);
    }

    private void changeSupplierAuthority(SupplierStatusChangeVO vo, String purCompanyId) {
        List list;
        RoleExample roleExample = new RoleExample();
        RoleExample.Criteria criteria = roleExample.createCriteria();
        boolean flag = true;
        switch (vo.getChangeEvent()) {
            case "qualified": {
                criteria.andRoleCodeEqualTo(PartnerRoleEnum.QUALIFIED.getUserRoleCode());
                break;
            }
            case "potenial": {
                criteria.andRoleCodeEqualTo(PartnerRoleEnum.POTENIAL.getUserRoleCode());
                break;
            }
            case "eliminate": {
                criteria.andRoleCodeEqualTo(PartnerRoleEnum.ELIMINATE.getUserRoleCode());
                break;
            }
            case "stranger": {
                flag = false;
                break;
            }
            case "bounded": {
                criteria.andRoleCodeEqualTo(PartnerRoleEnum.BOUNDED.getUserRoleCode());
                break;
            }
            case "wait_eliminate": {
                criteria.andRoleCodeEqualTo(PartnerRoleEnum.WAIT_ELIMINATE.getUserRoleCode());
                break;
            }
            case "unqualified": {
                flag = false;
                break;
            }
            default: {
                flag = false;
            }
        }
        if (flag && CollectionUtils.isNotEmpty((Collection)(list = this.roleService.queryAllObjByExample((IExample)roleExample)))) {
            CompanyUserRefExample companyUserExample = new CompanyUserRefExample();
            companyUserExample.createCriteria().andCompanyIdEqualTo(vo.getSupCompanyId());
            List companyUserRef = this.companyUserRefService.queryAllObjByExample(companyUserExample);
            UserRoleExample userRoleExample = new UserRoleExample();
            userRoleExample.createCriteria().andUserIdEqualTo(((CompanyUserRef)companyUserRef.get(0)).getUserId());
            List userRole = this.userRoleService.queryAllObjByExample((IExample)userRoleExample);
            for (UserRole ur : userRole) {
                for (Role role : list) {
                    ur.setRoleId(role.getId());
                    ur.setCreateTime(new Date());
                    this.userRoleService.modifyObj((Serializable)ur);
                }
            }
        }
    }

    private void notifySupplier(final SupplierStatusChangeVO vo, final Company purCompany, final com.els.base.auth.entity.User loginUser) {
        if (ChangeEventEnum.UNQUALIFIED.getCode().equals(vo.getChangeEvent())) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    SupplierStatusImTemplete tem = new SupplierStatusImTemplete("\u534e\u9633\u901a\u7528\u7535\u5b50\u6709\u9650\u516c\u53f8\u5ba1\u6838\u8d35\u53f8\u8d44\u6599\u4e0d\u5408\u683c\uff0c\u4e0d\u80fd\u6210\u4e3a\u6211\u4eec\u7684\u6f5c\u5728\u4f9b\u5e94\u5546\uff01");
                    SupplierStatusChangeServiceImpl.this.sendMessagesToSup(loginUser, tem, vo, purCompany);
                }
            });
        }
    }

    public void sendMessagesToSup(com.els.base.auth.entity.User loginUser, SupplierStatusImTemplete templete, SupplierStatusChangeVO data, Company purCompany) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getSupCompanyId());
        Message message = Message.init((Object)templete).setBusinessTypeCode(IM_CODE).setCompanyCode(purCompany.getCompanyCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    private void addCompanyStatusChangeLogData(CompanyStatusChangeLog log, com.els.base.auth.entity.User loginUser, SupplierStatusChangeVO vo) {
        log.setOperatorUserId(loginUser.getId());
        log.setOperatorAccount(loginUser.getLoginName());
        log.setOperatorName(loginUser.getNickName());
        log.setCreateTime(new Date());
        log.setRemark(vo.getRemark());
        this.companyStatusChangeLogService.addObj(log);
    }
}

