/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.equipment.service.impl;

import com.els.base.certification.equipment.dao.CompanyEquipmentMapper;
import com.els.base.certification.equipment.entity.CompanyEquipment;
import com.els.base.certification.equipment.entity.CompanyEquipmentExample;
import com.els.base.certification.equipment.service.CompanyEquipmentService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyExecutionEnum;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyEquipmentService")
public class CompanyEquipmentServiceImpl
implements CompanyEquipmentService {
    @Resource
    protected CompanyService companyService;
    @Resource
    private CompanyEquipmentMapper companyEquipmentMapper;

    @Override
    @Cacheable(value={"companyEquipment"}, keyGenerator="redisKeyGenerator")
    public Integer isFinish(Project project, Company company) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);
        CompanyEquipmentExample companyEquipmentExample = new CompanyEquipmentExample();
        companyEquipmentExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        int count = this.companyEquipmentMapper.countByExample(companyEquipmentExample);
        if (count <= 0) {
            return 0;
        }
        companyEquipmentExample.clear();
        companyEquipmentExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT).andFinishFlagIn(list);
        int finishCount = this.companyEquipmentMapper.countByExample(companyEquipmentExample);
        if (finishCount > 0) {
            return 0;
        }
        return 1;
    }

    @Override
    @CacheEvict(value={"companyEquipment"}, allEntries=true)
    @Transactional
    public void deleteObjByIds(String projectId, Company company, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        CompanyEquipment companyEquipment = new CompanyEquipment();
        companyEquipment.setIsEnable(Constant.NO_INT);
        CompanyEquipmentExample companyEquipmentExample = new CompanyEquipmentExample();
        companyEquipmentExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIdIn((List)ids);
        this.companyEquipmentMapper.updateByExampleSelective(companyEquipment, companyEquipmentExample);
    }

    @Override
    @CacheEvict(value={"companyEquipment"}, allEntries=true)
    @Transactional
    public Integer batchInsert(String projectId, Company company, List<CompanyEquipment> companyEquipmentList) {
        if (CollectionUtils.isEmpty(companyEquipmentList)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        CompanyEquipmentExample companyEquipmentExample = new CompanyEquipmentExample();
        companyEquipmentExample.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        CompanyEquipment equipment = new CompanyEquipment();
        equipment.setIsEnable(Constant.NO_INT);
        this.companyEquipmentMapper.updateByExampleSelective(equipment, companyEquipmentExample);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (CompanyEquipment companyEquipment : companyEquipmentList) {
            companyEquipment.setId(null);
            companyEquipment.setProjectId(projectId);
            companyEquipment.setSupCompanyId(company.getId());
            companyEquipment.setIsEnable(Constant.YES_INT);
            companyEquipment.setCreateTime(new Date());
            companyEquipment.setUpdateTime(new Date());
            companyEquipment.setEquipmentCode("\u65e0");
            companyEquipment.setRemark("\u65e0");
            Integer finishFlag = companyEquipment.getFinishFlag();
            companyEquipment.setFinishFlag(finishFlag);
            this.companyEquipmentMapper.insertSelective(companyEquipment);
            list.add(finishFlag);
        }
        Company supCompany = (Company)this.companyService.queryObjById(company.getId());
        if (null == supCompany) {
            throw new CommonException("\u67e5\u8be2\u4e0d\u5230\u4f9b\u5e94\u5546\u6570\u636e");
        }
        if (CompanyExecutionEnum.STATUS_SUBMIT.getStatus().equals(supCompany.getExecution())) {
            this.companyService.modifyCompanyExecution(company.getId());
        }
        if (list.contains(Constant.NO_INT)) {
            return 0;
        }
        return 1;
    }

    @Override
    @CacheEvict(value={"companyEquipment"}, allEntries=true)
    public void addObj(CompanyEquipment t) {
        this.companyEquipmentMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"companyEquipment"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyEquipmentMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"companyEquipment"}, allEntries=true)
    public void modifyObj(CompanyEquipment t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyEquipmentMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"companyEquipment"}, keyGenerator="redisKeyGenerator")
    public CompanyEquipment queryObjById(String id) {
        return this.companyEquipmentMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"companyEquipment"}, keyGenerator="redisKeyGenerator")
    public List<CompanyEquipment> queryAllObjByExample(CompanyEquipmentExample example) {
        return this.companyEquipmentMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"companyEquipment"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyEquipment> queryObjByPage(CompanyEquipmentExample example) {
        PageView<CompanyEquipment> pageView = example.getPageView();
        pageView.setQueryResult(this.companyEquipmentMapper.selectByExampleByPage(example));
        return pageView;
    }
}

