/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.exempt.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.exempt.entity.Exempt;
import com.els.base.certification.exempt.entity.ExemptExample;
import com.els.base.certification.exempt.service.ExemptService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f9b\u5e94\u5546\u8c41\u514d\u5355")
@Controller
@RequestMapping(value={"exempt"})
public class ExemptController {
    @Resource
    protected ExemptService exemptService;
    @Resource
    protected CompanyService companyService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u8c41\u514d\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Exempt exempt) {
        if (StringUtils.isBlank((String)exempt.getSupCompanySrmCode())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        User user = SpringSecurityUtils.getLoginUser();
        this.exemptService.insert(user, exempt);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u8c41\u514d\u5355")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Exempt exempt) {
        if (StringUtils.isBlank((String)exempt.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        Assert.isNotBlank(exempt.getSupCompanySrmCode(), "\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.exemptService.modifyObj(exempt);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f9b\u5e94\u5546\u8c41\u514d\u5355")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<Exempt> supExempt) {
        if (CollectionUtils.isEmpty(supExempt)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25,\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.exemptService.deleteObjByIds(supExempt);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f5c\u5e9f\u4f9b\u5e94\u5546\u8c41\u514d\u5355")
    @RequestMapping(value={"service/invalidExemption"})
    @ResponseBody
    public ResponseResult<String> invalidExemption(@RequestBody(required=true) List<Exempt> supExempt) {
        if (CollectionUtils.isEmpty(supExempt)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.exemptService.updateIsInvalid(supExempt);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u8c41\u514d\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Exempt", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Exempt>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ExemptExample example = new ExemptExample();
        example.setPageView(new PageView<Exempt>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        ExemptExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.exemptService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636eID\u67e5\u770b\u4f9b\u5e94\u5546\u8c41\u514d\u5355\u5355\u636e\u8be6\u60c5")
    @RequestMapping(value={"service/findDetailById"})
    @ResponseBody
    public ResponseResult<Exempt> findDetailById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        Exempt exempt = (Exempt)this.exemptService.queryObjById(id);
        return ResponseResult.success(exempt);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f")
    @RequestMapping(value={"service/selectCompany"})
    @ResponseBody
    public ResponseResult<Company> selectCompany(@RequestParam(required=true) String companyCode) {
        Company company = this.companyService.queryCompanyByCode(companyCode);
        return ResponseResult.success(company);
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u9001\u5ba1\u6279")
    @RequestMapping(value={"service/sendApproval"})
    @ResponseBody
    public ResponseResult<String> sendApproal(@RequestBody List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u53d1\u9001\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.exemptService.sendToApprove(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u8c41\u514d\u5355\u6253\u5370")
    @RequestMapping(value={"service/print"})
    @ResponseBody
    public ResponseResult<FileData> print(@RequestBody(required=true) List<Exempt> data) {
        FileData fileData = this.exemptService.print(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), data);
        return ResponseResult.success(fileData);
    }
}

