/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.productservice.service.impl;

import com.els.base.certification.productservice.dao.CompanyProductServiceMapper;
import com.els.base.certification.productservice.entity.CompanyProductService;
import com.els.base.certification.productservice.entity.CompanyProductServiceExample;
import com.els.base.certification.productservice.service.CompanyProductServiceService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyExecutionEnum;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyProductServiceService")
public class CompanyProductServiceServiceImpl
implements CompanyProductServiceService {
    @Resource
    protected CompanyService companyService;
    @Resource
    protected CompanyProductServiceMapper companyProductServiceMapper;

    @Override
    @Cacheable(value={"companyProductService"}, keyGenerator="redisKeyGenerator")
    public Integer isFinish(Project project, Company company) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);
        CompanyProductServiceExample companyProductServiceExample = new CompanyProductServiceExample();
        companyProductServiceExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        if (this.companyProductServiceMapper.countByExample(companyProductServiceExample) <= 0) {
            return 0;
        }
        companyProductServiceExample.clear();
        companyProductServiceExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT).andFinishFlagIn(list);
        int count = this.companyProductServiceMapper.countByExample(companyProductServiceExample);
        if (count > 0) {
            return 0;
        }
        return 1;
    }

    @Override
    @CacheEvict(value={"companyProductService"}, allEntries=true)
    public void addObj(CompanyProductService t) {
        this.companyProductServiceMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"companyProductService"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyProductServiceMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"companyProductService"}, allEntries=true)
    public void modifyObj(CompanyProductService t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyProductServiceMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"companyProductService"}, keyGenerator="redisKeyGenerator")
    public CompanyProductService queryObjById(String id) {
        return this.companyProductServiceMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"companyProductService"}, keyGenerator="redisKeyGenerator")
    public List<CompanyProductService> queryAllObjByExample(CompanyProductServiceExample example) {
        return this.companyProductServiceMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"companyProductService"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyProductService> queryObjByPage(CompanyProductServiceExample example) {
        PageView<CompanyProductService> pageView = example.getPageView();
        pageView.setQueryResult(this.companyProductServiceMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"companyProductService"}, allEntries=true)
    public Integer batchInsert(String projectId, Company supCompany, Company purCompany, List<CompanyProductService> productServiceList) {
        if (CollectionUtils.isEmpty(productServiceList)) {
            throw new CommonException("\u4f20\u9012\u7684\u4ea7\u54c1\u670d\u52a1\u6570\u636e\u4e3a\u7a7a!");
        }
        CompanyProductServiceExample example = new CompanyProductServiceExample();
        example.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(supCompany.getId()).andIsEnableEqualTo(Constant.YES_INT);
        CompanyProductService product = new CompanyProductService();
        product.setIsEnable(Constant.NO_INT);
        this.companyProductServiceMapper.updateByExampleSelective(product, example);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (CompanyProductService companyProductService : productServiceList) {
            companyProductService.setId(null);
            companyProductService.setProjectId(projectId);
            companyProductService.setPurCompanyId(purCompany.getId());
            companyProductService.setPurCompanySrmCode(purCompany.getCompanyCode());
            companyProductService.setPurCompanyName(purCompany.getCompanyName());
            companyProductService.setSupCompanyId(supCompany.getId());
            companyProductService.setSupCompanySrmCode(supCompany.getCompanyCode());
            companyProductService.setSupCompanyName(supCompany.getCompanyName());
            companyProductService.setIsEnable(Constant.YES_INT);
            companyProductService.setCreateTime(new Date());
            companyProductService.setUpdateTime(new Date());
            Integer finishFlag = companyProductService.getFinishFlag(supCompany.getFirstCompanyType());
            companyProductService.setFinishFlag(finishFlag);
            this.addObj(companyProductService);
            list.add(finishFlag);
        }
        Company company = (Company)this.companyService.queryObjById(supCompany.getId());
        if (null == company) {
            throw new CommonException("\u67e5\u8be2\u4e0d\u5230\u4f9b\u5e94\u5546\u6570\u636e");
        }
        if (CompanyExecutionEnum.STATUS_SUBMIT.getStatus().equals(company.getExecution())) {
            this.companyService.modifyCompanyExecution(supCompany.getId());
        }
        if (list.contains(Constant.NO_INT)) {
            return 0;
        }
        return 1;
    }

    @Override
    @Transactional
    @CacheEvict(value={"companyProductService"}, allEntries=true)
    public void deleteObjByIds(String projectId, Company company, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u4f20\u9012\u7684id\u5217\u8868\u4e3a\u7a7a!");
        }
        CompanyProductServiceExample example = new CompanyProductServiceExample();
        example.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(company.getId()).andIdIn((List)ids);
        CompanyProductService product = new CompanyProductService();
        product.setIsEnable(Constant.NO_INT);
        this.companyProductServiceMapper.updateByExampleSelective(product, example);
    }
}

