/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.rawmaterial.service.impl;

import com.els.base.certification.rawmaterial.dao.CompanyRawMaterialMapper;
import com.els.base.certification.rawmaterial.entity.CompanyRawMaterial;
import com.els.base.certification.rawmaterial.entity.CompanyRawMaterialExample;
import com.els.base.certification.rawmaterial.service.CompanyRawMaterialService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyExecutionEnum;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyRawMaterialService")
public class CompanyRawMaterialServiceImpl
implements CompanyRawMaterialService {
    @Resource
    protected CompanyService companyService;
    @Resource
    protected CompanyRawMaterialMapper companyRawMaterialMapper;

    @Override
    @Cacheable(value={"companyRawMaterial"}, keyGenerator="redisKeyGenerator")
    public Integer isFinish(Project project, Company company) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);
        CompanyRawMaterialExample companyRawMaterialExample = new CompanyRawMaterialExample();
        companyRawMaterialExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        if (this.companyRawMaterialMapper.countByExample(companyRawMaterialExample) <= 0) {
            return 0;
        }
        companyRawMaterialExample.clear();
        companyRawMaterialExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT).andFinishFlagIn(list);
        int count = this.companyRawMaterialMapper.countByExample(companyRawMaterialExample);
        if (count > 0) {
            return 0;
        }
        return 1;
    }

    @Override
    @CacheEvict(value={"companyRawMaterial"}, allEntries=true)
    public void addObj(CompanyRawMaterial t) {
        this.companyRawMaterialMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"companyRawMaterial"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyRawMaterialMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"companyRawMaterial"}, allEntries=true)
    public void modifyObj(CompanyRawMaterial t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyRawMaterialMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"companyRawMaterial"}, keyGenerator="redisKeyGenerator")
    public CompanyRawMaterial queryObjById(String id) {
        return this.companyRawMaterialMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"companyRawMaterial"}, keyGenerator="redisKeyGenerator")
    public List<CompanyRawMaterial> queryAllObjByExample(CompanyRawMaterialExample example) {
        return this.companyRawMaterialMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"companyRawMaterial"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyRawMaterial> queryObjByPage(CompanyRawMaterialExample example) {
        PageView<CompanyRawMaterial> pageView = example.getPageView();
        pageView.setQueryResult(this.companyRawMaterialMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"companyRawMaterial"}, allEntries=true)
    public Integer batchInsert(String projectId, Company supCompany, Company purCompany, List<CompanyRawMaterial> rawMaterialList) {
        if (CollectionUtils.isEmpty(rawMaterialList)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        CompanyRawMaterialExample example = new CompanyRawMaterialExample();
        example.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(supCompany.getId()).andIsEnableEqualTo(Constant.YES_INT);
        CompanyRawMaterial rawMaterial = new CompanyRawMaterial();
        rawMaterial.setIsEnable(Constant.NO_INT);
        this.companyRawMaterialMapper.updateByExampleSelective(rawMaterial, example);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (CompanyRawMaterial companyRawMaterial : rawMaterialList) {
            companyRawMaterial.setId(null);
            companyRawMaterial.setProjectId(projectId);
            companyRawMaterial.setPurCompanyId(purCompany.getId());
            companyRawMaterial.setPurCompanySrmCode(purCompany.getCompanyCode());
            companyRawMaterial.setPurCompanyName(purCompany.getCompanyName());
            companyRawMaterial.setSupCompanyId(supCompany.getId());
            companyRawMaterial.setSupCompanySrmCode(supCompany.getCompanyCode());
            companyRawMaterial.setSupCompanyName(supCompany.getCompanyName());
            companyRawMaterial.setIsEnable(Constant.YES_INT);
            companyRawMaterial.setCreateTime(new Date());
            companyRawMaterial.setUpdateTime(new Date());
            companyRawMaterial.setFinishFlag(Constant.NO_INT);
            Integer finishFlag = companyRawMaterial.getFinishFlag();
            companyRawMaterial.setFinishFlag(finishFlag);
            this.addObj(companyRawMaterial);
            list.add(finishFlag);
        }
        Company company = (Company)this.companyService.queryObjById(supCompany.getId());
        if (null == company) {
            throw new CommonException("\u67e5\u8be2\u4e0d\u5230\u4f9b\u5e94\u5546\u6570\u636e");
        }
        if (CompanyExecutionEnum.STATUS_SUBMIT.getStatus().equals(company.getExecution())) {
            this.companyService.modifyCompanyExecution(supCompany.getId());
        }
        if (list.contains(Constant.NO_INT)) {
            return 0;
        }
        return 1;
    }

    @Override
    @Transactional
    @CacheEvict(value={"companyRawMaterial"}, allEntries=true)
    public void deleteObjByIds(String projectId, Company company, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u4f20\u9012\u7684id\u5217\u8868\u4e3a\u7a7a!");
        }
        CompanyRawMaterialExample example = new CompanyRawMaterialExample();
        example.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(company.getId()).andIdIn((List)ids);
        CompanyRawMaterial rawMaterial = new CompanyRawMaterial();
        rawMaterial.setIsEnable(Constant.NO_INT);
        this.companyRawMaterialMapper.updateByExampleSelective(rawMaterial, example);
    }
}

