/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.result.service.impl;

import com.els.base.certification.common.ConfirmStatusEnum;
import com.els.base.certification.result.dao.CompanyResultNoticeMapper;
import com.els.base.certification.result.entity.CompanyResultNotice;
import com.els.base.certification.result.entity.CompanyResultNoticeExample;
import com.els.base.certification.result.service.CompanyResultNoticeService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyResultNoticeService")
public class CompanyResultNoticeServiceImpl
implements CompanyResultNoticeService {
    @Resource
    private CompanyResultNoticeMapper companyResultNoticeMapper;
    @Resource
    private CompanyService companyService;
    @Resource
    private GenerateCodeService generateCodeService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    protected ThreadPoolTaskExecutor defaultThreadPool;

    @Override
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    @Transactional
    public void abolish(Project project, Company company, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        CompanyResultNoticeExample companyResultNoticeExample = new CompanyResultNoticeExample();
        companyResultNoticeExample.createCriteria().andIdIn((List)ids).andSendStatusEqualTo(Constant.NO_INT);
        int count2 = this.companyResultNoticeMapper.countByExample(companyResultNoticeExample);
        if (count2 > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u672a\u53d1\u9001\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(ConfirmStatusEnum.STATUS_ABOLISH.getStatus());
        statusList.add(ConfirmStatusEnum.STATUS_CONFIRM.getStatus());
        companyResultNoticeExample.clear();
        companyResultNoticeExample.createCriteria().andIdIn((List)ids).andConfirmStatusIn(statusList);
        int count = this.companyResultNoticeMapper.countByExample(companyResultNoticeExample);
        if (count > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u5df2\u4f5c\u5e9f\u6216\u5df2\u786e\u8ba4\u7684\u6570\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u4f5c\u5e9f\u64cd\u4f5c!");
        }
        CompanyResultNotice companyResultNotice = new CompanyResultNotice();
        companyResultNotice.setConfirmStatus(ConfirmStatusEnum.STATUS_ABOLISH.getStatus());
        companyResultNotice.setUpdateTime(new Date());
        companyResultNoticeExample.clear();
        companyResultNoticeExample.createCriteria().andIdIn((List)ids);
        this.companyResultNoticeMapper.updateByExampleSelective(companyResultNotice, companyResultNoticeExample);
    }

    @Override
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    @Transactional
    public void send(final Project project, Company company, final User loginUser, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        CompanyResultNoticeExample companyResultNoticeExample = new CompanyResultNoticeExample();
        companyResultNoticeExample.createCriteria().andIdIn((List)ids).andSendStatusEqualTo(Constant.YES_INT);
        int count = this.companyResultNoticeMapper.countByExample(companyResultNoticeExample);
        if (count > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u5df2\u53d1\u9001\u6570\u636e\uff0c\u4e0d\u80fd\u518d\u64cd\u4f5c!");
        }
        companyResultNoticeExample.clear();
        companyResultNoticeExample.createCriteria().andIdIn((List)ids).andSendStatusEqualTo(Constant.NO_INT);
        List<CompanyResultNotice> companyResultNotices = this.companyResultNoticeMapper.selectByExample(companyResultNoticeExample);
        if (CollectionUtils.isEmpty(companyResultNotices)) {
            return;
        }
        for (final CompanyResultNotice companyResultNotice : companyResultNotices) {
            companyResultNotice.setSendStatus(Constant.YES_INT);
            this.companyResultNoticeMapper.updateByPrimaryKey(companyResultNotice);
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    CompanyResultNoticeServiceImpl.this.sendMessagesToSup(project, loginUser, companyResultNotice);
                }
            });
        }
    }

    private void sendMessagesToSup(Project project, User loginUser, CompanyResultNotice companyResultNotice) {
        User user = this.companyUserRefService.queryMainUserOfCompany(companyResultNotice.getSupCompanyId());
        Company purCompany = (Company)this.companyService.queryObjById(project.getCompanyId());
        Message message = Message.init((Object)companyResultNotice).setBusinessTypeCode("COMPANY_AUDIT_NOTICE_RESULT_SEND").setCompanyCode(purCompany.getCompanyCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(user.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    @Override
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    @Transactional
    public void deleteObjByIds(Project project, Company company, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        CompanyResultNoticeExample companyResultNoticeExample = new CompanyResultNoticeExample();
        companyResultNoticeExample.createCriteria().andIdIn((List)ids).andSendStatusEqualTo(Constant.YES_INT);
        int count = this.companyResultNoticeMapper.countByExample(companyResultNoticeExample);
        if (count > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u5df2\u53d1\u9001\u6570\u636e\uff0c\u4e0d\u80fd\u518d\u64cd\u4f5c!");
        }
        CompanyResultNotice companyResultNotice = new CompanyResultNotice();
        companyResultNotice.setIsEnable(Constant.NO_INT);
        companyResultNotice.setUpdateTime(new Date());
        companyResultNoticeExample.clear();
        companyResultNoticeExample.createCriteria().andIdIn((List)ids).andSendStatusEqualTo(Constant.NO_INT);
        this.companyResultNoticeMapper.updateByExampleSelective(companyResultNotice, companyResultNoticeExample);
    }

    @Override
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    @Transactional
    public void insert(String projectId, Company company, User user, CompanyResultNotice companyResultNotice) {
        if (companyResultNotice == null) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        this.verification(companyResultNotice);
        if (StringUtils.isEmpty((String)companyResultNotice.getId())) {
            this.setPurCompanyInfo(company, companyResultNotice);
            this.setSupCompanyInfo(ProjectUtils.getProject(), companyResultNotice);
            this.setCompanyResultNotice(ProjectUtils.getProject(), user, companyResultNotice);
            this.companyResultNoticeMapper.insertSelective(companyResultNotice);
        } else {
            companyResultNotice.setUpdateTime(new Date());
            this.companyResultNoticeMapper.updateByPrimaryKey(companyResultNotice);
        }
    }

    private void verification(CompanyResultNotice companyResultNotice) {
        if (companyResultNotice == null) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        String companyType = companyResultNotice.getCompanyType();
        Assert.isNotBlank(companyType, "\u4f9b\u5e94\u5546\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a!");
    }

    private void setCompanyResultNotice(Project project, User user, CompanyResultNotice companyResultNotice) {
        companyResultNotice.setProjectId(project.getId());
        companyResultNotice.setCreateBillName(user.getNickName());
        companyResultNotice.setCreateTime(new Date());
        String auditResultNoticeNo = this.generateCodeService.getNextCode("AUDIT_RESULT_NOTICE_NO");
        companyResultNotice.setAuditResultNoticeNo(auditResultNoticeNo);
        if (StringUtils.isEmpty((String)companyResultNotice.getCompanyType())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u4f9b\u5e94\u5546\u7c7b\u578b");
        }
        companyResultNotice.setIsEnable(Constant.YES_INT);
        companyResultNotice.setSendStatus(Constant.NO_INT);
        companyResultNotice.setConfirmStatus(ConfirmStatusEnum.STATUS_UNCONFIRM.getStatus());
    }

    private void setSupCompanyInfo(Project project, CompanyResultNotice companyResultNotice) {
        if (StringUtils.isEmpty((String)companyResultNotice.getSupCompanySrmCode())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u4f9b\u5e94\u5546SRM\u7f16\u7801");
        }
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andProjectIdEqualTo(project.getId()).andCompanyCodeEqualTo(companyResultNotice.getSupCompanySrmCode());
        PageView<Company> companyPageView = this.companyService.querySupplerCompanies(project.getCompanyId(), companyExample, PartnerRoleEnum.POTENIAL.getCode());
        List<Company> queryResult = companyPageView.getQueryResult();
        if (CollectionUtils.isEmpty(queryResult)) {
            throw new CommonException("\u6f5c\u5728\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728", "do_not_exists", "\u6f5c\u5728\u4f9b\u5e94\u5546");
        }
        Company superCompany = queryResult.get(0);
        companyResultNotice.setSupCompanyId(superCompany.getId());
        companyResultNotice.setSupCompanySrmCode(superCompany.getCompanyCode());
        companyResultNotice.setSupCompanySapCode(superCompany.getCompanySapCode());
        companyResultNotice.setSupCompanyName(superCompany.getCompanyName());
        companyResultNotice.setSupCompanyFullName(superCompany.getCompanyFullName());
        companyResultNotice.setSupCompanyAddress(superCompany.getAddress());
        companyResultNotice.setSupCompanyContacts(superCompany.getContacts());
    }

    private void setPurCompanyInfo(Company company, CompanyResultNotice companyResultNotice) {
        companyResultNotice.setPurCompanyId(company.getId());
        companyResultNotice.setPurCompanyName(company.getCompanyName());
        companyResultNotice.setPurCompanyFullName(company.getCompanyFullName());
        companyResultNotice.setPurCompanySrmCode(company.getCompanyCode());
        companyResultNotice.setPurCompanySapCode(company.getCompanySapCode());
    }

    @Override
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    public void addObj(CompanyResultNotice t) {
        this.companyResultNoticeMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyResultNoticeMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    public void modifyObj(CompanyResultNotice t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyResultNoticeMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"companyResultNotice"}, keyGenerator="redisKeyGenerator")
    public CompanyResultNotice queryObjById(String id) {
        return this.companyResultNoticeMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"companyResultNotice"}, keyGenerator="redisKeyGenerator")
    public List<CompanyResultNotice> queryAllObjByExample(CompanyResultNoticeExample example) {
        return this.companyResultNoticeMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"companyResultNotice"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyResultNotice> queryObjByPage(CompanyResultNoticeExample example) {
        PageView<CompanyResultNotice> pageView = example.getPageView();
        pageView.setQueryResult(this.companyResultNoticeMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"companyResultNotice"}, allEntries=true)
    public void confirm(CompanyResultNotice data, Company company, User loginUser) {
        if (StringUtils.isBlank((String)data.getId())) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        if (StringUtils.isBlank((String)data.getConfirmRemark())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u56de\u590d\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(ConfirmStatusEnum.STATUS_ABOLISH.getStatus());
        list.add(ConfirmStatusEnum.STATUS_CONFIRM.getStatus());
        CompanyResultNoticeExample companyResultNoticeExample = new CompanyResultNoticeExample();
        companyResultNoticeExample.createCriteria().andIdEqualTo(data.getId()).andConfirmStatusIn(list);
        int count = this.companyResultNoticeMapper.countByExample(companyResultNoticeExample);
        if (count > 0) {
            throw new CommonException("\u5df2\u4f5c\u5e9f\u6216\u8005\u5df2\u786e\u8ba4\u6570\u636e\uff0c\u4e0d\u80fd\u518d\u8fdb\u884c\u786e\u8ba4\u64cd\u4f5c!");
        }
        companyResultNoticeExample.clear();
        companyResultNoticeExample.createCriteria().andIdEqualTo(data.getId()).andSendStatusEqualTo(Constant.NO_INT);
        int count2 = this.companyResultNoticeMapper.countByExample(companyResultNoticeExample);
        if (count2 > 0) {
            throw new CommonException("\u672a\u53d1\u9001\u6570\u636e\uff0c\u4e0d\u80fd\u8fdb\u884c\u786e\u8ba4\u64cd\u4f5c!");
        }
        CompanyResultNotice result = new CompanyResultNotice();
        result.setId(data.getId());
        result.setConfirmStatus(ConfirmStatusEnum.STATUS_CONFIRM.getStatus());
        result.setConfirmRemark(data.getConfirmRemark());
        result.setUpdateTime(new Date());
        this.companyResultNoticeMapper.updateByPrimaryKeySelective(result);
    }
}

