/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.result.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.result.entity.CompanyResultNotice;
import com.els.base.certification.result.entity.CompanyResultNoticeExample;
import com.els.base.certification.result.service.CompanyResultNoticeService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f9b\u5e94\u5546\u51c6\u5165-\u5ba1\u6838\u7ed3\u679c\u901a\u77e5\u5355")
@Controller
@RequestMapping(value={"companyResultNotice"})
public class CompanyResultNoticeController {
    @Resource
    private CompanyResultNoticeService companyResultNoticeService;

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165--\u6279\u91cf\u4f5c\u5e9f\u5ba1\u6838\u7ed3\u679c\u901a\u77e5\u5355\u7ed9\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/abolish"})
    @ResponseBody
    public ResponseResult<String> abolish(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u4f5c\u5e9f\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyResultNoticeService.abolish(ProjectUtils.getProject(), CompanyUtils.currentCompany(), ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165--\u6279\u91cf\u53d1\u9001\u5ba1\u6838\u7ed3\u679c\u901a\u77e5\u5355\u7ed9\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/send"})
    @ResponseBody
    public ResponseResult<String> send(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u53d1\u9001\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyResultNoticeService.send(ProjectUtils.getProject(), CompanyUtils.currentCompany(), (User)SpringSecurityUtils.getLoginUser(), ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165--\u4f9b\u5e94\u5546\u786e\u8ba4\u5ba1\u6838\u901a\u77e5\u5355")
    @RequestMapping(value={"service/confirm"})
    @ResponseBody
    public ResponseResult<String> confirm(@RequestBody(required=true) CompanyResultNotice result) {
        this.companyResultNoticeService.confirm(result, CompanyUtils.currentCompany(), (User)SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u51c6\u5165-\u5ba1\u6838\u7ed3\u679c\u901a\u77e5\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyResultNotice companyResultNotice) {
        this.companyResultNoticeService.insert(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(), (User)SpringSecurityUtils.getLoginUser(), companyResultNotice);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165-\u6279\u91cf\u5220\u9664\u5ba1\u6838\u7ed3\u679c\u901a\u77e5\u5355")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyResultNoticeService.deleteObjByIds(ProjectUtils.getProject(), CompanyUtils.currentCompany(), ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165-\u5ba1\u6838\u7ed3\u679c\u901a\u77e5\u5355(\u91c7\u8d2d\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyResultNotice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyResultNotice>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyResultNoticeExample example = new CompanyResultNoticeExample();
        example.setPageView(new PageView<CompanyResultNotice>(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC ");
        CompanyResultNoticeExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andIsEnableEqualTo(Constant.YES_INT).andPurCompanyIdEqualTo(ProjectUtils.getCompanyId());
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.companyResultNoticeService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165-\u5ba1\u6838\u7ed3\u679c\u901a\u77e5\u5355(\u91c7\u8d2d\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyResultNotice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForSup"})
    @ResponseBody
    public ResponseResult<PageView<CompanyResultNotice>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyResultNoticeExample example = new CompanyResultNoticeExample();
        example.setPageView(new PageView<CompanyResultNotice>(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC ");
        CompanyResultNoticeExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andIsEnableEqualTo(Constant.YES_INT).andSendStatusEqualTo(Constant.YES_INT).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.companyResultNoticeService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}

