/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.workflow.common.web.controller;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.image.HMProcessDiagramGenerator;
import org.activiti.spring.ProcessEngineFactoryBean;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"processDiagram"})
public class ProcessDiagramController {
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private HistoryService historyService;
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private ProcessEngineFactoryBean processEngineFactoryBean;
    @Resource
    private ProcessEngineConfiguration processEngineConfiguration;

    @ApiOperation(httpMethod="POST", value="\u83b7\u53d6\u6d41\u7a0b\u56fe")
    @RequestMapping(value={"service/getShineProcImage"})
    @ResponseBody
    public ModelAndView getShineProcImage(@RequestParam(required=true) String processInstanceId, HttpServletResponse httpResponse) throws IOException {
        InputStream imageStream = this.generateStream(processInstanceId, true);
        httpResponse.setContentType("image/png");
        ServletOutputStream out = httpResponse.getOutputStream();
        byte[] imageByteArray = IOUtils.toByteArray((InputStream)imageStream);
        out.write(imageByteArray);
        out.flush();
        out.close();
        return null;
    }

    private InputStream generateStream(String processInstanceId, boolean needCurrent) {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        String processDefinitionId = null;
        ArrayList<String> executedActivityIdList = new ArrayList<String>();
        ArrayList<String> currentActivityIdList = new ArrayList();
        List<HistoricActivityInstance> historicActivityInstanceList = new ArrayList();
        if (processInstance != null) {
            processDefinitionId = processInstance.getProcessDefinitionId();
            if (needCurrent) {
                currentActivityIdList = this.runtimeService.getActiveActivityIds(processInstance.getId());
            }
        }
        if (historicProcessInstance != null) {
            processDefinitionId = historicProcessInstance.getProcessDefinitionId();
            historicActivityInstanceList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceId().asc()).list();
            for (HistoricActivityInstance activityInstance : historicActivityInstanceList) {
                executedActivityIdList.add(activityInstance.getActivityId());
            }
        }
        if (StringUtils.isEmpty((CharSequence)processDefinitionId) || executedActivityIdList.isEmpty()) {
            return null;
        }
        ProcessDefinitionEntity definitionEntity = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(processDefinitionId);
        List<String> highLightedFlows = this.getHighLightedFlows(definitionEntity, historicActivityInstanceList);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        this.processEngineConfiguration = this.processEngineFactoryBean.getProcessEngineConfiguration();
        Context.setProcessEngineConfiguration((ProcessEngineConfigurationImpl)((ProcessEngineConfigurationImpl)this.processEngineConfiguration));
        HMProcessDiagramGenerator diagramGenerator = (HMProcessDiagramGenerator)this.processEngineConfiguration.getProcessDiagramGenerator();
        InputStream imageStream = diagramGenerator.generateDiagram(bpmnModel, "png", executedActivityIdList, highLightedFlows, this.processEngineFactoryBean.getProcessEngineConfiguration().getActivityFontName(), this.processEngineFactoryBean.getProcessEngineConfiguration().getLabelFontName(), "\u5b8b\u4f53", null, 1.0, currentActivityIdList);
        return imageStream;
    }

    private List<String> getHighLightedFlows(ProcessDefinitionEntity processDefinitionEntity, List<HistoricActivityInstance> historicActivityInstances) {
        ArrayList<String> highFlows = new ArrayList<String>();
        for (int i = 0; i < historicActivityInstances.size() - 1; ++i) {
            ActivityImpl activityImpl = processDefinitionEntity.findActivity(historicActivityInstances.get(i).getActivityId());
            ArrayList<ActivityImpl> sameStartTimeNodes = new ArrayList<ActivityImpl>();
            ActivityImpl sameActivityImpl1 = processDefinitionEntity.findActivity(historicActivityInstances.get(i + 1).getActivityId());
            sameStartTimeNodes.add(sameActivityImpl1);
            for (int j = i + 1; j < historicActivityInstances.size() - 1; ++j) {
                HistoricActivityInstance activityImpl1 = historicActivityInstances.get(j);
                HistoricActivityInstance activityImpl2 = historicActivityInstances.get(j + 1);
                if (!activityImpl1.getStartTime().equals(activityImpl2.getStartTime())) break;
                ActivityImpl sameActivityImpl2 = processDefinitionEntity.findActivity(activityImpl2.getActivityId());
                sameStartTimeNodes.add(sameActivityImpl2);
            }
            List pvmTransitions = activityImpl.getOutgoingTransitions();
            for (PvmTransition pvmTransition : pvmTransitions) {
                ActivityImpl pvmActivityImpl = (ActivityImpl)pvmTransition.getDestination();
                if (!sameStartTimeNodes.contains(pvmActivityImpl)) continue;
            }
        }
        return highFlows;
    }
}

