CREATE TABLE T_BASE_COMPANY_RAW_MATERIAL (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"RAW_MATERIAL" VARCHAR2(255 BYTE) NULL ,
"ORIGIN" VARCHAR2(255 BYTE) NULL ,
"SUPPLIER" VARCHAR2(255 BYTE) NULL ,
"PUR_AMOUNT_PROPORTION" NUMBER(20,2) NULL ,
"PURCHASE_AMOUNT" NUMBER(20,2) NULL ,
"START_TIME" DATE NULL ,
"EXPLAINATION" VARCHAR2(1000 BYTE) NULL ,
"IS_ENABLE" NUMBER(7,0) DEFAULT 1 NULL,
"FINISH_FLAG" NUMBER(7,0) DEFAULT 0 NULL,
"CREATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"UPDATE_TIME" DATE NULL 
)
;

COMMENT ON TABLE T_BASE_COMPANY_RAW_MATERIAL IS '供应商准入-主要供应商/原材料';
COMMENT ON COLUMN T_BASE_COMPANY_RAW_MATERIAL."ID" IS '主键';
COMMENT ON COLUMN T_BASE_COMPANY_RAW_MATERIAL."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN T_BASE_COMPANY_RAW_MATERIAL."PUR_COMPANY_ID" IS '采购商公司ID';
COMMENT ON COLUMN T_BASE_COMPANY_RAW_MATERIAL."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN T_BASE_COMPANY_RAW_MATERIAL."PUR_COMPANY_NAME" IS '采购商名称';
COMMENT ON COLUMN T_BASE_COMPANY_RAW_MATERIAL."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN T_BASE_COMPANY_RAW_MATERIAL."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN T_BASE_COMPANY_RAW_MATERIAL."SUP_COMPANY_NAME" IS '供应商名称';
COMMENT ON COLUMN T_BASE_COMPANY_RAW_MATERIAL."RAW_MATERIAL" IS '主要原材料';
COMMENT ON COLUMN T_BASE_COMPANY_RAW_MATERIAL."ORIGIN" IS '原产地';
COMMENT ON COLUMN T_BASE_COMPANY_RAW_MATERIAL."SUPPLIER" IS '供应商';
COMMENT ON COLUMN T_BASE_COMPANY_RAW_MATERIAL."PUR_AMOUNT_PROPORTION" IS '占原材料总采购金额的比例';
COMMENT ON COLUMN T_BASE_COMPANY_RAW_MATERIAL."PURCHASE_AMOUNT" IS '年采购额';
COMMENT ON COLUMN T_BASE_COMPANY_RAW_MATERIAL."START_TIME" IS '业务开始时间';
COMMENT ON COLUMN T_BASE_COMPANY_RAW_MATERIAL."EXPLAINATION" IS '说明';
COMMENT ON COLUMN T_BASE_COMPANY_RAW_MATERIAL."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN T_BASE_COMPANY_RAW_MATERIAL."FINISH_FLAG" IS '完成标识符(0=未完成，1=已完成)';
COMMENT ON COLUMN T_BASE_COMPANY_RAW_MATERIAL."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN T_BASE_COMPANY_RAW_MATERIAL."UPDATE_TIME" IS '修改时间';


ALTER TABLE T_BASE_COMPANY_RAW_MATERIAL ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE T_BASE_COMPANY_RAW_MATERIAL ADD PRIMARY KEY ("ID");
