/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.newcode.service.impl;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.entity.UserRoleExample;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.certification.cognize.entity.CompanyProductCognize;
import com.els.base.certification.cognize.entity.CompanyProductCognizeExample;
import com.els.base.certification.cognize.service.CompanyProductCognizeService;
import com.els.base.certification.contacts.entity.Contacts;
import com.els.base.certification.contacts.entity.ContactsExample;
import com.els.base.certification.contacts.service.ContactsService;
import com.els.base.certification.newcode.dao.CompanySupplierApplyMapper;
import com.els.base.certification.newcode.entity.CompanySupplierApply;
import com.els.base.certification.newcode.entity.CompanySupplierApplyExample;
import com.els.base.certification.newcode.entity.ProductTypeData;
import com.els.base.certification.newcode.service.CompanySupplierApplyService;
import com.els.base.certification.newcode.service.SupplierDataSendToSapService;
import com.els.base.certification.newcode.service.SupplierSapRelationService;
import com.els.base.certification.newcode.utils.CompanyNewCodeApplyEnum;
import com.els.base.certification.newcode.utils.CompanyNewCodeApplyUtils;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyPartner;
import com.els.base.company.entity.CompanyPartnerExample;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanySupplierApplyService")
public class CompanySupplierApplyServiceImpl
implements CompanySupplierApplyService,
ITaskListener {
    private static final Logger logger = LoggerFactory.getLogger(CompanySupplierApplyServiceImpl.class);
    private static final String SAP_SUCCESS_SIGN = "SUCCESS";
    @Resource
    private CompanySupplierApplyMapper companySupplierApplyMapper;
    @Resource
    private ContactsService contactsService;
    @Resource
    private CompanyService companyService;
    @Resource
    private CompanyProductCognizeService companyProductCognizeService;
    @Resource
    private SupplierSapRelationService supplierSapRelationService;
    @Resource
    private WorkFlowService workFlowService;
    @Resource
    private SupplierDataSendToSapService supplierDataSendToSapService;
    @Resource
    private GenerateCodeService generateCodeService;
    @Resource
    private RoleService roleService;
    @Resource
    private UserRoleService userRoleService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private DicGroupItemService dicGroupItemService;
    private static final String SUPPLIER_APPLY_BILL_NO = "SUPPLIER_APPLY_BILL_NO";

    @Override
    @CacheEvict(value={"companySupplierApply"}, allEntries=true)
    public void addObj(CompanySupplierApply t) {
        this.companySupplierApplyMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"companySupplierApply"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companySupplierApplyMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"companySupplierApply"}, allEntries=true)
    public void modifyObj(CompanySupplierApply t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companySupplierApplyMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"companySupplierApply"}, keyGenerator="redisKeyGenerator")
    public CompanySupplierApply queryObjById(String id) {
        return this.companySupplierApplyMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"companySupplierApply"}, keyGenerator="redisKeyGenerator")
    public List<CompanySupplierApply> queryAllObjByExample(CompanySupplierApplyExample example) {
        return this.companySupplierApplyMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"companySupplierApply"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanySupplierApply> queryObjByPage(CompanySupplierApplyExample example) {
        PageView<CompanySupplierApply> pageView = example.getPageView();
        pageView.setQueryResult(this.companySupplierApplyMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"companySupplierApply"}, allEntries=true)
    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        CompanySupplierApplyExample example = new CompanySupplierApplyExample();
        example.createCriteria().andIdIn((List)ids);
        List<CompanySupplierApply> list = this.companySupplierApplyMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("\u6570\u636e\u4e0d\u5b58\u5728!");
        }
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(CompanyNewCodeApplyEnum.STATUS_APPROVING.getStatus());
        statusList.add(CompanyNewCodeApplyEnum.STATUS_APPROVE_SUCCESS.getStatus());
        statusList.add(CompanyNewCodeApplyEnum.STATUS_APPLY_SAP_CODE.getStatus());
        statusList.add(CompanyNewCodeApplyEnum.STATUS_COMPLETE.getStatus());
        example.clear();
        example.createCriteria().andIdIn((List)ids).andApproveStatusIn(statusList);
        if (this.companySupplierApplyMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u62ec\u6b63\u5728\u5ba1\u6279\u6216\u5ba1\u6279\u6210\u529f\u6216\u5ba1\u6279\u9a73\u56de\u6216\u5df2\u7533\u8bf7SAP\u7f16\u7801\u6216\u5df2\u5b8c\u6210\u7684\u5355\u636e,\u65e0\u6cd5\u5220\u9664\u6570\u636e!");
        }
        CompanySupplierApply item = new CompanySupplierApply();
        item.setIsEnable(Constant.NO_INT);
        item.setUpdateTime(new Date());
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        this.companySupplierApplyMapper.updateByExampleSelective(item, example);
    }

    @Override
    public CompanySupplierApply generateBillInfo(Company company) {
        DicGroupItem areaItem;
        DicGroupItem companyTypeItem;
        if (null == company) {
            throw new CommonException("\u4f20\u9012\u7684\u53c2\u6570\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)company.getId())) {
            throw new CommonException("\u4f20\u9012\u7684\u4f9b\u5e94\u5546id\u4e3a\u7a7a!");
        }
        this.isExistBill(company.getId());
        Company com = (Company)this.companyService.queryObjById(company.getId());
        if (null == com) {
            throw new CommonException("\u67e5\u8be2\u4e0d\u5230\u4f9b\u5e94\u5546\u6570\u636e!");
        }
        CompanySupplierApply data = new CompanySupplierApply();
        data.setId(UUIDGenerator.generateUUID());
        Company purCompany = this.companyService.queryPurchaseCompanies(company.getId());
        data.setPurCompanyId(purCompany.getId());
        data.setPurCompanySrmCode(purCompany.getCompanyCode());
        data.setPurCompanyName(purCompany.getCompanyFullName());
        data.setPurCompanyShortName(purCompany.getCompanyName());
        data.setSupCompanyId(com.getId());
        data.setSupCompanySapCode(com.getCompanySapCode());
        data.setSupCompanySrmCode(com.getCompanyCode());
        data.setSupCompanyName(com.getCompanyFullName());
        data.setSupCompanyShortName(com.getCompanyName());
        data.setSupCompanyEnglishName(com.getEnglishCompanyName());
        data.setSupCompanyEnglishShortName(com.getCompanyEnglishAbbreviation());
        data.setSupCompanyAddress(com.getAddress());
        data.setSupCompanyEnglishAddress(com.getEnglishAddress());
        String applyBillNo = this.generateCodeService.getNextCode(SUPPLIER_APPLY_BILL_NO);
        data.setApplyBillNo(applyBillNo);
        if (StringUtils.isNotBlank((String)com.getCompanyType()) && null != (companyTypeItem = this.dicGroupItemService.queryItems("company_type", com.getCompanyType()))) {
            data.setCompanyType(com.getCompanyType());
            data.setCompanyTypeDesc(companyTypeItem.getDescription());
        }
        data.setBusinessLicenseNumber(com.getBusinessLicenseNumber());
        data.setIndustryCode(com.getIndustryCode());
        data.setProductServiceType(com.getSecondCompanyType());
        data.setProductServiceDesc(com.getSecondCompanyTypeDesc());
        data.setProductTypeFirst(com.getProductTypeFirst());
        data.setProductTypeFirstDesc(com.getProductTypeFirstDesc());
        data.setProductTypeFirstCognizance(com.getProductTypeFirstCognizance());
        data.setProductTypeSecond(com.getProductTypeSecond());
        data.setProductTypeSecondDesc(com.getProductTypeSecondDesc());
        data.setProductTypeSecondCognizance(com.getProductTypeSecondCognizance());
        data.setProductTypeThird(com.getProductTypeThird());
        data.setProductTypeThirdDesc(com.getProductTypeThirdDesc());
        data.setProductTypeThirdCognizance(com.getProductTypeThirdCognizance());
        data.setProductTypeFourth(com.getProductTypeFourth());
        data.setProductTypeFourthDesc(com.getProductTypeFourthDesc());
        data.setProductTypeFourthCognizance(com.getProductTypeFourthCognizance());
        data.setProductTypeFifth(com.getProductTypeFifth());
        data.setProductTypeFifthDesc(com.getProductTypeFifthDesc());
        data.setProductTypeFifthCognizance(com.getProductTypeFifthCognizance());
        data.setMobilephone(com.getMobilephone());
        data.setTelephone(com.getTelephone());
        data.setFax(com.getFax());
        data.setEmail(com.getEmail());
        data.setWebsite(com.getWebsite());
        data.setOrderCurren("CNY");
        data.setCompanyCode("3000");
        data.setCountryCode("CN");
        data.setGroupCode(com.getGroupCode());
        data.setPurchaseOrganization(com.getPurchasingGroup());
        data.setFirstClassification(com.getFirstCompanyType());
        data.setThirdClassification(com.getClassificationThree());
        data.setSecondClassification(com.getBusinessType());
        data.setTradeStyle(com.getExternalManufacturer());
        data.setSapIndustryCode(com.getIndustrialType());
        data.setBalanceStyle(com.getPayConditionsCode());
        data.setPurchaseCycle(com.getPurchaseCycle());
        data.setSearchItem(com.getCompanyName());
        data.setSupplierAccountGroup("FGE1");
        if (StringUtils.isNotBlank((String)com.getProvince()) && null != (areaItem = this.dicGroupItemService.queryItems("area_code", com.getProvince()))) {
            data.setArea(com.getProvince());
            data.setAreaName(areaItem.getValue());
        }
        data.setApproveStatus(CompanyNewCodeApplyEnum.STATUS_UN_APPROVE.getStatus());
        data.setIsEnable(Constant.YES_INT);
        data.setCreateBillTime(new Date());
        data.setCreateTime(new Date());
        List<Contacts> list = this.findContactsByCompanyId(com.getId());
        if (CollectionUtils.isNotEmpty(list)) {
            data.setContacts(list.get(0).getName());
        }
        if (StringUtils.isNotBlank((String)com.getCompanySapCode())) {
            if (com.getCompanySapCode().startsWith("1")) {
                data.setSupplierType("1");
            } else if (com.getCompanySapCode().startsWith("2")) {
                data.setSupplierType("2");
            }
        } else {
            data.setSupplierType("1");
        }
        data.setSupplierDevelopLeader(com.getSupplierDevelopLeader());
        data.setSqaLeader(com.getSqaLeader());
        this.setProductTypeJsonData(data);
        return data;
    }

    @Override
    public void setProductTypeJsonData(CompanySupplierApply data) {
        ArrayList<ProductTypeData> list = null;
        if (StringUtils.isNotBlank((String)data.getProductTypeFirst())) {
            list = new ArrayList<ProductTypeData>();
            ProductTypeData firstCompanyType = new ProductTypeData();
            firstCompanyType.setCode(data.getProductTypeFirst());
            firstCompanyType.setDesc(data.getProductTypeFirstDesc());
            firstCompanyType.setFlag(data.getProductTypeFirstCognizance());
            list.add(firstCompanyType);
            if (StringUtils.isNotBlank((String)data.getProductTypeSecond())) {
                ProductTypeData secondCompanyType = new ProductTypeData();
                secondCompanyType.setCode(data.getProductTypeSecond());
                secondCompanyType.setDesc(data.getProductTypeSecondDesc());
                secondCompanyType.setFlag(data.getProductTypeSecondCognizance());
                list.add(secondCompanyType);
                if (StringUtils.isNotBlank((String)data.getProductTypeThird())) {
                    ProductTypeData thirdCompanyType = new ProductTypeData();
                    thirdCompanyType.setCode(data.getProductTypeThird());
                    thirdCompanyType.setDesc(data.getProductTypeThirdDesc());
                    thirdCompanyType.setFlag(data.getProductTypeThirdCognizance());
                    list.add(thirdCompanyType);
                    if (StringUtils.isNotBlank((String)data.getProductTypeFourth())) {
                        ProductTypeData fourthCompanyType = new ProductTypeData();
                        fourthCompanyType.setCode(data.getProductTypeFourth());
                        fourthCompanyType.setDesc(data.getProductTypeFourthDesc());
                        fourthCompanyType.setFlag(data.getProductTypeFourthCognizance());
                        list.add(fourthCompanyType);
                        if (StringUtils.isNotBlank((String)data.getProductTypeFifth())) {
                            ProductTypeData fifthCompanyType = new ProductTypeData();
                            fifthCompanyType.setCode(data.getProductTypeFifth());
                            fifthCompanyType.setDesc(data.getProductTypeFifthDesc());
                            fifthCompanyType.setFlag(data.getProductTypeFifthCognizance());
                            list.add(fifthCompanyType);
                        }
                    }
                }
            }
        }
        data.setProductTypeJson(list);
    }

    private List<Contacts> findContactsByCompanyId(String companyId) {
        if (StringUtils.isEmpty((String)companyId)) {
            return null;
        }
        ContactsExample example = new ContactsExample();
        example.createCriteria().andSupCompanyIdEqualTo(companyId);
        List<Contacts> list = this.contactsService.queryAllObjByExample(example);
        return list;
    }

    @Override
    @CacheEvict(value={"companySupplierApply"}, allEntries=true)
    public void addRemark(CompanySupplierApply data) {
        if (StringUtils.isEmpty((String)data.getId())) {
            throw new CommonException("\u4f20\u9012\u7684\u53c2\u6570id\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)data.getRemark())) {
            throw new CommonException("\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a,\u6ca1\u6709\u8bf7\u586b'\u65e0'!");
        }
        this.companySupplierApplyMapper.updateByPrimaryKeySelective(data);
    }

    @Override
    @Transactional
    @CacheEvict(value={"companySupplierApply"}, allEntries=true)
    public void modifyData(CompanySupplierApply data, String purCompanyId) {
        CompanySupplierApply oldData = this.queryObjById(data.getId());
        if (null == oldData) {
            throw new CommonException("\u65e7\u5355\u636e\u4e0d\u5b58\u5728!");
        }
        logger.debug("\u3010\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7\u3011\u6548\u9a8c\u6570\u636e!");
        this.checkSupplierData(data);
        this.isEqualToCompanySecondCompanyType(data);
        if (oldData.getApproveStatus() == 1 || oldData.getApproveStatus() == 3 && StringUtils.isBlank((String)data.getSupCompanySapCode()) || oldData.getApproveStatus() == 4) {
            data.setUpdateTime(new Date());
            this.modifyObj(data);
        } else if (oldData.getApproveStatus() == 3 && StringUtils.isNotBlank((String)data.getSupCompanySapCode()) || oldData.getApproveStatus() == 5 || oldData.getApproveStatus() == 6) {
            logger.debug("\u3010\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7\u3011\u53cd\u5199SAP!");
            String result = this.supplierDataSendToSapService.sendSupplierDataToSap(data);
            if (!SAP_SUCCESS_SIGN.equalsIgnoreCase(result)) {
                throw new CommonException("\u53cd\u5199SAP\u63a5\u53e3\u5f02\u5e38\uff1a" + result);
            }
            logger.debug("\u3010\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7\u3011\u66f4\u65b0\u4f9b\u5e94\u5546\u4e3b\u6570\u636e!");
            this.updateSupplierData(data);
            this.changeToQualifiedSupplier(data, purCompanyId);
            this.supplierSapRelationService.saveSupplierSapRelation(data);
            this.updateSupplierProductTypeCognizeForUpdate(data, oldData);
            this.changeBillStatus(data);
        } else {
            throw new CommonException("\u8be5\u72b6\u6001\u4e0b\u7684\u5355\u636e\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\u6570\u636e!");
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"companySupplierApply"}, allEntries=true)
    public void writeToSap(CompanySupplierApply data, String purCompanyId) {
        CompanySupplierApply oldData = this.queryObjById(data.getId());
        if (null == oldData) {
            throw new CommonException("\u65e7\u5355\u636e\u4e0d\u5b58\u5728!");
        }
        if (StringUtils.isEmpty((String)data.getSupCompanySapCode())) {
            throw new CommonException("\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u5199\u5165SAP!");
        }
        if (CompanyNewCodeApplyEnum.STATUS_APPLY_SAP_CODE.getStatus().equals(oldData.getApproveStatus()) || CompanyNewCodeApplyEnum.STATUS_COMPLETE.getStatus().equals(oldData.getApproveStatus()) || CompanyNewCodeApplyEnum.STATUS_APPROVE_SUCCESS.getStatus().equals(oldData.getApproveStatus()) && StringUtils.isNotBlank((String)data.getSupCompanySapCode())) {
            this.isEqualToCompanySecondCompanyType(data);
            logger.debug("\u3010\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7\u3011\u6548\u9a8c\u6570\u636e!");
            this.checkSupplierData(data);
            logger.debug("\u3010\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7\u3011\u53cd\u5199SAP!");
            String result = this.supplierDataSendToSapService.sendSupplierDataToSap(data);
            if (!SAP_SUCCESS_SIGN.equalsIgnoreCase(result)) {
                throw new CommonException("\u53cd\u5199SAP\u63a5\u53e3\u5f02\u5e38\uff1a" + result);
            }
        } else {
            throw new CommonException("\u53ea\u6709\u5df2\u7533\u8bf7SAP\u7f16\u7801\u6216\u5df2\u5b8c\u6210\u7684\u5355\u636e\u624d\u53ef\u4ee5\u5199\u5165SAP!");
        }
        logger.debug("\u3010\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7\u3011\u66f4\u65b0\u4f9b\u5e94\u5546\u4e3b\u6570\u636e!");
        this.updateSupplierData(data);
        this.changeToQualifiedSupplier(data, purCompanyId);
        this.supplierSapRelationService.saveSupplierSapRelation(data);
        this.updateSupplierProductTypeCognizeForUpdate(data, oldData);
        this.changeBillStatus(data);
    }

    @Override
    @Transactional
    @CacheEvict(value={"companySupplierApply"}, allEntries=true)
    public void create(CompanySupplierApply data, String purCompanyId) {
        logger.debug("\u3010\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7\u3011\u5224\u65ad\u662f\u5426\u6709\u5b58\u5728\u6570\u636e!");
        this.isExistBill(data.getSupCompanyId());
        this.isEqualToCompanySecondCompanyType(data);
        logger.debug("\u3010\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7\u3011\u6548\u9a8c\u6570\u636e!");
        this.checkSupplierData(data);
        logger.debug("\u3010\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7\u3011\u4fdd\u5b58\u5355\u636e!");
        this.addObj(data);
    }

    private void changeBillStatus(CompanySupplierApply data) {
        data.setApproveStatus(CompanyNewCodeApplyEnum.STATUS_COMPLETE.getStatus());
        data.setUpdateTime(new Date());
        this.modifyObj(data);
    }

    private void updateSupplierProductTypeCognizeForUpdate(CompanySupplierApply newData, CompanySupplierApply oldData) {
        CompanyProductCognizeExample example = new CompanyProductCognizeExample();
        example.createCriteria().andSupCompanyIdEqualTo(newData.getSupCompanyId()).andIsEnableEqualTo(Constant.YES_INT);
        List list = this.companyProductCognizeService.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (CompanyProductCognize cognize : list) {
            if (newData.getProductTypeFirstCognizance() != null && newData.getProductTypeFirstCognizance() == 2 && oldData.getProductTypeFirstCognizance() != null && oldData.getProductTypeFirstCognizance() == 0) {
                cognize.setProductTypeFirstCognizance(Constant.YES_INT);
            } else if (newData.getProductTypeFirstCognizance() != null && newData.getProductTypeFirstCognizance() == 2 && oldData.getProductTypeFirstCognizance() != null && oldData.getProductTypeFirstCognizance() == 2) {
                cognize.setProductTypeFirstCognizance(Constant.YES_INT);
            } else if (oldData.getProductTypeFirstCognizance() != null && oldData.getProductTypeFirstCognizance() == 2 && newData.getProductTypeFirstCognizance() != null && newData.getProductTypeFirstCognizance() == 0) {
                cognize.setProductTypeFirstCognizance(Constant.NO_INT);
            } else if (oldData.getProductTypeFirstCognizance() != null && oldData.getProductTypeFirstCognizance() == 0 && newData.getProductTypeFirstCognizance() != null && newData.getProductTypeFirstCognizance() == 0) {
                cognize.setProductTypeFirstCognizance(Constant.NO_INT);
            }
            if (newData.getProductTypeSecondCognizance() != null && newData.getProductTypeSecondCognizance() == 2 && oldData.getProductTypeSecondCognizance() != null && oldData.getProductTypeSecondCognizance() == 0) {
                cognize.setProductTypeSecondCognizance(Constant.YES_INT);
            } else if (newData.getProductTypeSecondCognizance() != null && newData.getProductTypeSecondCognizance() == 2 && oldData.getProductTypeSecondCognizance() != null && oldData.getProductTypeSecondCognizance() == 2) {
                cognize.setProductTypeSecondCognizance(Constant.YES_INT);
            } else if (oldData.getProductTypeSecondCognizance() != null && oldData.getProductTypeSecondCognizance() == 2 && newData.getProductTypeSecondCognizance() != null && newData.getProductTypeSecondCognizance() == 0) {
                cognize.setProductTypeSecondCognizance(Constant.NO_INT);
            } else if (oldData.getProductTypeSecondCognizance() != null && oldData.getProductTypeSecondCognizance() == 0 && newData.getProductTypeSecondCognizance() != null && newData.getProductTypeSecondCognizance() == 0) {
                cognize.setProductTypeSecondCognizance(Constant.NO_INT);
            }
            if (newData.getProductTypeThirdCognizance() != null && newData.getProductTypeThirdCognizance() == 2 && oldData.getProductTypeThirdCognizance() != null && oldData.getProductTypeThirdCognizance() == 0) {
                cognize.setProductTypeThirdCognizance(Constant.YES_INT);
            } else if (newData.getProductTypeThirdCognizance() != null && newData.getProductTypeThirdCognizance() == 2 && oldData.getProductTypeThirdCognizance() != null && oldData.getProductTypeThirdCognizance() == 2) {
                cognize.setProductTypeThirdCognizance(Constant.YES_INT);
            } else if (oldData.getProductTypeThirdCognizance() != null && oldData.getProductTypeThirdCognizance() == 2 && newData.getProductTypeThirdCognizance() != null && newData.getProductTypeThirdCognizance() == 0) {
                cognize.setProductTypeThirdCognizance(Constant.NO_INT);
            } else if (oldData.getProductTypeThirdCognizance() != null && oldData.getProductTypeThirdCognizance() == 0 && newData.getProductTypeThirdCognizance() != null && newData.getProductTypeThirdCognizance() == 0) {
                cognize.setProductTypeThirdCognizance(Constant.NO_INT);
            }
            if (newData.getProductTypeFourthCognizance() != null && newData.getProductTypeFourthCognizance() == 2 && oldData.getProductTypeFourthCognizance() != null && oldData.getProductTypeFourthCognizance() == 0) {
                cognize.setProductTypeFourthCognizance(Constant.YES_INT);
            } else if (newData.getProductTypeFourthCognizance() != null && newData.getProductTypeFourthCognizance() == 2 && oldData.getProductTypeFourthCognizance() != null && oldData.getProductTypeFourthCognizance() == 2) {
                cognize.setProductTypeFourthCognizance(Constant.YES_INT);
            } else if (oldData.getProductTypeFourthCognizance() != null && oldData.getProductTypeFourthCognizance() == 2 && newData.getProductTypeFourthCognizance() != null && newData.getProductTypeFourthCognizance() == 0) {
                cognize.setProductTypeFourthCognizance(Constant.NO_INT);
            } else if (oldData.getProductTypeFourthCognizance() != null && oldData.getProductTypeFourthCognizance() == 0 && newData.getProductTypeFourthCognizance() != null && newData.getProductTypeFourthCognizance() == 0) {
                cognize.setProductTypeFourthCognizance(Constant.NO_INT);
            }
            if (newData.getProductTypeFifthCognizance() != null && newData.getProductTypeFifthCognizance() == 2 && oldData.getProductTypeFifthCognizance() != null && oldData.getProductTypeFifthCognizance() == 0) {
                cognize.setProductTypeFifthCognizance(Constant.YES_INT);
            } else if (newData.getProductTypeFifthCognizance() != null && newData.getProductTypeFifthCognizance() == 2 && oldData.getProductTypeFifthCognizance() != null && oldData.getProductTypeFifthCognizance() == 2) {
                cognize.setProductTypeFifthCognizance(Constant.YES_INT);
            } else if (oldData.getProductTypeFifthCognizance() != null && oldData.getProductTypeFifthCognizance() == 2 && newData.getProductTypeFifthCognizance() != null && newData.getProductTypeFifthCognizance() == 0) {
                cognize.setProductTypeFifthCognizance(Constant.NO_INT);
            } else if (oldData.getProductTypeFifthCognizance() != null && oldData.getProductTypeFifthCognizance() == 0 && newData.getProductTypeFifthCognizance() != null && newData.getProductTypeFifthCognizance() == 0) {
                cognize.setProductTypeFifthCognizance(Constant.NO_INT);
            }
            cognize.setUpdateTime(new Date());
            cognize.setSupCompanyName(newData.getSupCompanyName());
            cognize.setSupCompanyShortName(newData.getSupCompanyShortName());
            this.companyProductCognizeService.modifyObj(cognize);
        }
    }

    private void isEqualToCompanySecondCompanyType(CompanySupplierApply data) {
        Company company = (Company)this.companyService.queryObjById(data.getSupCompanyId());
        if (null == company) {
            throw new CommonException("\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728!");
        }
        if (StringUtils.isNotBlank((String)company.getSecondCompanyType()) && !company.getSecondCompanyType().equals(data.getProductServiceType())) {
            throw new CommonException("\u5f53\u524d\u5355\u636e\u7684\u4f9b\u5e94\u5546\u4ea7\u54c1\u5927\u7c7b\u4e0e\u4e3b\u6570\u636e\u4ea7\u54c1\u5927\u7c7b\u4e0d\u4e00\u81f4,\u8bf7\u91cd\u65b0\u751f\u6210\u5355\u636e!");
        }
    }

    private void changeToQualifiedSupplier(CompanySupplierApply data, String purCompanyId) {
        this.changeSupplierCompanyStatus(data, purCompanyId);
        this.changeSupplierAuthority(data, purCompanyId);
    }

    private void changeSupplierCompanyStatus(CompanySupplierApply data, String purCompanyId) {
        CompanyPartnerExample example = new CompanyPartnerExample();
        example.createCriteria().andCompanyIdEqualTo(purCompanyId).andPartnerCompanyIdEqualTo(data.getSupCompanyId());
        CompanyPartner cp = new CompanyPartner();
        cp.setPartnerRoleCode(PartnerRoleEnum.QUALIFIED.getCode());
        cp.setPartnerRoleName(PartnerRoleEnum.QUALIFIED.getName());
        this.companyService.updatePartnerRoleForApply(cp, example);
    }

    private void changeSupplierAuthority(CompanySupplierApply data, String purCompanyId) {
        RoleExample roleExample = new RoleExample();
        roleExample.createCriteria().andRoleCodeEqualTo(PartnerRoleEnum.QUALIFIED.getUserRoleCode());
        List list = this.roleService.queryAllObjByExample((IExample)roleExample);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            CompanyUserRefExample companyUserExample = new CompanyUserRefExample();
            companyUserExample.createCriteria().andCompanyIdEqualTo(data.getSupCompanyId());
            List companyUserRef = this.companyUserRefService.queryAllObjByExample(companyUserExample);
            UserRoleExample userRoleExample = new UserRoleExample();
            userRoleExample.createCriteria().andUserIdEqualTo(((CompanyUserRef)companyUserRef.get(0)).getUserId());
            List userRole = this.userRoleService.queryAllObjByExample((IExample)userRoleExample);
            for (UserRole ur : userRole) {
                for (Role role : list) {
                    ur.setRoleId(role.getId());
                    ur.setCreateTime(new Date());
                    this.userRoleService.modifyObj((Serializable)ur);
                }
            }
        }
    }

    private void isExistBill(String supCompanyId) {
        CompanySupplierApplyExample example = new CompanySupplierApplyExample();
        example.createCriteria().andSupCompanyIdEqualTo(supCompanyId).andIsEnableEqualTo(Constant.YES_INT);
        if (this.companySupplierApplyMapper.countByExample(example) > 0) {
            throw new CommonException("\u7cfb\u7edf\u4e2d\u5b58\u5728\u5355\u636e\u6b63\u5728\u4e3a\u5f53\u524d\u4f9b\u5e94\u5546\u7533\u8bf7\u7f16\u7801,\u8bf7\u52ff\u91cd\u590d\u521b\u5efa!");
        }
    }

    private void updateSupplierData(CompanySupplierApply data) {
        DicGroupItem deliveryModeDicItem;
        Company company = new Company();
        company.setId(data.getSupCompanyId());
        company.setCompanySapCode(data.getSupCompanySapCode());
        company.setEnglishCompanyName(data.getSupCompanyEnglishName());
        company.setCompanyName(data.getSupCompanyShortName());
        company.setCompanyFullName(data.getSupCompanyName());
        company.setFax(data.getFax());
        company.setCompanyType(data.getCompanyType());
        company.setBusinessLicenseNumber(data.getBusinessLicenseNumber());
        company.setIndustryCode(data.getIndustryCode());
        company.setIndustryDesc(data.getIndustryDesc());
        company.setWebsite(data.getWebsite());
        company.setOrderCurren(data.getOrderCurren());
        if (StringUtils.isNotEmpty((String)data.getOrderCurren()) && null != (deliveryModeDicItem = this.dicGroupItemService.queryItems("zr_ordercurren", data.getOrderCurren()))) {
            company.setOrderCurrenDesc(deliveryModeDicItem.getName());
        }
        company.setExternalManufacturer(data.getTradeStyle());
        company.setPayConditionsCode(data.getBalanceStyle());
        company.setPaymentPeriod(data.getBalanceStyle());
        if (StringUtils.isNotEmpty((String)data.getBalanceStyle()) && null != (deliveryModeDicItem = this.dicGroupItemService.queryItems("zr_fukuanfangshi", data.getBalanceStyle()))) {
            company.setPayConditionsDesc(deliveryModeDicItem.getName());
            company.setPaymentPeriodDesc(deliveryModeDicItem.getName());
        }
        company.setCountry(data.getCountryCode());
        company.setPurchasingGroup(data.getPurchaseOrganization());
        company.setGroupCode(data.getSupplierDevelopLeader());
        company.setBusinessType(data.getSecondClassification());
        company.setFirstCompanyType(data.getFirstClassification());
        company.setIndustrialType(data.getSapIndustryCode());
        company.setClassificationThree(data.getThirdClassification());
        company.setDelegateType(data.getCompanyTypeDesc());
        company.setProvince(data.getArea());
        company.setPurchaseCycle(data.getPurchaseCycle());
        company.setSupplierDevelopLeader(data.getSupplierDevelopLeader());
        company.setSqaLeader(data.getSqaLeader());
        company.setIsWriteSapSuccess(Constant.YES_INT);
        if (data.getProductTypeFirstCognizance() > 0) {
            company.setProductTypeFirstCognizance(Constant.YES_INT);
        } else {
            company.setProductTypeFirstCognizance(Constant.NO_INT);
        }
        if (data.getProductTypeSecondCognizance() > 0) {
            company.setProductTypeSecondCognizance(Constant.YES_INT);
        } else {
            company.setProductTypeSecondCognizance(Constant.NO_INT);
        }
        if (data.getProductTypeThirdCognizance() > 0) {
            company.setProductTypeThirdCognizance(Constant.YES_INT);
        } else {
            company.setProductTypeThirdCognizance(Constant.NO_INT);
        }
        if (data.getProductTypeFourthCognizance() > 0) {
            company.setProductTypeFourthCognizance(Constant.YES_INT);
        } else {
            company.setProductTypeFourthCognizance(Constant.NO_INT);
        }
        if (data.getProductTypeFifthCognizance() > 0) {
            company.setProductTypeFifthCognizance(Constant.YES_INT);
        } else {
            company.setProductTypeFifthCognizance(Constant.NO_INT);
        }
        this.companyService.modifyObj(company);
    }

    private void checkSupplierData(CompanySupplierApply data) {
        if (StringUtils.isEmpty((String)data.getCompanyCode())) {
            throw new CommonException("\u516c\u53f8\u4ee3\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getPurchaseOrganization())) {
            throw new CommonException("\u91c7\u8d2d\u7ec4\u7ec7\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getSupplierAccountGroup())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u8d26\u6237\u7ec4\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getSupCompanyName())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u4e2d\u6587\u540d\u79f0\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        data.setSupCompanyName(data.getSupCompanyName().replaceAll("\\s*", ""));
        if (data.getSupCompanyName().length() > 40) {
            throw new CommonException("\u4f01\u4e1a\u4e2d\u6587\u540d\u79f0\u4e0d\u80fd\u5927\u4e8e40\u4e2a\u5b57\u7b26!");
        }
        if (StringUtils.isEmpty((String)data.getSupCompanyShortName())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u7b80\u79f0\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isNotBlank((String)data.getSupCompanyEnglishName()) && data.getSupCompanyEnglishName().length() > 40) {
            throw new CommonException("\u4f01\u4e1a\u82f1\u6587\u5168\u79f0\u4e0d\u80fd\u8d85\u8fc740\u4e2a\u5b57\u7b26!");
        }
        if (StringUtils.isEmpty((String)data.getSupCompanyAddress())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u5730\u5740\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getCountryCode())) {
            throw new CommonException("\u56fd\u5bb6\u4ee3\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getArea())) {
            throw new CommonException("\u5730\u533a\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getTelephone())) {
            throw new CommonException("\u7535\u8bdd\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getFax())) {
            throw new CommonException("\u4f20\u771f\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getEmail())) {
            throw new CommonException("\u90ae\u4ef6\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getSupplierDevelopLeader())) {
            throw new CommonException("\u5f00\u53d1\u90e8\u62c5\u5f53\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (data.getSupplierDevelopLeader().length() > 10) {
            throw new CommonException("SAP\u8981\u6c42\u8f93\u5165\u7684\u5f00\u53d1\u90e8\u62c5\u5f53\u5b57\u6570\u4e0d\u80fd\u8d85\u8fc710!");
        }
        if (StringUtils.isEmpty((String)data.getCompanyType())) {
            throw new CommonException("\u4f01\u4e1a\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)data.getCompanyTypeDesc())) {
            throw new CommonException("\u4f01\u4e1a\u7c7b\u578b\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)data.getSecondClassification())) {
            throw new CommonException("\u5206\u7c7b2\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getSapIndustryCode())) {
            throw new CommonException("\u5de5\u4e1a\u7c7b\u578b\u4ee3\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getIndustryCode())) {
            throw new CommonException("\u884c\u4e1a\u4ee3\u7801\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getTradeStyle())) {
            throw new CommonException("\u4ea4\u6613\u65b9\u5f0f\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getBalanceStyle())) {
            throw new CommonException("\u7ed3\u7b97\u65b9\u5f0f\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        if (StringUtils.isEmpty((String)data.getOrderCurren())) {
            throw new CommonException("\u8d27\u5e01\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"companySupplierApply"}, allEntries=true)
    public void sendToApprove(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(CompanyNewCodeApplyEnum.STATUS_APPROVING.getStatus());
        statusList.add(CompanyNewCodeApplyEnum.STATUS_APPROVE_SUCCESS.getStatus());
        statusList.add(CompanyNewCodeApplyEnum.STATUS_APPLY_SAP_CODE.getStatus());
        statusList.add(CompanyNewCodeApplyEnum.STATUS_COMPLETE.getStatus());
        CompanySupplierApplyExample example = new CompanySupplierApplyExample();
        example.createCriteria().andIdIn((List)ids).andApproveStatusIn(statusList);
        if (this.companySupplierApplyMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u62ec\u6b63\u5728\u5ba1\u6279\u6216\u5ba1\u6279\u6210\u529f\u6216\u5df2\u7533\u8bf7SAP\u7f16\u7801\u6216\u5df2\u5b8c\u6210\u7684\u5355\u636e,\u65e0\u6cd5\u53d1\u9001\u5ba1\u6279\u5355\u636e!");
        }
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        CompanySupplierApply data = new CompanySupplierApply();
        data.setApproveStatus(CompanyNewCodeApplyEnum.STATUS_APPROVING.getStatus());
        data.setUpdateTime(new Date());
        data.setApproveTime(new Date());
        this.companySupplierApplyMapper.updateByExampleSelective(data, example);
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        List<CompanySupplierApply> list = this.queryAllObjByExample(example);
        this.addToWorkFlow(list);
    }

    private void addToWorkFlow(List<CompanySupplierApply> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            for (CompanySupplierApply it : list) {
                ProcessStartVO vo = ProcessStartVO.newInstance("xgysbmdrb", it.getApplyBillNo(), it.getId(), "newSupplierInport?id=" + it.getId());
                vo.setListenerClass(this.getClass());
                ProcessInstance startProcess = this.workFlowService.startProcess(vo);
                if (null == startProcess) continue;
                CompanySupplierApply a = new CompanySupplierApply();
                a.setUpdateTime(new Date());
                a.setApproveStatus(CompanyNewCodeApplyEnum.STATUS_APPROVING.getStatus());
                a.setApproveTime(new Date());
                a.setApproveFlowId(startProcess.getProcessInstanceId());
                CompanySupplierApplyExample example = new CompanySupplierApplyExample();
                example.createCriteria().andIdEqualTo(it.getId());
                this.companySupplierApplyMapper.updateByExampleSelective(a, example);
            }
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"companySupplierApply"}, allEntries=true)
    public void listen(TaskOperateEvent event) {
        if (null == event) {
            logger.debug("\u5ba1\u6279\u6d41\u8fd4\u56de\u76d1\u542c\u4e8b\u4ef6\u4e3a\u7a7a!");
            return;
        }
        if (StringUtils.isEmpty((String)event.getBusinessId())) {
            logger.debug("\u5ba1\u6279\u6d41\u8fd4\u56de\u7684\u4e1a\u52a1id\u4e3a\u7a7a!");
            return;
        }
        CompanySupplierApply data = this.queryObjById(event.getBusinessId());
        if (null == data) {
            logger.debug("\u5ba1\u6279\u6d41\u8fd4\u56de\u7684\u4e1a\u52a1id\u67e5\u8be2\u7684\u5355\u636e\u4e3a\u7a7a!");
            return;
        }
        CompanySupplierApplyExample example = new CompanySupplierApplyExample();
        example.createCriteria().andIdEqualTo(event.getBusinessId());
        CompanySupplierApply a = new CompanySupplierApply();
        a.setUpdateTime(new Date());
        a.setApproveUserName(event.getAssignee());
        if (StringUtils.isNotEmpty((String)data.getApproveSuggestion())) {
            a.setApproveSuggestion(data.getApproveSuggestion() + "\n");
        } else {
            a.setApproveSuggestion("");
        }
        if (StringUtils.isEmpty((String)event.getApproveDesc())) {
            a.setApproveSuggestion(a.getApproveSuggestion() + event.getAssignee() + ":\u65e0");
        } else {
            a.setApproveSuggestion(a.getApproveSuggestion() + event.getAssignee() + ":" + event.getApproveDesc());
        }
        if (event.isFinished() && event.isPass()) {
            a.setApproveStatus(CompanyNewCodeApplyEnum.STATUS_APPROVE_SUCCESS.getStatus());
        } else if (event.isFinished() && !event.isPass()) {
            a.setApproveStatus(CompanyNewCodeApplyEnum.STATUS_APPROVE_FAIL.getStatus());
            if (StringUtils.isEmpty((String)data.getSupCompanyId())) {
                throw new CommonException("\u4f9b\u5e94\u5546id\u4e3a\u7a7a,\u5ba1\u6279\u9a73\u56de\u5931\u8d25");
            }
        }
        this.companySupplierApplyMapper.updateByExampleSelective(a, example);
    }

    @Override
    public FileData print(String projectId, String companyId, List<CompanySupplierApply> data) {
        if (null == data) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a!");
        }
        ArrayList<String> ids = null;
        for (CompanySupplierApply item : data) {
            if (StringUtils.isEmpty((String)item.getId())) {
                throw new CommonException("\u4f20\u9012\u7684\u53c2\u6570\u5217\u8868\u4e2d\u5b58\u5728id\u4e3a\u7a7a!");
            }
            if (null == ids) {
                ids = new ArrayList<String>();
            }
            ids.add(item.getId());
        }
        CompanySupplierApplyExample example = new CompanySupplierApplyExample();
        example.createCriteria().andIdIn(ids);
        List<CompanySupplierApply> billList = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(billList)) {
            throw new CommonException("\u67e5\u8be2\u7684\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u6253\u5370\u5355\u636e!");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("billList", billList);
        FileData fileData = null;
        try {
            fileData = CompanyNewCodeApplyUtils.generatePdf(projectId, companyId, params, "A4");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileData;
    }

    @Override
    @CacheEvict(value={"companySupplierApply"}, allEntries=true)
    public void updateBySupCompanySrmCode(CompanySupplierApplyExample example, CompanySupplierApply applyData) {
        this.companySupplierApplyMapper.updateByExampleSelective(applyData, example);
    }
}

