/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.recommend.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.recommend.entity.CompanyRecommendForm;
import com.els.base.certification.recommend.entity.CompanyRecommendFormExample;
import com.els.base.certification.recommend.service.CompanyRecommendFormService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f9b\u5e94\u5546\u51c6\u5165-\u5408\u683c\u4f9b\u5e94\u5546\u5bfc\u5165\u63a8\u8350\u8868")
@Controller
@RequestMapping(value={"companyRecommendForm"})
public class CompanyRecommendFormController {
    @Resource
    private CompanyRecommendFormService companyRecommendFormService;

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165-\u5408\u683c\u4f9b\u5e94\u5546\u5bfc\u5165\u63a8\u8350\u8868-\u6253\u5370")
    @RequestMapping(value={"service/print"})
    @ResponseBody
    public ResponseResult<FileData> print(@RequestBody(required=true) List<CompanyRecommendForm> companyRecommendFormList) {
        Assert.isNotEmpty(companyRecommendFormList, "\u6570\u636e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a,\u64cd\u4f5c\u5931\u8d25\uff01");
        FileData fileData = this.companyRecommendFormService.print(ProjectUtils.getProject(), CompanyUtils.currentCompany(), companyRecommendFormList);
        return ResponseResult.success(fileData);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636eid\u67e5\u8be2\u5408\u683c\u4f9b\u5e94\u5546\u5bfc\u5165\u63a8\u8350\u8868\u8be6\u60c5")
    @RequestMapping(value={"service/findDetailById"})
    @ResponseBody
    public ResponseResult<CompanyRecommendForm> findDetailById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "ID\u4e0d\u80fd\u4e3a\u7a7a");
        CompanyRecommendForm companyRecommendForm = (CompanyRecommendForm)this.companyRecommendFormService.queryObjById(id);
        return ResponseResult.success(companyRecommendForm);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165--\u5ba1\u6838\u9a73\u56de")
    @RequestMapping(value={"service/reject"})
    @ResponseBody
    public ResponseResult<String> reject(@RequestBody(required=true) List<CompanyRecommendForm> companyRecommendFormList) {
        if (CollectionUtils.isEmpty(companyRecommendFormList)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyRecommendFormService.reject(ProjectUtils.getProject(), CompanyUtils.currentCompany(), companyRecommendFormList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165--\u53d1\u9001\u5ba1\u6838")
    @RequestMapping(value={"service/sendApprove"})
    @ResponseBody
    public ResponseResult<String> sendApprove(@RequestBody(required=true) List<CompanyRecommendForm> companyRecommendFormList) {
        if (CollectionUtils.isEmpty(companyRecommendFormList)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyRecommendFormService.sendApprove(ProjectUtils.getProject(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), companyRecommendFormList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165--\u6279\u91cf\u4f5c\u5e9f\u5408\u683c\u4f9b\u5e94\u5546\u5bfc\u5165\u63a8\u8350\u8868")
    @RequestMapping(value={"service/abolish"})
    @ResponseBody
    public ResponseResult<String> abolish(@RequestBody(required=true) List<CompanyRecommendForm> companyRecommendFormList) {
        if (CollectionUtils.isEmpty(companyRecommendFormList)) {
            throw new CommonException("\u4f5c\u5e9f\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyRecommendFormService.abolish(ProjectUtils.getProject(), CompanyUtils.currentCompany(), companyRecommendFormList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u51c6\u5165-\u5408\u683c\u4f9b\u5e94\u5546\u5bfc\u5165\u63a8\u8350\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyRecommendForm companyRecommendForm) {
        if (companyRecommendForm == null) {
            throw new CommonException("\u5408\u683c\u4f9b\u5e94\u5546\u5bfc\u5165\u63a8\u8350\u8868\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.companyRecommendFormService.insert(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), companyRecommendForm);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165-\u6279\u91cf\u5220\u9664\u5408\u683c\u4f9b\u5e94\u5546\u5bfc\u5165\u63a8\u8350\u8868")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<CompanyRecommendForm> companyRecommendFormList) {
        if (CollectionUtils.isEmpty(companyRecommendFormList)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyRecommendFormService.deleteObjByIds(ProjectUtils.getProject(), CompanyUtils.currentCompany(), companyRecommendFormList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165-\u5408\u683c\u4f9b\u5e94\u5546\u5bfc\u5165\u63a8\u8350\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyRecommendForm", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyRecommendForm>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyRecommendFormExample example = new CompanyRecommendFormExample();
        example.setPageView(new PageView<CompanyRecommendForm>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        CompanyRecommendFormExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.companyRecommendFormService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}

