
CREATE TABLE "T_BASE_COMPANY_EQUIPMENT" (
"ID" VARCHAR2(32 BYTE) DEFAULT ''  NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"EQUIPMENT_CODE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"EQUIPMENT_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"EQUIPMENT_PRODUCT_PLACE" VARCHAR2(1000 BYTE) DEFAULT ''  NULL ,
"EQUIPMENT_ADVANTAGE" VARCHAR2(1000 BYTE) DEFAULT ''  NULL ,
"CREATE_TIME" DATE NULL ,
"EQUIPMENT_QUANTITY" NUMBER(7) DEFAULT 0  NULL ,
"REMARK" VARCHAR2(1000 BYTE) NULL ,
"FINISH_FLAG" NUMBER(7) DEFAULT 0  NULL ,
"IS_ENABLE" NUMBER(7) DEFAULT 1  NULL ,
"EQUIPMENT_CREATE_TIME" DATE NULL ,
"UPDATE_TIME" DATE NULL ,
"EQUIPMENT_PRODUCTER" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
"PURCHASE_PLAN" VARCHAR2(255 BYTE) DEFAULT ''  NULL 
);

COMMENT ON TABLE "T_BASE_COMPANY_EQUIPMENT" IS '关键试验，检验设备';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."EQUIPMENT_CODE" IS '设备型号';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."EQUIPMENT_NAME" IS '设备名称';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."EQUIPMENT_PRODUCT_PLACE" IS '设备生产地';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."EQUIPMENT_ADVANTAGE" IS '技术指标，优势简述';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."EQUIPMENT_QUANTITY" IS '设备数量';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."FINISH_FLAG" IS '完成标识符(0=未完成，1=已完成)';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."EQUIPMENT_CREATE_TIME" IS '设备生产时间';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."EQUIPMENT_PRODUCTER" IS '设备生产商';
COMMENT ON COLUMN "T_BASE_COMPANY_EQUIPMENT"."PURCHASE_PLAN" IS '同级设备购买计划';

ALTER TABLE "T_BASE_COMPANY_EQUIPMENT" ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE "T_BASE_COMPANY_EQUIPMENT" ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE "T_BASE_COMPANY_EQUIPMENT" ADD PRIMARY KEY ("ID");
