
CREATE TABLE "T_BASE_COMPANY_SUPPLY_RELATION" (
  "ID" VARCHAR2(32 BYTE) DEFAULT ''  NOT NULL ,
  "NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "POSITION" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "RESPONSIBILITY" VARCHAR2(1000 BYTE) DEFAULT ''  NULL ,
  "WORK_FLAG" NUMBER(7) DEFAULT 0  NULL ,
  "DIRECT_LINE_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "DOMESTIC_RELATION" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "FINISH_FLAG" NUMBER(7) DEFAULT 0  NULL ,
  "IS_ENABLE" NUMBER(7) DEFAULT 1  NULL ,
  "REMARK" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) DEFAULT ''  NULL ,
  "CREATE_TIME" DATE NULL ,
  "UPDATE_TIME" DATE NULL
);

COMMENT ON TABLE "T_BASE_COMPANY_SUPPLY_RELATION" IS '员工供货关系';
COMMENT ON COLUMN "T_BASE_COMPANY_SUPPLY_RELATION"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_COMPANY_SUPPLY_RELATION"."NAME" IS '姓名';
COMMENT ON COLUMN "T_BASE_COMPANY_SUPPLY_RELATION"."POSITION" IS '职位';
COMMENT ON COLUMN "T_BASE_COMPANY_SUPPLY_RELATION"."RESPONSIBILITY" IS '职责';
COMMENT ON COLUMN "T_BASE_COMPANY_SUPPLY_RELATION"."WORK_FLAG" IS '是否在华阳工作（0=不在，1=在）';
COMMENT ON COLUMN "T_BASE_COMPANY_SUPPLY_RELATION"."DIRECT_LINE_NAME" IS '在华阳工作之直系亲属名称';
COMMENT ON COLUMN "T_BASE_COMPANY_SUPPLY_RELATION"."DOMESTIC_RELATION" IS '关系名称';
COMMENT ON COLUMN "T_BASE_COMPANY_SUPPLY_RELATION"."FINISH_FLAG" IS '完成标识符(0=未完成，1=已完成)';
COMMENT ON COLUMN "T_BASE_COMPANY_SUPPLY_RELATION"."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN "T_BASE_COMPANY_SUPPLY_RELATION"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_COMPANY_SUPPLY_RELATION"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_COMPANY_SUPPLY_RELATION"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_COMPANY_SUPPLY_RELATION"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_COMPANY_SUPPLY_RELATION"."UPDATE_TIME" IS '更新时间';


ALTER TABLE "T_BASE_COMPANY_SUPPLY_RELATION" ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE "T_BASE_COMPANY_SUPPLY_RELATION" ADD CHECK ("ID" IS NOT NULL);

ALTER TABLE "T_BASE_COMPANY_SUPPLY_RELATION" ADD PRIMARY KEY ("ID");
