create table T_BASE_POTENTIAL_SUPPLIER_APPL 
(
   ID                   VARCHAR2(32 CHAR)    not null,
   PROJECT_ID           VARCHAR2(32 CHAR),
   SUP_COMPANY_ID       VARCHAR2(32 CHAR),
   STATUS               VARCHAR2(7 CHAR),
   SUP_COMPANY_SRM_CODE VARCHAR2(255 CHAR),
   DOCUMENT_NUMBER      VARCHAR2(255 CHAR),
   SUP_COMPANY_NAME     VARCHAR2(255 CHAR),
   SUPPLIER_TYPE        VARCHAR2(100 CHAR),
   MATERIAL_DESCRIPTION VARCHAR2(1000 CHAR),
   MATERIAL_TYPE        VARCHAR2(255 CHAR),
   DEMAND_SOURCES       VARCHAR2(255 CHAR),
   INTRODUCE_REASON     VARCHAR2(255 CHAR),
   REQUIREMENT_ANALYSIS VARCHAR2(1000 CHAR),
   CURRENT_STATUS       VARCHAR2(1000 CHAR),
   NECESSITY_ANALYSIS   VARCHAR2(1000 CHAR),
   CONCLUSION           VARCHAR2(1000 CHAR),
   REMARKS              VARCHAR2(1000 CHAR),
   SINGLE_PERSON        VARCHAR2(255 CHAR),
   APPROVAL_COMMENTS    VARCHAR2(1000 CHAR),
   APPROVE_SITUATION    VARCHAR2(255 CHAR),
   CREATE_TIME          DATE                 default SYSDATE,
   PENDING_APPROVAL_PEOPLE VARCHAR2(100 CHAR),
   AUDIT_TIME           DATE,
   IS_ENABLE            NUMBER (7)               default 1,
   IS_INVALID           NUMBER (7)              default 0,
   constraint PK_T_BASE_POTENTIAL_SUPPLIER_A primary key (ID)
);

comment on table T_BASE_POTENTIAL_SUPPLIER_APPL is '潜在供应商转入申请表';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.ID is '主键';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.PROJECT_ID is '项目ID';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.SUP_COMPANY_ID is '供应商ID';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.STATUS is '单据状态';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.SUP_COMPANY_SRM_CODE is '供应商编码';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.DOCUMENT_NUMBER is '单据号';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.SUP_COMPANY_NAME is '供应商名称';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.SUPPLIER_TYPE is '供应商类型';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.MATERIAL_DESCRIPTION is '物料描述';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.MATERIAL_TYPE is '物料类型';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.DEMAND_SOURCES is '需求来源';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.INTRODUCE_REASON is '引入原因';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.REQUIREMENT_ANALYSIS is '需求分析';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.CURRENT_STATUS is '目前状况';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.NECESSITY_ANALYSIS is '必要性分析';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.CONCLUSION is '结论';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.REMARKS is '备注';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.SINGLE_PERSON is '制单人';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.APPROVAL_COMMENTS is '审批意见';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.APPROVE_SITUATION is '审批情况';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.CREATE_TIME is '创建时间';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.PENDING_APPROVAL_PEOPLE is '当前待审批人';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.AUDIT_TIME is '审核时间';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.IS_ENABLE is '记录是否可用(0=不可用，1=可用)';

comment on column T_BASE_POTENTIAL_SUPPLIER_APPL.IS_INVALID is '单据是否作废(0=不作废，1=作废)';