
CREATE TABLE T_BASE_COMPANY_CONTRAST_ITEM (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"COMPANY_CONTRAST_ID" VARCHAR2(32 BYTE) NULL ,
"CONTRAST_BILL_NO" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_SHORT_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ADDRESS" VARCHAR2(255 BYTE) NULL ,
"ESTABLISH_TIME" VARCHAR2(255 BYTE) NULL ,
"REGISTER_CAPITAL" VARCHAR2(255 BYTE) NULL ,
"EMPLOYEE_QUANTITY" VARCHAR2(255 BYTE) NULL ,
"THREE_YEAR_SALE_AMOUNT" VARCHAR2(255 BYTE) NULL ,
"CAR_BUSINESS_PERCENT" VARCHAR2(255 BYTE) NULL ,
"CAR_BUSINESS_SALE_AMOUNT" VARCHAR2(255 BYTE) NULL ,
"MARKET_PERCENT" VARCHAR2(255 BYTE) NULL ,
"MAIN_PRODUCT" VARCHAR2(255 BYTE) NULL ,
"PRICE_DEVEL" VARCHAR2(255 BYTE) NULL ,
"MAIN_CUSTOMER" VARCHAR2(255 BYTE) NULL ,
"CAR_INDUSTRY_MAIN_CUSTOMER" VARCHAR2(255 BYTE) NULL ,
"MAIN_APPLY_FIELD" VARCHAR2(255 BYTE) NULL ,
"PURCHASE_CYCLE" VARCHAR2(255 BYTE) NULL ,
"TRANSPORT_STYLE" VARCHAR2(255 BYTE) NULL ,
"MONTHLY_CAPACITY" VARCHAR2(255 BYTE) NULL ,
"SUPPLY_MATERIAL_ELASTICITY" VARCHAR2(255 BYTE) NULL ,
"SYSTEM_CERTIFICATION" VARCHAR2(255 BYTE) NULL ,
"PPM_PERFORMANCE" VARCHAR2(255 BYTE) NULL ,
"BD_FEEDBACK_TIME" VARCHAR2(255 BYTE) NULL ,
"QUALITY_ENGINEER_QUANTITY" VARCHAR2(255 BYTE) NULL ,
"MAIN_TEST_DEVICE" VARCHAR2(255 BYTE) NULL ,
"QUALITY_SERVICE_OPERATE" VARCHAR2(255 BYTE) NULL ,
"QUALITY_CERTIFICATION" VARCHAR2(255 BYTE) NULL ,
"KEY_TECHNOLOGY" VARCHAR2(255 BYTE) NULL ,
"CORE_TECHNOLOGY" VARCHAR2(255 BYTE) NULL ,
"DEVELOP_ENGINEER_QUANTITY" VARCHAR2(255 BYTE) NULL ,
"MAIN_PRODUCT_TECHNOLOGY" VARCHAR2(255 BYTE) NULL ,
"MAIN_DEVELOP_SOFTWARE" VARCHAR2(255 BYTE) NULL ,
"PAYMENT_ACCOUNT_PERIOD" VARCHAR2(255 BYTE) NULL ,
"PROFIT_RATE" VARCHAR2(255 BYTE) NULL ,
"REMARK" VARCHAR2(1000 BYTE) NULL ,
"CREATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"UPDATE_TIME" DATE NULL 
)

;
COMMENT ON TABLE T_BASE_COMPANY_CONTRAST_ITEM IS '潜在供应商对比表行项';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."ID" IS '主键';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."COMPANY_CONTRAST_ID" IS '对比表头id';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."CONTRAST_BILL_NO" IS '单据号';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."SUP_COMPANY_ID" IS '供应商id';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."SUP_COMPANY_NAME" IS '供应商全称';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."SUP_COMPANY_SHORT_NAME" IS '供应商简称';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."SUP_COMPANY_ADDRESS" IS '供应商地址';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."ESTABLISH_TIME" IS '成立时间';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."REGISTER_CAPITAL" IS '注册资本';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."EMPLOYEE_QUANTITY" IS '员工人数';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."THREE_YEAR_SALE_AMOUNT" IS '近三年销售额';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."CAR_BUSINESS_PERCENT" IS '汽车类业务比例';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."CAR_BUSINESS_SALE_AMOUNT" IS '汽车类业务销售额';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."MARKET_PERCENT" IS '市场份额';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."MAIN_PRODUCT" IS '主要产品';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."PRICE_DEVEL" IS '价格水平';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."MAIN_CUSTOMER" IS '主要客户';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."CAR_INDUSTRY_MAIN_CUSTOMER" IS '汽车行业主要客户';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."MAIN_APPLY_FIELD" IS '主要应用领域';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."PURCHASE_CYCLE" IS '采购周期';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."TRANSPORT_STYLE" IS '运输方式';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."MONTHLY_CAPACITY" IS '月产能';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."SUPPLY_MATERIAL_ELASTICITY" IS '供货弹性';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."SYSTEM_CERTIFICATION" IS '体系认证';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."PPM_PERFORMANCE" IS 'PPM表现';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."BD_FEEDBACK_TIME" IS 'BD反馈时间';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."QUALITY_ENGINEER_QUANTITY" IS '质量工程师数量';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."MAIN_TEST_DEVICE" IS '主要测试设备';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."QUALITY_SERVICE_OPERATE" IS '汽车客户质量服务经营';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."QUALITY_CERTIFICATION" IS '体质量系认证';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."KEY_TECHNOLOGY" IS '关键技术应用';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."CORE_TECHNOLOGY" IS '核心技术';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."DEVELOP_ENGINEER_QUANTITY" IS '研发工程师数量';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."MAIN_PRODUCT_TECHNOLOGY" IS '主要生产技术';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."MAIN_DEVELOP_SOFTWARE" IS '主要开发软件';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."PAYMENT_ACCOUNT_PERIOD" IS '付款账期';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."PROFIT_RATE" IS '毛利率';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."REMARK" IS '行备注';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST_ITEM."UPDATE_TIME" IS '修改时间';


ALTER TABLE T_BASE_COMPANY_CONTRAST_ITEM ADD CHECK ("ID" IS NOT NULL);

ALTER TABLE T_BASE_COMPANY_CONTRAST_ITEM ADD PRIMARY KEY ("ID");
