/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.notice.service.impl;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.entity.UserRoleExample;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.certification.common.ConfirmStatusEnum;
import com.els.base.certification.notice.dao.CompanyAuditNoticeMapper;
import com.els.base.certification.notice.entity.CompanyAuditNotice;
import com.els.base.certification.notice.entity.CompanyAuditNoticeExample;
import com.els.base.certification.notice.service.CompanyAuditNoticeService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyAuditNoticeService")
public class CompanyAuditNoticeServiceImpl
implements CompanyAuditNoticeService {
    @Resource
    private CompanyAuditNoticeMapper companyAuditNoticeMapper;
    @Resource
    private CompanyService companyService;
    @Resource
    private GenerateCodeService generateCodeService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private RoleService roleService;
    @Resource
    private UserRoleService userRoleService;
    @Resource
    private UserService userService;
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    @Transactional
    public void confirm(final Project project, final Company company, final User loginUser, CompanyAuditNotice data) {
        if (StringUtils.isBlank((String)data.getId())) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        if (StringUtils.isBlank((String)data.getSupplierReply())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u56de\u590d\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        CompanyAuditNoticeExample companyAuditNoticeExample = new CompanyAuditNoticeExample();
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(ConfirmStatusEnum.STATUS_ABOLISH.getStatus());
        list.add(ConfirmStatusEnum.STATUS_CONFIRM.getStatus());
        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria().andIdEqualTo(data.getId()).andConfirmStatusIn(list).andProjectIdEqualTo(project.getId());
        int count = this.companyAuditNoticeMapper.countByExample(companyAuditNoticeExample);
        if (count > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u5df2\u4f5c\u5e9f\u6216\u8005\u5df2\u786e\u8ba4\u6570\u636e\uff0c\u4e0d\u80fd\u518d\u64cd\u4f5c!");
        }
        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria().andIdEqualTo(data.getId()).andPurCompanyIdEqualTo(project.getCompanyId()).andSendStatusEqualTo(Constant.NO_INT).andProjectIdEqualTo(project.getId());
        int count2 = this.companyAuditNoticeMapper.countByExample(companyAuditNoticeExample);
        if (count2 > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u672a\u53d1\u9001\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria().andIdEqualTo(data.getId()).andConfirmStatusEqualTo(ConfirmStatusEnum.STATUS_UNCONFIRM.getStatus()).andProjectIdEqualTo(project.getId());
        List<CompanyAuditNotice> companyAuditNoticeList = this.companyAuditNoticeMapper.selectByExample(companyAuditNoticeExample);
        if (CollectionUtils.isEmpty(companyAuditNoticeList)) {
            return;
        }
        for (final CompanyAuditNotice companyAuditNotice : companyAuditNoticeList) {
            companyAuditNotice.setConfirmStatus(ConfirmStatusEnum.STATUS_CONFIRM.getStatus());
            companyAuditNotice.setSupplierReply(data.getSupplierReply());
            this.companyAuditNoticeMapper.updateByPrimaryKeySelective(companyAuditNotice);
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    CompanyAuditNoticeServiceImpl.this.sendMessagesToPur(project, company, loginUser, companyAuditNotice);
                }
            });
        }
    }

    private void sendMessagesToPur(Project project, Company company, User loginUser, CompanyAuditNotice companyAuditNotice) {
        List<String> userIds = this.queryMainUserByAuthName(project, "admittance");
        if (CollectionUtils.isEmpty(userIds)) {
            throw new CommonException("\u91c7\u8d2d\u516c\u53f8\u6ce8\u5165\u7ba1\u7406\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!");
        }
        Message message = Message.init((Object)companyAuditNotice).setBusinessTypeCode("COMPANY_AUDIT_NOTICE_CONFIRM").setCompanyCode(company.getCompanyCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverIdList(userIds);
        MessageSendUtils.sendMessage((Message)message);
    }

    private List<String> queryMainUserByAuthName(Project project, String roleCode) {
        if (StringUtils.isBlank((String)roleCode)) {
            throw new CommonException("\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        RoleExample roleExample = new RoleExample();
        roleExample.createCriteria().andProjectIdEqualTo(project.getId()).andRoleCodeEqualTo(roleCode).andCompanyIdEqualTo(project.getCompanyId());
        List roles = this.roleService.queryAllObjByExample((IExample)roleExample);
        if (CollectionUtils.isEmpty((Collection)roles)) {
            throw new CommonException("\u6743\u9650\u4e0d\u5b58\u5728!");
        }
        Role role = (Role)roles.get(0);
        if (role == null) {
            throw new CommonException("\u6743\u9650\u4e0d\u5b58\u5728!");
        }
        UserRoleExample userRoleExample = new UserRoleExample();
        userRoleExample.createCriteria().andRoleIdEqualTo(role.getId());
        List userRoles = this.userRoleService.queryAllObjByExample((IExample)userRoleExample);
        if (CollectionUtils.isEmpty((Collection)userRoles)) {
            throw new CommonException("\u7528\u6237\u89d2\u8272\u4e0d\u5b58\u5728!");
        }
        ArrayList<String> userIds = new ArrayList<String>();
        for (UserRole userRole : userRoles) {
            if (!StringUtils.isNotBlank((String)userRole.getUserId())) continue;
            userIds.add(userRole.getUserId());
        }
        return userIds;
    }

    @Override
    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    @Transactional
    public void abolish(Project project, Company company, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        CompanyAuditNoticeExample companyAuditNoticeExample = new CompanyAuditNoticeExample();
        companyAuditNoticeExample.createCriteria().andIdIn((List)ids).andPurCompanyIdEqualTo(project.getCompanyId()).andSendStatusEqualTo(Constant.NO_INT).andProjectIdEqualTo(project.getId());
        int count2 = this.companyAuditNoticeMapper.countByExample(companyAuditNoticeExample);
        if (count2 > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u672a\u53d1\u9001\u7684\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        ArrayList<Integer> theseElements = new ArrayList<Integer>();
        theseElements.add(ConfirmStatusEnum.STATUS_ABOLISH.getStatus());
        theseElements.add(ConfirmStatusEnum.STATUS_CONFIRM.getStatus());
        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria().andIdIn((List)ids).andPurCompanyIdEqualTo(project.getCompanyId()).andConfirmStatusIn(theseElements).andProjectIdEqualTo(project.getId());
        int count = this.companyAuditNoticeMapper.countByExample(companyAuditNoticeExample);
        if (count > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u5df2\u4f5c\u5e9f\u6216\u8005\u5df2\u786e\u8ba4\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        CompanyAuditNotice companyAuditNotice = new CompanyAuditNotice();
        companyAuditNotice.setConfirmStatus(ConfirmStatusEnum.STATUS_ABOLISH.getStatus());
        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria().andIdIn((List)ids).andPurCompanyIdEqualTo(project.getCompanyId()).andSendStatusEqualTo(Constant.YES_INT).andProjectIdEqualTo(project.getId());
        this.companyAuditNoticeMapper.updateByExampleSelective(companyAuditNotice, companyAuditNoticeExample);
    }

    @Override
    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    @Transactional
    public void send(final Project project, Company company, final User loginUser, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        CompanyAuditNoticeExample companyAuditNoticeExample = new CompanyAuditNoticeExample();
        companyAuditNoticeExample.createCriteria().andIdIn((List)ids).andSendStatusEqualTo(Constant.YES_INT).andProjectIdEqualTo(project.getId());
        int count = this.companyAuditNoticeMapper.countByExample(companyAuditNoticeExample);
        if (count > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u5df2\u53d1\u9001\u6570\u636e\uff0c\u4e0d\u80fd\u518d\u64cd\u4f5c!");
        }
        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria().andIdIn((List)ids).andProjectIdEqualTo(project.getId());
        List<CompanyAuditNotice> companyAuditNoticeList = this.companyAuditNoticeMapper.selectByExample(companyAuditNoticeExample);
        if (CollectionUtils.isEmpty(companyAuditNoticeList)) {
            return;
        }
        for (final CompanyAuditNotice companyAuditNotice : companyAuditNoticeList) {
            companyAuditNotice.setSendStatus(Constant.YES_INT);
            this.companyAuditNoticeMapper.updateByPrimaryKeySelective(companyAuditNotice);
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    CompanyAuditNoticeServiceImpl.this.sendMessagesToSup(project, loginUser, companyAuditNotice);
                }
            });
        }
    }

    private void sendMessagesToSup(Project project, User loginUser, CompanyAuditNotice companyAuditNotice) {
        User user = this.companyUserRefService.queryMainUserOfCompany(companyAuditNotice.getSupCompanyId());
        Company purCompany = (Company)this.companyService.queryObjById(project.getCompanyId());
        Message message = Message.init((Object)companyAuditNotice).setBusinessTypeCode("COMPANY_AUDIT_NOTICE_SEND").setCompanyCode(purCompany.getCompanyCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(user.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    @Override
    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    @Transactional
    public void deleteObjByIds(Project project, Company company, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        CompanyAuditNoticeExample companyAuditNoticeExample = new CompanyAuditNoticeExample();
        companyAuditNoticeExample.createCriteria().andIdIn((List)ids).andPurCompanyIdEqualTo(project.getCompanyId()).andSendStatusEqualTo(Constant.YES_INT).andProjectIdEqualTo(project.getId());
        int count = this.companyAuditNoticeMapper.countByExample(companyAuditNoticeExample);
        if (count > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u5df2\u53d1\u9001\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria().andIdIn((List)ids).andPurCompanyIdEqualTo(project.getCompanyId()).andConfirmStatusEqualTo(ConfirmStatusEnum.STATUS_CONFIRM.getStatus()).andProjectIdEqualTo(project.getId());
        int count2 = this.companyAuditNoticeMapper.countByExample(companyAuditNoticeExample);
        if (count2 > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u5df2\u786e\u8ba4\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        CompanyAuditNotice companyAuditNotice = new CompanyAuditNotice();
        companyAuditNotice.setIsEnable(Constant.NO_INT);
        companyAuditNoticeExample.clear();
        companyAuditNoticeExample.createCriteria().andIdIn((List)ids).andPurCompanyIdEqualTo(project.getCompanyId()).andSendStatusEqualTo(Constant.NO_INT).andProjectIdEqualTo(project.getId());
        this.companyAuditNoticeMapper.updateByExampleSelective(companyAuditNotice, companyAuditNoticeExample);
    }

    @Override
    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    @Transactional
    public void insert(String projectId, Company company, User user, CompanyAuditNotice companyAuditNotice) {
        if (companyAuditNotice == null) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        if (companyAuditNotice.getSceneAuditTime() != null) {
            try {
                companyAuditNotice.setSceneAuditTime(formatter.parse(formatter.format(companyAuditNotice.getSceneAuditTime())));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        if (StringUtils.isEmpty((String)companyAuditNotice.getId())) {
            this.setSupCompanyInfo(ProjectUtils.getProject(), companyAuditNotice);
            this.setPurCompanyInfo(company, companyAuditNotice);
            this.setCompanyAuditNoticeInfo(ProjectUtils.getProject(), user, companyAuditNotice);
            this.companyAuditNoticeMapper.insertSelective(companyAuditNotice);
        } else {
            companyAuditNotice.setUpdateTime(new Date());
            this.companyAuditNoticeMapper.updateByPrimaryKey(companyAuditNotice);
        }
    }

    private void setCompanyAuditNoticeInfo(Project project, User user, CompanyAuditNotice companyAuditNotice) {
        companyAuditNotice.setProjectId(project.getId());
        companyAuditNotice.setCreateBillName(user.getNickName());
        companyAuditNotice.setCreateTime(new Date());
        String auditNoticeNo = this.generateCodeService.getNextCode("AUDIT_NOTICE_NO");
        companyAuditNotice.setAuditNoticeNo(auditNoticeNo);
        companyAuditNotice.setIsEnable(Constant.YES_INT);
        companyAuditNotice.setSendStatus(Constant.NO_INT);
        companyAuditNotice.setConfirmStatus(ConfirmStatusEnum.STATUS_UNCONFIRM.getStatus());
    }

    private void setPurCompanyInfo(Company company, CompanyAuditNotice companyAuditNotice) {
        companyAuditNotice.setPurCompanyId(company.getId());
        companyAuditNotice.setPurCompanyName(company.getCompanyName());
        companyAuditNotice.setPurCompanyFullName(company.getCompanyFullName());
        companyAuditNotice.setPurCompanySrmCode(company.getCompanyCode());
        companyAuditNotice.setPurCompanySapCode(company.getCompanySapCode());
    }

    private void setSupCompanyInfo(Project project, CompanyAuditNotice companyAuditNotice) {
        if (StringUtils.isEmpty((String)companyAuditNotice.getSupCompanySrmCode())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u4f9b\u5e94\u5546SRM\u7f16\u7801");
        }
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andProjectIdEqualTo(project.getId()).andCompanyCodeEqualTo(companyAuditNotice.getSupCompanySrmCode());
        PageView<Company> companyPageView = this.companyService.querySupplerCompanies(project.getCompanyId(), companyExample, PartnerRoleEnum.POTENIAL.getCode());
        List<Company> queryResult = companyPageView.getQueryResult();
        if (CollectionUtils.isEmpty(queryResult)) {
            throw new CommonException("\u6f5c\u5728\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728", "do_not_exists", "\u6f5c\u5728\u4f9b\u5e94\u5546");
        }
        Company superCompany = queryResult.get(0);
        companyAuditNotice.setSupCompanyId(superCompany.getId());
        companyAuditNotice.setSupCompanySrmCode(superCompany.getCompanyCode());
        companyAuditNotice.setSupCompanySapCode(superCompany.getCompanySapCode());
        companyAuditNotice.setSupCompanyName(superCompany.getCompanyName());
        companyAuditNotice.setSupCompanyFullName(superCompany.getCompanyFullName());
        companyAuditNotice.setSupCompanyContacts(superCompany.getContacts());
        companyAuditNotice.setSupCompanyAddress(superCompany.getAddress());
    }

    @Override
    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    public void addObj(CompanyAuditNotice t) {
        this.companyAuditNoticeMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyAuditNoticeMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"companyAuditNotice"}, allEntries=true)
    public void modifyObj(CompanyAuditNotice t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyAuditNoticeMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"companyAuditNotice"}, keyGenerator="redisKeyGenerator")
    public CompanyAuditNotice queryObjById(String id) {
        return this.companyAuditNoticeMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"companyAuditNotice"}, keyGenerator="redisKeyGenerator")
    public List<CompanyAuditNotice> queryAllObjByExample(CompanyAuditNoticeExample example) {
        return this.companyAuditNoticeMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"companyAuditNotice"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyAuditNotice> queryObjByPage(CompanyAuditNoticeExample example) {
        PageView<CompanyAuditNotice> pageView = example.getPageView();
        pageView.setQueryResult(this.companyAuditNoticeMapper.selectByExampleByPage(example));
        return pageView;
    }
}

