/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.notice.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.notice.entity.CompanyAuditNotice;
import com.els.base.certification.notice.entity.CompanyAuditNoticeExample;
import com.els.base.certification.notice.service.CompanyAuditNoticeService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f9b\u5e94\u5546\u51c6\u5165-\u5ba1\u6838\u901a\u77e5\u5355")
@Controller
@RequestMapping(value={"companyAuditNotice"})
public class CompanyAuditNoticeController {
    @Resource
    private CompanyAuditNoticeService companyAuditNoticeService;

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165--\u4f9b\u5e94\u5546\u786e\u8ba4\u5ba1\u6838\u901a\u77e5\u5355")
    @RequestMapping(value={"service/confirm"})
    @ResponseBody
    public ResponseResult<String> confirm(@RequestBody(required=true) CompanyAuditNotice data) {
        if (null == data) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyAuditNoticeService.confirm(ProjectUtils.getProject(), CompanyUtils.currentCompany(), (User)SpringSecurityUtils.getLoginUser(), data);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165--\u6279\u91cf\u4f5c\u5e9f\u5ba1\u6838\u901a\u77e5\u5355\u7ed9\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/abolish"})
    @ResponseBody
    public ResponseResult<String> abolish(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyAuditNoticeService.abolish(ProjectUtils.getProject(), CompanyUtils.currentCompany(), ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165--\u6279\u91cf\u53d1\u9001\u5ba1\u6838\u901a\u77e5\u5355\u7ed9\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/send"})
    @ResponseBody
    public ResponseResult<String> send(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u53d1\u9001\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyAuditNoticeService.send(ProjectUtils.getProject(), CompanyUtils.currentCompany(), (User)SpringSecurityUtils.getLoginUser(), ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u51c6\u5165-\u5ba1\u6838\u901a\u77e5\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyAuditNotice companyAuditNotice) {
        this.companyAuditNoticeService.insert(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(), (User)SpringSecurityUtils.getLoginUser(), companyAuditNotice);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u4f9b\u5e94\u5546\u51c6\u5165-\u5ba1\u6838\u901a\u77e5\u5355")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyAuditNoticeService.deleteObjByIds(ProjectUtils.getProject(), CompanyUtils.currentCompany(), ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165-\u5ba1\u6838\u901a\u77e5\u5355(\u91c7\u8d2d\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyAuditNotice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyAuditNotice>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) throws IOException {
        CompanyAuditNoticeExample example = new CompanyAuditNoticeExample();
        example.setPageView(new PageView<CompanyAuditNotice>(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC ");
        CompanyAuditNoticeExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andPurCompanyIdEqualTo(ProjectUtils.getCompanyId()).andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.companyAuditNoticeService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165-\u5ba1\u6838\u901a\u77e5\u5355(\u4f9b\u5e94\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyAuditNotice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForSup"})
    @ResponseBody
    public ResponseResult<PageView<CompanyAuditNotice>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) throws IOException {
        CompanyAuditNoticeExample example = new CompanyAuditNoticeExample();
        example.setPageView(new PageView<CompanyAuditNotice>(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC ");
        CompanyAuditNoticeExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andSendStatusEqualTo(Constant.YES_INT).andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.companyAuditNoticeService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}

