/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.CompanyPurRef;
import com.els.base.company.entity.CompanyPurRefExample;
import com.els.base.company.entity.FriendGroup;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u91c7\u8d2d\u7528\u6237\u7ba1\u7406\u7684\u4f9b\u5e94\u5546")
@Controller
@RequestMapping(value={"companyPurRef"})
public class CompanyPurRefController {
    @Resource
    protected CompanyPurRefService companyPurRefService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u91c7\u8d2d\u7528\u6237\u7ba1\u7406\u7684\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyPurRef companyPurRef) {
        companyPurRef.setId(null);
        companyPurRef.setProjectId(ProjectUtils.getProjectId());
        companyPurRef.setUserId(SpringSecurityUtils.getLoginUserId());
        this.companyPurRefService.addObj(companyPurRef);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u91c7\u8d2d\u7528\u6237\u53ca\u5176\u7ba1\u7406\u4f9b\u5e94\u5546\u5173\u8054\u5173\u7cfb")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CompanyPurRef companyPurRef) {
        if (StringUtils.isBlank((String)companyPurRef.getId())) {
            throw new CommonException("Id\u4e3a\u7a7a", "id_is_blank");
        }
        this.companyPurRefService.modifyObj(companyPurRef);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u91c7\u8d2d\u7528\u6237\u53ca\u5176\u7ba1\u7406\u4f9b\u5e94\u5546\u5173\u8054\u5173\u7cfb")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("Id\u4e3a\u7a7a", "id_is_blank");
        }
        this.companyPurRefService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5206\u9875\u67e5\u8be2\u91c7\u8d2d\u7528\u6237\u53ca\u5176\u7ba1\u7406\u4f9b\u5e94\u5546\u5217\u8868")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyPurRef>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyPurRef") @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyPurRefExample example = new CompanyPurRefExample();
        example.setPageView(new PageView<CompanyPurRef>(pageNo, pageSize));
        CompanyPurRefExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        criteria.andUserIdEqualTo(SpringSecurityUtils.getLoginUserId());
        PageView pageData = this.companyPurRefService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u901a\u8fc7\u91c7\u8d2d\u7528\u6237\u67e5\u8be2\u5176\u8d1f\u8d23\u7684\u4f9b\u5e94\u5546\u8be6\u7ec6\u4fe1\u606f")
    @RequestMapping(value={"service/findAllCompanyByUserId"})
    @ResponseBody
    public ResponseResult<List<Company>> findAllCompanyByUserId(@RequestParam(required=true) String userId) {
        if (StringUtils.isBlank((String)userId)) {
            throw new CommonException("Id\u4e3a\u7a7a", "id_is_blank");
        }
        List<Company> companyList = this.companyPurRefService.queryAllCompanyByUserId(userId, null);
        return ResponseResult.success(companyList);
    }

    @ApiOperation(httpMethod="POST", value="\u901a\u8fc7\u91c7\u8d2d\u7528\u6237\u67e5\u8be2\u5176\u8d1f\u8d23\u7684\u4f9b\u5e94\u5546\u8be6\u7ec6\u4fe1\u606f,\u4f9b\u4ea4\u8d27\u8ba1\u5212\u548c\u91c7\u8d2d\u9884\u6d4b\u4f7f\u7528")
    @RequestMapping(value={"service/findAllCompanyForMaterialPlan"})
    @ResponseBody
    public ResponseResult<PageView<Company>> findAllCompanyForMaterialPlan(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper queryParams) {
        CompanyExample example = new CompanyExample();
        example.setPageView(new PageView<Company>(pageNo, pageSize));
        CompanyExample.Criteria cri = example.createCriteria();
        CriteriaUtils.addCriterion(cri, queryParams);
        PageView<Company> companyList = this.companyPurRefService.queryAllCompanyForPageView(SpringSecurityUtils.getLoginUserId(), example);
        if (companyList == null) {
            ArrayList data = new ArrayList();
            PageView pageView = new PageView(pageNo, pageSize);
            pageView.setRowCount(0);
            pageView.setQueryResult(data);
            return ResponseResult.success(pageView);
        }
        return ResponseResult.success(companyList);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u4f9b\u5e94\u5546ID\u67e5\u8be2\u5176\u8d1f\u8d23\u7684\u5168\u90e8\u91c7\u8d2d\u5458\u57fa\u672c\u4fe1\u606f\u53ca\u5176\u6240\u5728\u516c\u53f8\u7684\u8be6\u7ec6\u4fe1\u606f")
    @RequestMapping(value={"service/findCompanyContactUserInfo"})
    @ResponseBody
    public ResponseResult<List<FriendGroup>> findAllPurchaserUserInfo() {
        String companyId = CompanyUtils.currentCompanyId();
        List<FriendGroup> friendGroupList = this.companyPurRefService.queryPurchaseFriendGroup(companyId);
        return ResponseResult.success(friendGroupList);
    }
}

