/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.newcode.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.newcode.entity.CompanySupplierApply;
import com.els.base.certification.newcode.entity.CompanySupplierApplyExample;
import com.els.base.certification.newcode.service.CompanySupplierApplyService;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7")
@Controller
@RequestMapping(value={"companySupplierApply"})
public class CompanySupplierApplyController {
    @Resource
    private CompanySupplierApplyService companySupplierApplyService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanySupplierApply data) {
        if (null == data) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)data.getSupCompanyId())) {
            throw new CommonException("\u4f20\u9012\u7684\u4f9b\u5e94\u5546id\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        data.setOperateStatus(Constant.YES_INT);
        String purCompanyId = ProjectUtils.getProject().getCompanyId();
        this.companySupplierApplyService.create(data, purCompanyId);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5c06\u4f9b\u5e94\u5546\u6570\u636e\u5199\u5165SAP")
    @RequestMapping(value={"service/sendSupDataToSap"})
    @ResponseBody
    public ResponseResult<String> sendSupDataToSap(@RequestBody CompanySupplierApply data) {
        if (null == data) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String purCompanyId = ProjectUtils.getProject().getCompanyId();
        this.companySupplierApplyService.writeToSap(data, purCompanyId);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4fee\u6539\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u5355\u636e")
    @RequestMapping(value={"service/modifyData"})
    @ResponseBody
    public ResponseResult<String> modifyData(@RequestBody CompanySupplierApply data) {
        if (null == data) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)data.getSupCompanyId())) {
            throw new CommonException("\u4f20\u9012\u7684\u4f9b\u5e94\u5546id\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        data.setOperateStatus(Constant.NO_INT);
        String purCompanyId = ProjectUtils.getProject().getCompanyId();
        this.companySupplierApplyService.modifyData(data, purCompanyId);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u751f\u6210\u5355\u636e\u4fe1\u606f")
    @RequestMapping(value={"service/generateBillInfo"})
    @ResponseBody
    public ResponseResult<CompanySupplierApply> generateBillInfo(@RequestBody Company company) {
        CompanySupplierApply data = this.companySupplierApplyService.generateBillInfo(company);
        data.setProjectId(ProjectUtils.getProjectId());
        User user = SpringSecurityUtils.getLoginUser();
        data.setCreateBillUserName(user.getNickName());
        data.setProposer(user.getNickName());
        return ResponseResult.success(data);
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody List<String> ids) {
        this.companySupplierApplyService.deleteByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u9001\u5ba1\u6279")
    @RequestMapping(value={"service/sendToApprove"})
    @ResponseBody
    public ResponseResult<String> sendToApprove(@RequestBody List<String> ids) {
        this.companySupplierApplyService.sendToApprove(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7\u8868\u5355\u636e\u8be6\u60c5")
    @RequestMapping(value={"service/findDetailById"})
    @ResponseBody
    public ResponseResult<CompanySupplierApply> findDetailById(@RequestParam(required=true) String id) {
        if (StringUtils.isEmpty((String)id)) {
            throw new CommonException("\u4f20\u9012\u7684id\u4e3a\u7a7a!");
        }
        CompanySupplierApply data = (CompanySupplierApply)this.companySupplierApplyService.queryObjById(id);
        if (null == data) {
            throw new CommonException("\u6839\u636eid\u67e5\u627e\u7684\u5355\u636e\u4e0d\u5b58\u5728!");
        }
        this.companySupplierApplyService.setProductTypeJsonData(data);
        return ResponseResult.success(data);
    }

    @ApiOperation(httpMethod="POST", value="\u6dfb\u52a0\u5907\u6ce8")
    @RequestMapping(value={"service/addRemark"})
    @ResponseBody
    public ResponseResult<String> addRemark(@RequestBody CompanySupplierApply data) {
        this.companySupplierApplyService.addRemark(data);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanySupplierApply", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanySupplierApply>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PageView pageData;
        List list;
        CompanySupplierApplyExample example = new CompanySupplierApplyExample();
        example.setPageView(new PageView<CompanySupplierApply>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        CompanySupplierApplyExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        if (CollectionUtils.isNotEmpty(list = (pageData = this.companySupplierApplyService.queryObjByPage(example)).getQueryResult())) {
            for (CompanySupplierApply data : list) {
                this.companySupplierApplyService.setProductTypeJsonData(data);
            }
            pageData.setQueryResult(list);
        }
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u65b0\u4f9b\u5e94\u5546\u7f16\u7801\u7533\u8bf7\u8868\u6253\u5370")
    @RequestMapping(value={"service/print"})
    @ResponseBody
    public ResponseResult<FileData> print(@RequestBody(required=true) List<CompanySupplierApply> data) {
        FileData fileData = this.companySupplierApplyService.print(ProjectUtils.getProjectId(), CompanyUtils.currentCompany().getId(), data);
        return ResponseResult.success(fileData);
    }
}

