/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.relation.service.impl;

import com.els.base.certification.relation.dao.CompanySupplyRelationMapper;
import com.els.base.certification.relation.entity.CompanySupplyRelation;
import com.els.base.certification.relation.entity.CompanySupplyRelationExample;
import com.els.base.certification.relation.service.CompanySupplyRelationService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyExecutionEnum;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanySupplyRelationService")
public class CompanySupplyRelationServiceImpl
implements CompanySupplyRelationService {
    @Resource
    protected CompanyService companyService;
    @Resource
    private CompanySupplyRelationMapper companySupplyRelationMapper;

    @Override
    @Cacheable(value={"companySupplyRelation"}, keyGenerator="redisKeyGenerator")
    public Integer isFinish(Project project, Company company) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);
        CompanySupplyRelationExample companySupplyRelationExample = new CompanySupplyRelationExample();
        companySupplyRelationExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        int count = this.companySupplyRelationMapper.countByExample(companySupplyRelationExample);
        if (count <= 0) {
            return 0;
        }
        companySupplyRelationExample.clear();
        companySupplyRelationExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT).andFinishFlagIn(list);
        int finishCount = this.companySupplyRelationMapper.countByExample(companySupplyRelationExample);
        if (finishCount > 0) {
            return 0;
        }
        return 1;
    }

    @Override
    @CacheEvict(value={"companySupplyRelation"}, allEntries=true)
    @Transactional
    public Integer batchInsert(String projectId, Company company, List<CompanySupplyRelation> companySupplyRelationList) {
        if (CollectionUtils.isEmpty(companySupplyRelationList)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        CompanySupplyRelationExample companySupplyRelationExample = new CompanySupplyRelationExample();
        companySupplyRelationExample.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        CompanySupplyRelation companySupplyRelation = new CompanySupplyRelation();
        companySupplyRelation.setIsEnable(Constant.NO_INT);
        this.companySupplyRelationMapper.updateByExampleSelective(companySupplyRelation, companySupplyRelationExample);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (CompanySupplyRelation supplyRelation : companySupplyRelationList) {
            supplyRelation.setId(null);
            supplyRelation.setProjectId(projectId);
            supplyRelation.setSupCompanyId(company.getId());
            supplyRelation.setIsEnable(Constant.YES_INT);
            supplyRelation.setCreateTime(new Date());
            supplyRelation.setUpdateTime(new Date());
            Integer finishFlag = supplyRelation.getFinishFlag();
            supplyRelation.setFinishFlag(finishFlag);
            this.companySupplyRelationMapper.insertSelective(supplyRelation);
            list.add(finishFlag);
        }
        Company supCompany = (Company)this.companyService.queryObjById(company.getId());
        if (null == supCompany) {
            throw new CommonException("\u67e5\u8be2\u4e0d\u5230\u4f9b\u5e94\u5546\u6570\u636e");
        }
        if (CompanyExecutionEnum.STATUS_SUBMIT.getStatus().equals(supCompany.getExecution())) {
            this.companyService.modifyCompanyExecution(company.getId());
        }
        if (list.contains(Constant.NO_INT)) {
            return 0;
        }
        return 1;
    }

    @Override
    @CacheEvict(value={"companySupplyRelation"}, allEntries=true)
    @Transactional
    public void deleteObjByIds(String projectId, Company company, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        CompanySupplyRelationExample companySupplyRelationExample = new CompanySupplyRelationExample();
        companySupplyRelationExample.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT).andIdIn((List)ids);
        CompanySupplyRelation companySupplyRelation = new CompanySupplyRelation();
        companySupplyRelation.setIsEnable(Constant.NO_INT);
        this.companySupplyRelationMapper.updateByExampleSelective(companySupplyRelation, companySupplyRelationExample);
    }

    @Override
    @CacheEvict(value={"companySupplyRelation"}, allEntries=true)
    public void addObj(CompanySupplyRelation t) {
        this.companySupplyRelationMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"companySupplyRelation"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companySupplyRelationMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"companySupplyRelation"}, allEntries=true)
    public void modifyObj(CompanySupplyRelation t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companySupplyRelationMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"companySupplyRelation"}, keyGenerator="redisKeyGenerator")
    public CompanySupplyRelation queryObjById(String id) {
        return this.companySupplyRelationMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"companySupplyRelation"}, keyGenerator="redisKeyGenerator")
    public List<CompanySupplyRelation> queryAllObjByExample(CompanySupplyRelationExample example) {
        return this.companySupplyRelationMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"companySupplyRelation"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanySupplyRelation> queryObjByPage(CompanySupplyRelationExample example) {
        PageView<CompanySupplyRelation> pageView = example.getPageView();
        pageView.setQueryResult(this.companySupplyRelationMapper.selectByExampleByPage(example));
        return pageView;
    }
}

