/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.contrast.service.impl;

import com.els.base.certification.contrast.dao.CompanyContrastItemMapper;
import com.els.base.certification.contrast.entity.CompanyContrastItem;
import com.els.base.certification.contrast.entity.CompanyContrastItemExample;
import com.els.base.certification.contrast.service.CompanyContrastItemService;
import com.els.base.core.entity.PageView;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultCompanyContrastItemService")
public class CompanyContrastItemServiceImpl
implements CompanyContrastItemService {
    @Resource
    protected CompanyContrastItemMapper companyContrastItemMapper;

    @Override
    @CacheEvict(value={"companyContrastItem"}, allEntries=true)
    public void addObj(CompanyContrastItem t) {
        this.companyContrastItemMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"companyContrastItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyContrastItemMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"companyContrastItem"}, allEntries=true)
    public void modifyObj(CompanyContrastItem t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyContrastItemMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"companyContrastItem"}, keyGenerator="redisKeyGenerator")
    public CompanyContrastItem queryObjById(String id) {
        return this.companyContrastItemMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"companyContrastItem"}, keyGenerator="redisKeyGenerator")
    public List<CompanyContrastItem> queryAllObjByExample(CompanyContrastItemExample example) {
        return this.companyContrastItemMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"companyContrastItem"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyContrastItem> queryObjByPage(CompanyContrastItemExample example) {
        PageView<CompanyContrastItem> pageView = example.getPageView();
        pageView.setQueryResult(this.companyContrastItemMapper.selectByExampleByPage(example));
        return pageView;
    }
}

