/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.contrast.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.contrast.entity.CompanyContrast;
import com.els.base.certification.contrast.entity.CompanyContrastExample;
import com.els.base.certification.contrast.entity.CompanyContrastItem;
import com.els.base.certification.contrast.entity.CompanyContrastItemExample;
import com.els.base.certification.contrast.service.CompanyContrastItemService;
import com.els.base.certification.contrast.service.CompanyContrastService;
import com.els.base.certification.contrast.utils.CompanyContrastApproveEnum;
import com.els.base.certification.contrast.vo.CompanyContrastVO;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.utils.uuid.UUIDGenerator;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6f5c\u5728\u4f9b\u5e94\u5546\u5bf9\u6bd4\u8868")
@Controller
@RequestMapping(value={"companyContrast"})
public class CompanyContrastController {
    private static final Logger logger = LoggerFactory.getLogger(CompanyContrastController.class);
    @Resource
    private CompanyContrastService companyContrastService;
    @Resource
    private CompanyContrastItemService companyContrastItemService;
    @Resource
    private GenerateCodeService generateCodeService;
    @Resource
    private CompanyService companyService;
    private static final String SUPPLIER_CONTRAST_BILL_NO = "SUPPLIER_CONTRAST_BILL_NO";

    @ApiOperation(httpMethod="POST", value="\u751f\u6210\u4f9b\u5e94\u5546\u5bf9\u6bd4\u5355\u636e\u4fe1\u606f")
    @RequestMapping(value={"service/generateCompanyContrastInfo"})
    @ResponseBody
    public ResponseResult<CompanyContrastVO> generateCompanyContrastInfo(@RequestBody List<Company> companyList, String materialType) {
        if (CollectionUtils.isEmpty(companyList)) {
            throw new CommonException("\u63d0\u4ea4\u7684\u4fe1\u606f\u4e3a\u7a7a!");
        }
        if (companyList.size() > 3) {
            throw new CommonException("\u5bf9\u6bd4\u7684\u4f9b\u5e94\u5546\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e3\u4e2a!");
        }
        if (companyList.size() < 2) {
            throw new CommonException("\u5bf9\u6bd4\u7684\u4f9b\u5e94\u5546\u6570\u91cf\u4e0d\u80fd\u5c11\u4e8e2\u4e2a!");
        }
        if (StringUtils.isEmpty((String)materialType)) {
            throw new CommonException("\u4f20\u9012\u7684\u5b9a\u5236\u4ef6\u8fd8\u662f\u6807\u51c6\u4ef6\u7684\u53c2\u6570\u4e3a\u7a7a!");
        }
        ArrayList<CompanyContrastItem> list = new ArrayList<CompanyContrastItem>();
        for (Company company : companyList) {
            if (StringUtils.isEmpty((String)company.getId())) {
                throw new CommonException("\u4f20\u9012\u7684\u53c2\u6570\u4e2d\u7684\u4f9b\u5e94\u5546id\u4e3a\u7a7a!");
            }
            CompanyContrastItem item = this.companyContrastService.generateCompanyContrastInfo(company.getId(), materialType);
            list.add(item);
        }
        CompanyContrastVO vo = new CompanyContrastVO();
        vo.setCompanyContrastItemList(list);
        vo.setMaterialType(materialType);
        this.completeData(vo);
        return ResponseResult.success(vo);
    }

    private void completeData(CompanyContrastVO vo) {
        Company purCompany = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        String projectId = ProjectUtils.getProjectId();
        String id = UUIDGenerator.generateUUID();
        vo.setId(id);
        vo.setProjectId(projectId);
        vo.setPurCompanyId(purCompany.getId());
        vo.setPurCompanySrmCode(purCompany.getCompanyCode());
        vo.setPurCompanyName(purCompany.getCompanyFullName());
        vo.setPurCompanyShortName(purCompany.getCompanyName());
        String billNo = this.generateCodeService.getNextCode(SUPPLIER_CONTRAST_BILL_NO);
        vo.setContrastBillNo(billNo);
        vo.setCreateBillUserName(user.getNickName());
        vo.setCreateBillTime(new Date());
        vo.setApproveStatus(CompanyContrastApproveEnum.STATUS_UN_APPROVE.getStatus());
        vo.setConfirmStatus(0);
        vo.setIsEnable(Constant.YES_INT);
        vo.setCreateTime(new Date());
        this.completeItemData(vo);
    }

    private void completeItemData(CompanyContrastVO vo) {
        List<CompanyContrastItem> itemList = vo.getCompanyContrastItemList();
        for (int i = 1; i <= itemList.size(); ++i) {
            CompanyContrastItem item = itemList.get(i - 1);
            if (i == 1) {
                vo.setFirstSupCompanyId(item.getSupCompanyId());
                vo.setFirstSupCompanySrmCode(item.getSupCompanySrmCode());
                vo.setFirstSupCompanyName(item.getSupCompanyName());
                vo.setFirstSupCompanyShortName(item.getSupCompanyShortName());
            }
            if (i == 2) {
                vo.setSecondSupCompanyId(item.getSupCompanyId());
                vo.setSecondSupCompanySrmCode(item.getSupCompanySrmCode());
                vo.setSecondSupCompanyName(item.getSupCompanyName());
                vo.setSecondSupCompanyShortName(item.getSupCompanyShortName());
            }
            if (i == 3) {
                vo.setThirdSupCompanyId(item.getSupCompanyId());
                vo.setThirdSupCompanySrmCode(item.getSupCompanySrmCode());
                vo.setThirdSupCompanyName(item.getSupCompanyName());
                vo.setThirdSupCompanyShortName(item.getSupCompanyShortName());
            }
            item.setProjectId(vo.getProjectId());
            item.setContrastBillNo(vo.getContrastBillNo());
            item.setCompanyContrastId(vo.getId());
        }
    }

    @ApiOperation(httpMethod="POST", value="\u4fdd\u5b58\u5bf9\u6bd4\u8868\u4fe1\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyContrastVO vo) {
        if (CollectionUtils.isEmpty(vo.getCompanyContrastItemList())) {
            throw new CommonException("\u5355\u636e\u884c\u4fe1\u606f\u4e3a\u7a7a,\u4fdd\u5b58\u5931\u8d25");
        }
        this.companyContrastService.create(vo);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u6f5c\u5728\u4f9b\u5e94\u5546\u5bf9\u6bd4\u8868\u6570\u636e")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody List<String> ids) {
        logger.debug("\u3010\u5220\u9664\u6570\u636e\u3011\u4f20\u9012\u7684ids\u4e3a{}", ids);
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.companyContrastService.deleteByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6253\u5370\u5bf9\u6bd4\u8868\u6570\u636e")
    @RequestMapping(value={"service/print"})
    @ResponseBody
    public ResponseResult<FileData> print(@RequestBody List<CompanyContrast> data) {
        FileData fileData = this.companyContrastService.print(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), data);
        return ResponseResult.success(fileData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f5c\u5e9f\u6f5c\u5728\u4f9b\u5e94\u5546\u5bf9\u6bd4\u8868\u6570\u636e")
    @RequestMapping(value={"service/abolishByIds"})
    @ResponseBody
    public ResponseResult<String> abolishByIds(@RequestBody List<String> ids) {
        logger.debug("\u3010\u4f5c\u5e9f\u6570\u636e\u3011\u4f20\u9012\u7684ids\u4e3a{}", ids);
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.companyContrastService.abolishByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u9001\u5ba1\u6279")
    @RequestMapping(value={"service/sendDataToApprove"})
    @ResponseBody
    public ResponseResult<String> sendDataToApprove(@RequestBody List<String> ids) {
        logger.debug("\u3010\u53d1\u9001\u5ba1\u6279\u3011\u4f20\u9012\u7684ids\u4e3a{}", ids);
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.companyContrastService.sendDataToApprove(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4fee\u6539\u6570\u636e\uff1a\u4ec5\u4fee\u6539\u7269\u6599\u7f16\u7801,\u63cf\u8ff0,\u5907\u6ce8,\u5efa\u8bae\u7684\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/modifyData"})
    @ResponseBody
    public ResponseResult<String> modifyData(@RequestBody CompanyContrast companyContrast) {
        this.companyContrastService.modifyData(companyContrast);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636eid\u67e5\u8be2\u5bf9\u6bd4\u8868\u8be6\u60c5")
    @RequestMapping(value={"service/findDetailById"})
    @ResponseBody
    public ResponseResult<CompanyContrastVO> findDetailById(@RequestParam(required=true) String id) {
        if (StringUtils.isEmpty((String)id)) {
            throw new CommonException("\u4f20\u9012\u7684id\u4e3a\u7a7a!");
        }
        CompanyContrast data = (CompanyContrast)this.companyContrastService.queryObjById(id);
        if (null == data) {
            throw new CommonException("\u6839\u636eid\u67e5\u627e\u7684\u5355\u636e\u4e0d\u5b58\u5728!");
        }
        CompanyContrastVO vo = new CompanyContrastVO();
        BeanUtils.copyProperties((Object)data, (Object)vo);
        CompanyContrastItemExample example = new CompanyContrastItemExample();
        example.createCriteria().andCompanyContrastIdEqualTo(id);
        List<CompanyContrastItem> list = this.companyContrastItemService.queryAllObjByExample(example);
        vo.setCompanyContrastItemList(list);
        return ResponseResult.success(vo);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6f5c\u5728\u4f9b\u5e94\u5546\u5bf9\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyContrast", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyContrast>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam String companyShortName, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyContrastExample example = new CompanyContrastExample();
        example.setPageView(new PageView<CompanyContrast>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        CompanyContrastExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotEmpty((String)companyShortName)) {
            criteria.andIsEnableEqualTo(Constant.YES_INT).andFirstSupCompanyShortNameLike("%" + companyShortName + "%");
            if (wapper != null) {
                CriteriaUtils.addCriterion(criteria, wapper);
            }
            CompanyContrastExample.Criteria criteria1 = example.or();
            criteria1.andIsEnableEqualTo(Constant.YES_INT).andSecondSupCompanyShortNameLike("%" + companyShortName + "%");
            if (wapper != null) {
                CriteriaUtils.addCriterion(criteria1, wapper);
            }
            CompanyContrastExample.Criteria criteria2 = example.or();
            criteria2.andIsEnableEqualTo(Constant.YES_INT).andThirdSupCompanyShortNameLike("%" + companyShortName + "%");
            if (wapper != null) {
                CriteriaUtils.addCriterion(criteria2, wapper);
            }
        } else {
            criteria.andIsEnableEqualTo(Constant.YES_INT);
            if (wapper != null) {
                CriteriaUtils.addCriterion(criteria, wapper);
            }
        }
        PageView pageData = this.companyContrastService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}

