
CREATE TABLE T_BASE_COMPANY_CONTRAST (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_SHORT_NAME" VARCHAR2(255 BYTE) NULL ,
"CONTRAST_BILL_NO" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_CODE" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_TYPE" VARCHAR2(255 BYTE) NULL ,
"MATERIAL_DESC" VARCHAR2(255 BYTE) NULL ,
"CREATE_BILL_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"CREATE_BILL_TIME" DATE DEFAULT SYSDATE  NULL ,
"SUGGESTED_SUPPLIER" VARCHAR2(255 BYTE) NULL ,
"APPROVE_SUGGESTION" VARCHAR2(1000 BYTE) NULL ,
"FIRST_SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"FIRST_SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"FIRST_SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"FIRST_SUP_COMPANY_SHORT_NAME" VARCHAR2(255 BYTE) NULL ,
"SECOND_SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SECOND_SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SECOND_SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SECOND_SUP_COMPANY_SHORT_NAME" VARCHAR2(255 BYTE) NULL ,
"THIRD_SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"THIRD_SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"THIRD_SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"THIRD_SUP_COMPANY_SHORT_NAME" VARCHAR2(255 BYTE) NULL ,
"APPROVE_USER_NAME" VARCHAR2(255 BYTE) NULL ,
"APPROVE_TIME" DATE NULL ,
"APPROVE_STATUS" NUMBER(7) DEFAULT 1  NULL ,
"CONFIRM_STATUS" NUMBER(7) DEFAULT 0  NULL ,
"IS_ENABLE" NUMBER(7) DEFAULT 1  NULL ,
"REMARK" VARCHAR2(1000 BYTE) NULL ,
"CREATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"UPDATE_TIME" DATE NULL 
)
;
COMMENT ON TABLE T_BASE_COMPANY_CONTRAST IS '潜在供应商对比表';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."ID" IS '主键';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."PUR_COMPANY_ID" IS '采购商id';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."PUR_COMPANY_NAME" IS '采购商全称';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."PUR_COMPANY_SHORT_NAME" IS '采购商简称';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."CONTRAST_BILL_NO" IS '单据号';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."MATERIAL_CODE" IS '物料编码';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."MATERIAL_TYPE" IS '物料类型';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."MATERIAL_DESC" IS '物料描述';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."CREATE_BILL_USER_NAME" IS '制单人';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."CREATE_BILL_TIME" IS '制单时间';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."SUGGESTED_SUPPLIER" IS '建议引入的供应商';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."APPROVE_SUGGESTION" IS '审批意见';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."FIRST_SUP_COMPANY_ID" IS '供应商1的id';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."FIRST_SUP_COMPANY_SRM_CODE" IS '供应商1的SRM编码';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."FIRST_SUP_COMPANY_NAME" IS '供应商1的全称';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."FIRST_SUP_COMPANY_SHORT_NAME" IS '供应商1的简称';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."SECOND_SUP_COMPANY_ID" IS '供应商2的id';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."SECOND_SUP_COMPANY_SRM_CODE" IS '供应商2的SRM编码';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."SECOND_SUP_COMPANY_NAME" IS '供应商2的全称';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."SECOND_SUP_COMPANY_SHORT_NAME" IS '供应商2的简称';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."THIRD_SUP_COMPANY_ID" IS '供应商3的id';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."THIRD_SUP_COMPANY_SRM_CODE" IS '供应商3的SRM编码';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."THIRD_SUP_COMPANY_NAME" IS '供应商3的全称';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."THIRD_SUP_COMPANY_SHORT_NAME" IS '供应商3的简称';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."APPROVE_USER_NAME" IS '审批人';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."APPROVE_TIME" IS '审批时间';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."APPROVE_STATUS" IS '审批状态（1=未审核,2=正在审核,3=审核通过,4=驳回）';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."CONFIRM_STATUS" IS '确认状态(未确认=0，已确认=1,已拒绝=2，已作废=3)';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."REMARK" IS '备注';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN T_BASE_COMPANY_CONTRAST."UPDATE_TIME" IS '修改时间';


ALTER TABLE T_BASE_COMPANY_CONTRAST ADD CHECK ("ID" IS NOT NULL);

ALTER TABLE T_BASE_COMPANY_CONTRAST ADD PRIMARY KEY ("ID");
