CREATE TABLE T_BASE_COMPANY_PRODUCT_DEVICE (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"DEVICE_NAME" VARCHAR2(255 BYTE) NULL ,
"ORIGIN" VARCHAR2(255 BYTE) NULL ,
"PRODUCER" VARCHAR2(255 BYTE) NULL ,
"DESCRIPTION" VARCHAR2(255 BYTE) NULL ,
"DEVICE_PRODUCE_TIME" DATE NULL,
"QUANTITY" NUMBER(20,2) DEFAULT 0 NULL,
"PURCHASE_PLAN" VARCHAR2(255 BYTE) NULL ,
"IS_ENABLE" NUMBER(7,0) DEFAULT 1 NULL,
"FINISH_FLAG" NUMBER(7,0) DEFAULT 0 NULL,
"CREATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"UPDATE_TIME" DATE NULL 
)
;

COMMENT ON TABLE T_BASE_COMPANY_PRODUCT_DEVICE IS '供应商准入-关键生产设备';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_DEVICE."ID" IS '主键';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_DEVICE."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_DEVICE."PUR_COMPANY_ID" IS '采购商公司ID';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_DEVICE."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_DEVICE."PUR_COMPANY_NAME" IS '采购商名称';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_DEVICE."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_DEVICE."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_DEVICE."SUP_COMPANY_NAME" IS '供应商名称';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_DEVICE."DEVICE_NAME" IS '设备名称/型号';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_DEVICE."ORIGIN" IS '产地';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_DEVICE."PRODUCER" IS '生产商';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_DEVICE."DESCRIPTION" IS '技术指标或优势简述';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_DEVICE."DEVICE_PRODUCE_TIME" IS '设备生产时间';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_DEVICE."QUANTITY" IS '数量';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_DEVICE."PURCHASE_PLAN" IS '同级设备购买计划';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_DEVICE."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_DEVICE."FINISH_FLAG" IS '完成标识符(0=未完成，1=已完成)';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_DEVICE."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN T_BASE_COMPANY_PRODUCT_DEVICE."UPDATE_TIME" IS '修改时间';


ALTER TABLE T_BASE_COMPANY_PRODUCT_DEVICE ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE T_BASE_COMPANY_PRODUCT_DEVICE ADD PRIMARY KEY ("ID");
