/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.cognize.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.cognize.entity.CompanyProductCognize;
import com.els.base.certification.cognize.entity.CompanyProductCognizeExample;
import com.els.base.certification.cognize.service.CompanyProductCognizeService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f9b\u5e94\u5546\u4ea7\u54c1\u5927\u7c7b\u8ba4\u5b9a\u8868")
@Controller
@RequestMapping(value={"companyProductCognize"})
public class CompanyProductCognizeController {
    @Resource
    protected CompanyProductCognizeService companyProductCognizeService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u4ea7\u54c1\u5927\u7c7b\u8ba4\u5b9a\u8868\u5355\u636e")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyProductCognize data) {
        if (null == data) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)data.getSupCompanyId())) {
            throw new CommonException("\u4f20\u9012\u7684\u4f9b\u5e94\u5546id\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        data.setOperateStatus(Constant.YES_INT);
        String purCompanyId = ProjectUtils.getProject().getCompanyId();
        this.companyProductCognizeService.create(data, purCompanyId);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4fee\u6539\u4f9b\u5e94\u5546\u4ea7\u54c1\u5927\u7c7b\u8ba4\u5b9a\u8868\u5355\u636e")
    @RequestMapping(value={"service/modifyData"})
    @ResponseBody
    public ResponseResult<String> modifyData(@RequestBody CompanyProductCognize data) {
        if (null == data) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)data.getSupCompanyId())) {
            throw new CommonException("\u4f20\u9012\u7684\u4f9b\u5e94\u5546id\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e!");
        }
        data.setOperateStatus(Constant.NO_INT);
        String purCompanyId = ProjectUtils.getProject().getCompanyId();
        this.companyProductCognizeService.modifyData(data, purCompanyId);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u751f\u6210\u5355\u636e\u4fe1\u606f")
    @RequestMapping(value={"service/generateBillInfo"})
    @ResponseBody
    public ResponseResult<CompanyProductCognize> generateBillInfo(@RequestBody Company company) {
        CompanyProductCognize data = this.companyProductCognizeService.generateBillInfo(company);
        data.setProjectId(ProjectUtils.getProjectId());
        User user = SpringSecurityUtils.getLoginUser();
        data.setCreateBillUserName(user.getNickName());
        data.setProposer(user.getNickName());
        return ResponseResult.success(data);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u4f9b\u5e94\u5546\u4ea7\u54c1\u5927\u7c7b\u8ba4\u5b9a\u8868\u5355\u636e\u8be6\u60c5")
    @RequestMapping(value={"service/findDetailById"})
    @ResponseBody
    public ResponseResult<CompanyProductCognize> findDetailById(@RequestParam(required=true) String id) {
        if (StringUtils.isEmpty((String)id)) {
            throw new CommonException("\u4f20\u9012\u7684id\u4e3a\u7a7a!");
        }
        CompanyProductCognize data = (CompanyProductCognize)this.companyProductCognizeService.queryObjById(id);
        if (null == data) {
            throw new CommonException("\u6839\u636eid\u67e5\u627e\u7684\u5355\u636e\u4e0d\u5b58\u5728!");
        }
        this.companyProductCognizeService.setProductTypeJsonData(data);
        return ResponseResult.success(data);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u4ea7\u54c1\u5927\u7c7b\u8ba4\u5b9a\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyProductCognize", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyProductCognize>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PageView pageData;
        List list;
        CompanyProductCognizeExample example = new CompanyProductCognizeExample();
        example.setPageView(new PageView<CompanyProductCognize>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        CompanyProductCognizeExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        if (CollectionUtils.isNotEmpty(list = (pageData = this.companyProductCognizeService.queryObjByPage(example)).getQueryResult())) {
            for (CompanyProductCognize data : list) {
                this.companyProductCognizeService.setProductTypeJsonData(data);
            }
            pageData.setQueryResult(list);
        }
        return ResponseResult.success(pageData);
    }
}

