/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.log.service.impl;

import com.els.base.certification.log.dao.CompanyStatusChangeLogMapper;
import com.els.base.certification.log.entity.CompanyStatusChangeLog;
import com.els.base.certification.log.entity.CompanyStatusChangeLogExample;
import com.els.base.certification.log.service.CompanyStatusChangeLogService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyStatusChangeLogService")
public class CompanyStatusChangeLogServiceImpl
implements CompanyStatusChangeLogService {
    @Resource
    protected CompanyStatusChangeLogMapper companyStatusChangeLogMapper;

    @Override
    @CacheEvict(value={"companyStatusChangeLog"}, allEntries=true)
    public void addObj(CompanyStatusChangeLog t) {
        this.companyStatusChangeLogMapper.insertSelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"companyStatusChangeLog"}, allEntries=true)
    public void addAll(List<CompanyStatusChangeLog> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.companyStatusChangeLogMapper.insertBatch(list);
    }

    @Override
    @CacheEvict(value={"companyStatusChangeLog"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyStatusChangeLogMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"companyStatusChangeLog"}, allEntries=true)
    public void deleteByExample(CompanyStatusChangeLogExample example) {
        Assert.isNotNull(example, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), "\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.companyStatusChangeLogMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"companyStatusChangeLog"}, allEntries=true)
    public void modifyObj(CompanyStatusChangeLog t) {
        Assert.isNotBlank(t.getId(), "id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.companyStatusChangeLogMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"companyStatusChangeLog"}, keyGenerator="redisKeyGenerator")
    public CompanyStatusChangeLog queryObjById(String id) {
        return this.companyStatusChangeLogMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"companyStatusChangeLog"}, keyGenerator="redisKeyGenerator")
    public List<CompanyStatusChangeLog> queryAllObjByExample(CompanyStatusChangeLogExample example) {
        return this.companyStatusChangeLogMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"companyStatusChangeLog"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyStatusChangeLog> queryObjByPage(CompanyStatusChangeLogExample example) {
        PageView<CompanyStatusChangeLog> pageView = example.getPageView();
        pageView.setQueryResult(this.companyStatusChangeLogMapper.selectByExampleByPage(example));
        return pageView;
    }
}

