/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.plugin.page;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.plugin.page.Dialect;
import com.els.base.core.plugin.page.MySQLDialect;
import com.els.base.core.plugin.page.OracleDialect;
import com.els.base.core.plugin.page.SqlServer2008Dialect;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class})})
public class PaginationInterceptor
implements Interceptor,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ObjectFactory DEFAULT_OBJECT_FACTORY = new DefaultObjectFactory();
    public static final ObjectWrapperFactory DEFAULT_OBJECT_WRAPPER_FACTORY = new DefaultObjectWrapperFactory();
    public static final ReflectorFactory DEFAULT_REFLECTOR_FACTORY = new DefaultReflectorFactory();
    private static Logger logger = LoggerFactory.getLogger(PaginationInterceptor.class);
    private static String DEFAULT_PAGE_SQL_ID = ".*Page$";
    private static Dialect dialect;
    private static String pageSqlId;

    public Object intercept(Invocation inv) throws Throwable {
        Object object;
        if (dialect == null) {
            dialect = this.getDialect(inv);
        }
        MetaObject metaStatementHandler = MetaObject.forObject((Object)inv.getTarget(), (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
        while (metaStatementHandler.hasGetter("h")) {
            object = metaStatementHandler.getValue("h");
            metaStatementHandler = MetaObject.forObject((Object)object, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
        }
        while (metaStatementHandler.hasGetter("target")) {
            object = metaStatementHandler.getValue("target");
            metaStatementHandler = MetaObject.forObject((Object)object, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
        }
        MappedStatement mappedStatement = (MappedStatement)metaStatementHandler.getValue("delegate.mappedStatement");
        if (mappedStatement.getId().matches(pageSqlId)) {
            BoundSql boundSql = (BoundSql)metaStatementHandler.getValue("delegate.boundSql");
            Object paramObj = boundSql.getParameterObject();
            if (paramObj == null) {
                return inv.proceed();
            }
            PageView pageView = null;
            if (paramObj instanceof PageView) {
                pageView = (PageView)paramObj;
            } else if (paramObj instanceof Map) {
                for (Map.Entry entry : ((Map)paramObj).entrySet()) {
                    if (entry.getValue() instanceof IExample) {
                        MetaObject paramObjProxy = MetaObject.forObject(entry.getValue(), (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
                        pageView = (PageView)paramObjProxy.getValue("pageView");
                    } else {
                        if (!(entry.getValue() instanceof PageView)) continue;
                        pageView = (PageView)entry.getValue();
                    }
                    break;
                }
            } else {
                MetaObject paramObjProxy = MetaObject.forObject((Object)paramObj, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
                pageView = (PageView)paramObjProxy.getValue("pageView");
            }
            if (pageView == null) {
                return inv.proceed();
            }
            String originalSql = boundSql.getSql();
            if (logger.isDebugEnabled()) {
                logger.debug("originalSql======>" + originalSql);
            }
            this.setRowCount(inv, mappedStatement, boundSql, paramObj, pageView);
            String pageSql = dialect.getPageSqlString(originalSql, pageView.getStartRowNo(), pageView.getPageSize());
            metaStatementHandler.setValue("delegate.boundSql.sql", (Object)pageSql);
            metaStatementHandler.setValue("delegate.rowBounds.offset", (Object)0);
            metaStatementHandler.setValue("delegate.rowBounds.limit", (Object)Integer.MAX_VALUE);
        }
        return inv.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    private Dialect getDialect(Invocation inv) throws SQLException {
        Connection connection = (Connection)inv.getArgs()[0];
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String databaseProductName = databaseMetaData.getDatabaseProductName().toLowerCase();
        Dialect dialect = null;
        if (databaseProductName.contains("mysql")) {
            dialect = new MySQLDialect();
        } else if (databaseProductName.contains("oracle")) {
            dialect = new OracleDialect();
        } else if (databaseProductName.contains("sqlserver")) {
            dialect = new SqlServer2008Dialect();
        } else {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u4e0e\u6570\u636e\u5e93\u5339\u914d\u7684\u5206\u9875\u8bed\u6cd5");
        }
        return dialect;
    }

    public void setProperties(Properties prop) {
        String dialectName = prop.getProperty("dialect");
        if (StringUtils.isBlank((String)dialectName)) {
            logger.warn("dialect property is not found!");
        } else {
            try {
                dialect = (Dialect)Class.forName(dialectName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(dialect + ", init fail!\n" + e);
            }
        }
        pageSqlId = prop.getProperty("pageSqlId");
        if (null == pageSqlId || "".equals(pageSqlId)) {
            logger.warn("Property pageSqlId is not setted, use default '.*Page$' ");
            pageSqlId = DEFAULT_PAGE_SQL_ID;
        }
    }

    private void setRowCount(Invocation invk, MappedStatement mappedStatement, BoundSql boundSql, Object paramObj, PageView<?> pageView) throws SQLException {
        Statement countStmt = null;
        ResultSet rs = null;
        String countSql = null;
        try {
            String sql = boundSql.getSql().trim();
            Connection connection = (Connection)invk.getArgs()[0];
            countSql = "select count(1) from (" + sql + ") tmp_count";
            countStmt = connection.prepareStatement(countSql);
            MetaObject boundSqlPoxy = MetaObject.forObject((Object)boundSql, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
            boundSqlPoxy.setValue("sql", (Object)countSql);
            DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, paramObj, boundSql);
            parameterHandler.setParameters((PreparedStatement)countStmt);
            rs = countStmt.executeQuery();
            int count = 0;
            if (rs.next()) {
                count = ((Number)rs.getObject(1)).intValue();
            }
            pageView.setRowCount(count);
        }
        catch (Exception e) {
            logger.error("\u5206\u9875\u7ec4\u4ef6\u6267\u884c\u5f02\u5e38, \u7edf\u8ba1\u6570\u636e count sql \u5f02\u5e38:\n" + countSql, (Throwable)e);
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e1) {
                logger.error("ResultSet closed error:", (Throwable)e1);
            }
            try {
                if (countStmt != null) {
                    countStmt.close();
                }
            }
            catch (Exception e2) {
                logger.error("PreparedStatement closed error:", (Throwable)e2);
            }
            throw e;
        }
    }
}

