
CREATE TABLE "T_BASE_COMPANY_PATENTS" (
  "ID" VARCHAR2(32 BYTE) DEFAULT ''  NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) DEFAULT ''  NULL ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) DEFAULT ''  NULL ,
  "PATENT_CODE" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "PATENT_NAME" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "PATENT_ORGANIZATION" VARCHAR2(255 BYTE) DEFAULT ''  NULL ,
  "PATENT_DESC" VARCHAR2(1000 BYTE) DEFAULT ''  NULL ,
  "START_TIME" DATE NULL ,
  "END_TIME" DATE NULL ,
  "PATENT_VALUE" VARCHAR2(1000 BYTE) NULL ,
  "REMARK" VARCHAR2(1000 BYTE) DEFAULT ''  NULL ,
  "PATENT_FILE" VARCHAR2(1000 BYTE) NULL ,
  "FINISH_FLAG" NUMBER(7) DEFAULT 0  NULL ,
  "IS_ENABLE" NUMBER(7) DEFAULT 1  NULL ,
  "CREATE_TIME" DATE NULL ,
  "UPDATE_TIME" DATE NULL
);


COMMENT ON TABLE "T_BASE_COMPANY_PATENTS" IS '专利，专有技术，许可';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."PATENT_CODE" IS '专利代码';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."PATENT_NAME" IS '专利名称';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."PATENT_ORGANIZATION" IS '专利授予机构';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."PATENT_DESC" IS '专利使用的地方';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."START_TIME" IS '专利开始时间';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."END_TIME" IS '专利有效截止时间';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."PATENT_VALUE" IS '专利价值';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."PATENT_FILE" IS '专利文件';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."FINISH_FLAG" IS '完成标识符(0=未完成，1=已完成)';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_COMPANY_PATENTS"."UPDATE_TIME" IS '更新时间';


ALTER TABLE "T_BASE_COMPANY_PATENTS" ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE "T_BASE_COMPANY_PATENTS" ADD CHECK ("ID" IS NOT NULL);

ALTER TABLE "T_BASE_COMPANY_PATENTS" ADD PRIMARY KEY ("ID");
