package com.els.base.certification.agent.web.controller;

import com.els.base.certification.agent.entity.Agent;
import com.els.base.certification.agent.entity.AgentExample;
import com.els.base.certification.agent.service.AgentService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="供应商基础资料-代理数据")
@Controller
@RequestMapping("agent")
public class AgentController {
    @Resource
    protected AgentService agentService;

    @ApiOperation(httpMethod="POST", value="批量创建供应商基础资料-代理数据")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> batchCreate(@RequestBody List<Agent> agentList) {
    	Assert.isNotEmpty(agentList, "创建的数据为空，操作失败");
    	agentList.stream().forEach(agent ->{
    		Assert.isNotBlank(agent.getManufacturerIntroduce(), "制造商简介不能为空");
    		Assert.isNotBlank(agent.getManufacturerBusinessLicense(), "制造商营业执照不能为空");
    		Assert.isNotBlank(agent.getCertificateQuality(), "制造商质量证书不能为空");
    		Assert.isNotBlank(agent.getManufacturer3cCertificate(), "制造商3C证书不能为空");
    		Assert.isNotBlank(agent.getPerformanceData(), "制造商行业业绩资料不能为空");
    		Assert.isNotBlank(agent.getCreateDeviceList(), "生产设备清单不能为空");
    		Assert.isNotBlank(agent.getInspectionEquipmentList(), "检验设备清单不能为空");
    		Assert.isNotBlank(agent.getFinancialInformation(), "财务信息不能为空");
    		Assert.isNotBlank(agent.getTestQualificationReport(), "产品检测合格报告不能为空");
    	});
        this.agentService.batchInserts(ProjectUtils.getProjectId(),CompanyUtils.currentCompany(),agentList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑供应商基础资料-代理数据")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Agent agent) {
        Assert.isNotBlank(agent.getId(), "id 为空，保存失败");
        this.agentService.modifyObj(agent);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="批量删除供应商基础资料-代理数据")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "删除失败,id不能为空");
        AgentExample example = new AgentExample();
        example.createCriteria().andIdIn(ids)
        		.andIsEnableEqualTo(Constant.YES_INT)
        		.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        this.agentService.deleteByExample(example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询供应商基础资料-代理数据")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 Agent", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<Agent>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        AgentExample example = new AgentExample();
        example.setPageView(new PageView<Agent>(pageNo, pageSize));
        
//        AgentExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<Agent> pageData = this.agentService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod="POST", value="查询全部供应商基础资料-代理数据")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "companySrmCode",required = false,value = "供应商SRM编码",  dataType = "String"),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 Agent", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findAll")
    @ResponseBody
    public ResponseResult<List<Agent>> findAll( 
		@RequestParam(required=false) String companySrmCode, 
		@RequestBody(required=false) QueryParamWapper wapper) {
    	
    	AgentExample example = new AgentExample();
    	AgentExample.Criteria criteria = example.createCriteria();
    	if (StringUtils.isBlank(companySrmCode)) {
    		criteria.andIsEnableEqualTo(Constant.YES_INT)
    				.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
    	} else {
    		criteria.andIsEnableEqualTo(Constant.YES_INT)
    				.andCompanySrmCodeEqualTo(companySrmCode);
    	}
    	if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
    	List<Agent> list = this.agentService.queryAllObjByExample(example);
    	return ResponseResult.success(list);
    	
    }
}