package com.els.base.certification.apply.service;

import java.util.List;

import com.els.base.auth.entity.User;
import com.els.base.certification.apply.entity.Apply;
import com.els.base.certification.apply.entity.ApplyExample;
import com.els.base.core.service.BaseService;
import com.els.base.file.entity.FileData;

public interface ApplyService extends BaseService<Apply, ApplyExample, String> {
	/**
	 * 更改单据状态为审核通过
	 * @param apply
	 */
	public void updateStatus(String id);
	
	/**
	 * 更改单据是否作废
	 * @param apply
	 */
	public void updateIsInvalid(List<Apply> apply);
	
	/**
	 * 批量删除单据
	 * @param ids
	 */
	public void deleteObjByIds(List<Apply> supApply);
	
	/**
	 * 更改单据状态为已发送审批
	 * @param supIds
	 */
	public void sendToApprove(List<String> supIds);
	
	/**
	 * 创建潜在供应商转入申请
	 * @param user
	 * @param apply
	 */
	public void insert(User user, Apply apply);
	
	/**
	 * 潜在供应商导入分析表打印
	 * @param projectId
	 * @param currentCompanyId
	 * @param data
	 * @return
	 */
	public FileData print(String projectId, String companyId, List<Apply> data);
	
	/**
	 * 陌生供应商直接变更为潜在供应商
	 * @param ids
	 *//*
	public void changeToPotential(List<String> ids);*/
}