package com.els.base.certification.apply.service.impl;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.User;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.entity.UserRoleExample;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.certification.apply.dao.ApplyMapper;
import com.els.base.certification.apply.entity.Apply;
import com.els.base.certification.apply.entity.ApplyExample;
import com.els.base.certification.apply.service.ApplyService;
import com.els.base.certification.apply.util.ApplyUtils;
import com.els.base.certification.apply.util.DocumentStatusEnum;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyPartner;
import com.els.base.company.entity.CompanyPartnerExample;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultApplyService")
public class ApplyServiceImpl implements ApplyService,ITaskListener {
	@Resource
	protected ApplyMapper applyMapper;

	@Resource
	protected CompanyService companyService;

	@Resource
	protected GenerateCodeService generateCodeService;

	@Resource
	protected RoleService roleService;

	@Resource
	protected CompanyUserRefService companyUserRefService;

	@Resource
	protected UserRoleService userRoleService;
	
	@Resource
	protected WorkFlowService workFlowService;

	@Transactional
	@CacheEvict(value = { "apply" }, allEntries = true)
	@Override
	public void addObj(Apply t) {
		this.applyMapper.insertSelective(t);
	}
	
	@Transactional
	@CacheEvict(value = { "apply" }, allEntries = true)
	@Override
	public void insert(User user, Apply t) {
		List<String> list=new ArrayList<>();
		list.add(DocumentStatusEnum.NOT_AUDITED.getCode());
		list.add(DocumentStatusEnum.BEING_AUDITED.getCode());
		list.add(DocumentStatusEnum.AUDITED.getCode());
		ApplyExample example = new ApplyExample();
		ApplyExample.Criteria creiteria = example.createCriteria();
		creiteria.andSupCompanySrmCodeEqualTo(t.getSupCompanySrmCode())
				.andIsEnableEqualTo(Constant.YES_INT)
				.andStatusIn(list);
		if (this.applyMapper.countByExample(example) > 0) {
			throw new CommonException("此供应商编码已有未被驳回或未作废的单据,不能再添加供应商编码： " + t.getSupCompanySrmCode());
		}

		Company c = this.companyService.queryCompanyByCode(t.getSupCompanySrmCode());
		t.setId(null);
		t.setProjectId(c.getProjectId());
		t.setSupCompanyId(c.getId());
		t.setSupCompanyName(c.getCompanyFullName());
		t.setStatus(DocumentStatusEnum.NOT_AUDITED.getCode());
		t.setSinglePerson(user.getLoginName() + "+" + user.getNickName());
		t.setDocumentNumber(generateCodeService.getNextCode("POTENTIAL_SUPPLIERS_APPLY_NO"));
		this.applyMapper.insertSelective(t);
	}

	@Transactional
	@CacheEvict(value = { "apply" }, allEntries = true)
	@Override
	public void deleteObjByIds(List<Apply> supApply) {
		for (Apply apply : supApply) {
			if (apply.getIsInvalid() == Constant.YES_INT) {
				throw new CommonException("单据已作废，不能进行此操作");
			}
			if (StringUtils.isBlank(apply.getId())) {
				throw new CommonException("删除失败，id不能为空");
			}
			if (apply.getStatus().equals(DocumentStatusEnum.NOT_AUDITED.getCode())) {
				this.applyMapper.deleteByPrimaryKey(apply.getId());
			} else {
				throw new CommonException("单据已发送审批或已审批或已驳回，不能删除");
			}
		}
	}

	@Transactional
	@CacheEvict(value = { "apply" }, allEntries = true)
	@Override
	public void modifyObj(Apply t) {
		Assert.isNotBlank(t.getId(), "单据ID不能为空，编辑失败");
		Apply app=this.applyMapper.selectByPrimaryKey(t.getId());
		if(t.getSupCompanySrmCode().equals(app.getSupCompanySrmCode())){
			//供应商编码没有改变
			this.applyMapper.updateByPrimaryKeySelective(t);
		}else{
			//供应商编码改变了
			this.applyMapper.deleteByPrimaryKey(t.getId());
			List<String> list=new ArrayList<>();
			list.add(DocumentStatusEnum.NOT_AUDITED.getCode());
			list.add(DocumentStatusEnum.BEING_AUDITED.getCode());
			list.add(DocumentStatusEnum.AUDITED.getCode());
			String[] supCompanyCode = t.getSupCompanySrmCode().split(",");
			for(int i=0;i<supCompanyCode.length;i++){
				Assert.isNotBlank(supCompanyCode[i], "供应商编码不能为空");
				t.setSupCompanySrmCode(supCompanyCode[i]);
				ApplyExample example=new ApplyExample();
				example.createCriteria().andSupCompanySrmCodeEqualTo(t.getSupCompanySrmCode())
										.andIsEnableEqualTo(Constant.YES_INT)
										.andStatusIn(list);
				if(this.applyMapper.countByExample(example)>0){
					throw new CommonException("此供应商编码已有未被驳回或未作废的单据，不能再添加","base_is_exists",t.getSupCompanySrmCode());
				}
				example.clear();
				Company c = this.companyService.queryCompanyByCode(t.getSupCompanySrmCode());
				t.setId(null);
				t.setProjectId(c.getProjectId());
				t.setSupCompanyId(c.getId());
				t.setSupCompanyName(c.getCompanyFullName());
				t.setStatus(DocumentStatusEnum.NOT_AUDITED.getCode());
				t.setCreateTime(new Date());
				t.setDocumentNumber(generateCodeService.getNextCode("POTENTIAL_SUPPLIERS_APPLY_NO"));
				this.applyMapper.insertSelective(t);
			}
		}
	}
	
	@Transactional
	@CacheEvict(value = { "apply" }, allEntries = true)
	@Override
	public void updateIsInvalid(List<Apply> supApply) {
		for (Apply apply : supApply) {
			if (apply.getIsInvalid() == Constant.YES_INT) {
				throw new CommonException("单据已作废，不能在进行此操作");
			}
			if (StringUtils.isBlank(apply.getId())) {
				throw new CommonException("id 为空，操作失败");
			}
			if (apply.getStatus().equals(DocumentStatusEnum.BEING_AUDITED.getCode())) {
				apply.setIsInvalid(Constant.YES_INT);
				apply.setStatus(DocumentStatusEnum.INVALID.getCode());
				this.applyMapper.updateByPrimaryKeySelective(apply);
				this.workFlowService.stopProcess("qzgysdrfx", apply.getDocumentNumber());
			} else {
				throw new CommonException("你选的单据是新建或已审核或已驳回，不能作废");
			}
		}
	}

	@Cacheable(value = "apply", keyGenerator = "redisKeyGenerator")
	@Override
	public Apply queryObjById(String id) {
		return this.applyMapper.selectByPrimaryKey(id);
	}

	@Cacheable(value = "apply", keyGenerator = "redisKeyGenerator")
	@Override
	public List<Apply> queryAllObjByExample(ApplyExample example) {
		return this.applyMapper.selectByExample(example);
	}

	@Cacheable(value = "apply", keyGenerator = "redisKeyGenerator")
	@Override
	public PageView<Apply> queryObjByPage(ApplyExample example) {
		PageView<Apply> pageView = example.getPageView();
		pageView.setQueryResult(this.applyMapper.selectByExampleByPage(example));
		return pageView;
	}

	@Transactional
	@CacheEvict(value = { "apply" }, allEntries = true)
	@Override
	public void sendToApprove(List<String> ids) {
		// 单据状态改为发送审批
		List<String> list = new ArrayList<String>();
		list.add(DocumentStatusEnum.BEING_AUDITED.getCode());
		list.add(DocumentStatusEnum.AUDITED.getCode());
		list.add(DocumentStatusEnum.DISMISSAL.getCode());
		list.add(DocumentStatusEnum.INVALID.getCode());
		ApplyExample applyExample = new ApplyExample();
		applyExample.createCriteria().andIdIn(ids).andStatusIn(list);
		if (this.applyMapper.countByExample(applyExample) > 0) {
			throw new CommonException("你发送的单据包含已发送或已审核或已驳回或已作废，不能发送审批");
		}

		applyExample.clear();
		applyExample.createCriteria().andIdIn(ids);
		
		List<Apply> applyList=this.applyMapper.selectByExample(applyExample);
		Assert.isNotEmpty(applyList, "查询的数据为空");
		for(Apply apply : applyList){
			ProcessStartVO vo=ProcessStartVO.newInstance("qzgysdrfx", apply.getDocumentNumber(), apply.getId(),"potentialSupIntroduction?id="+apply.getId());
			vo.setListenerClass(this.getClass());
			ProcessInstance startProcess=this.workFlowService.startProcess(vo);
			if(startProcess!=null){
				//成功加入审批流
				Apply app = new Apply();
				app.setStatus(DocumentStatusEnum.BEING_AUDITED.getCode());
				app.setAuditTime(new Date());
				
				applyExample.clear();
				applyExample.createCriteria().andIdEqualTo(apply.getId());
				this.applyMapper.updateByExampleSelective(app, applyExample);
			}
		}

		/*// 调用审核通过方法
		for (String id : ids) {
			this.updateStatus(id);
		}*/
	}

	@Transactional
	@CacheEvict(value = { "apply" }, allEntries = true)
	@Override
	public void updateStatus(String id) {
		Assert.isNotBlank(id, "单据ID为空");
		// 更改单据状态为已审核
		/*if (!apply.getStatus().equals(DocumentStatusEnum.BEING_AUDITED.getCode())) {
			throw new CommonException("单据状态不是已发送审核，不能执行此操作");
		}
		apply.setStatus(DocumentStatusEnum.AUDITED.getCode());
		this.applyMapper.updateByPrimaryKeySelective(apply);*/
		Apply apply = this.applyMapper.selectByPrimaryKey(id);
		String companyId = apply.getSupCompanyId();
		// 将陌生供应商变为潜在供应商
		this.changeRole(companyId);
		
	}

	private void changeRole(String companyId) {
		CompanyPartnerExample example = new CompanyPartnerExample();
		example.createCriteria().andPartnerCompanyIdEqualTo(companyId);
		CompanyPartner companyPartner = new CompanyPartner();
		companyPartner.setPartnerRoleCode(PartnerRoleEnum.POTENIAL.getCode());
		companyPartner.setPartnerRoleName(PartnerRoleEnum.POTENIAL.getName());
		this.companyService.updatePartnerRole(companyPartner, example);
		// 变为潜在供应商后，分配潜在供应商的角色
		RoleExample roleExample = new RoleExample();
		roleExample.createCriteria().andRoleCodeEqualTo(PartnerRoleEnum.POTENIAL.getUserRoleCode());
		List<Role> list = roleService.queryAllObjByExample(roleExample);
		if (CollectionUtils.isNotEmpty(list)) {
			CompanyUserRefExample companyUserExample = new CompanyUserRefExample();
			companyUserExample.createCriteria().andCompanyIdEqualTo(companyId);
			List<CompanyUserRef> companyUserRef = this.companyUserRefService.queryAllObjByExample(companyUserExample);
			UserRoleExample userRoleExample = new UserRoleExample();
			userRoleExample.createCriteria().andUserIdEqualTo(companyUserRef.get(0).getUserId());
			List<UserRole> userRole = this.userRoleService.queryAllObjByExample(userRoleExample);
			for (UserRole ur : userRole) {
				for (Role role : list) {
					ur.setRoleId(role.getId());
					ur.setCreateTime(new Date());
					this.userRoleService.modifyObj(ur);
				}
			}
		}
	}

	@Transactional
	@CacheEvict(value = { "apply" }, allEntries = true)
	@Override
	public void deleteObjById(String id) {
		if (StringUtils.isBlank(id)) {
			throw new CommonException("删除失败，id不能为空");
		}
		this.applyMapper.deleteByPrimaryKey(id);
	}
	
	@Transactional
	@CacheEvict(value= { "apply" }, allEntries = true)
	@Override
	public void listen(TaskOperateEvent event) {
		Assert.isNotBlank(event.getBusinessId(), "供应商导入分析单据ID为空");
		ApplyExample applyExample = new ApplyExample();
		applyExample.createCriteria().andIdEqualTo(event.getBusinessId());
		Apply apply=this.applyMapper.selectByPrimaryKey(event.getBusinessId());
		if(StringUtils.isBlank(apply.getApprovalComments())){
			//如果审批意见为空，直接把审批意见、审批情况添加进去
			apply.setApproveSituation(event.getAssignee());
			if(StringUtils.isEmpty(event.getApproveDesc())){
				apply.setApprovalComments("无");
			}else{
				apply.setApprovalComments(event.getApproveDesc());
			}
		}else{
			//如果审批意见不为空，把审批意见、审批情况拼接添加
			apply.setApproveSituation(apply.getApproveSituation()+"\n"+event.getAssignee());
			if(StringUtils.isEmpty(event.getApproveDesc())){
				apply.setApprovalComments(apply.getApprovalComments()+"\n"+"无");
			}else{
				apply.setApprovalComments(apply.getApprovalComments()+"\n"+event.getApproveDesc());
			}
		}
		apply.setPendingApprovalPeople(event.getAssignee());
		if (event.isFinished() && event.isPass()) {
			//审批流完成而且通过
			apply.setStatus(DocumentStatusEnum.AUDITED.getCode());
			//审核通过修改供应商角色
			this.updateStatus(event.getBusinessId());
		}else if(event.isFinished() && !event.isPass()){
			//审批流完成但被驳回
			apply.setStatus(DocumentStatusEnum.DISMISSAL.getCode());
		}
		this.applyMapper.updateByExampleSelective(apply, applyExample);
	}
	
	@CacheEvict(value= { "apply" }, allEntries = true)
	@Override
	public FileData print(String projectId, String companyId, List<Apply> data) {
		Assert.isNotEmpty(data, "传输的数据为空，无法打印");
		//获取id
		List<String> ids=null;
		for(Apply a : data){
			Assert.isNotBlank(a.getId(), "传输的单据存在ID为空");
			if(ids==null){
				ids=new ArrayList<>();
			}
			ids.add(a.getId());
		}
		//根据ID查询数据
		ApplyExample example=new ApplyExample();
		example.createCriteria().andIdIn(ids);
		List<Apply> applyList=this.applyMapper.selectByExample(example);
		Assert.isNotEmpty(applyList, "根据ID查询的数据为空，无法打印");
		
		//创建打印数据
		Map<String,Object> params=new HashMap<String,Object>();
		params.put("applyList", applyList);
		//创建文件信息
		FileData fileData=null;
		try{
			fileData=ApplyUtils.generatePdf(projectId,companyId,params,"A4");
		}catch(Exception e){
			e.printStackTrace();
		}
		return fileData;
	}
	
	/*@Transactional
	@CacheEvict(value= { "apply" }, allEntries = true)
	@Override
	public void changeToPotential(List<String> ids) {
		Assert.isNotEmpty(ids, "传入的供应商ID为空");
		ids.forEach(id ->{
			this.changeRole(id);
		});
	}*/
}