package com.els.base.certification.auth.entity;

import com.els.base.certification.common.AbstractCompany;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ApiModel(value="企业通过的认证")
public class CompanyAuth extends AbstractCompany implements Serializable {

    //#######非自动生成########
    //忽略校验字段
    @Override
    protected List<String> exculdeFieldNames(){
        List<String> filedNameList = new ArrayList<>();
        filedNameList.add("id");
        filedNameList.add("certificateTypeName");
        filedNameList.add("certificateName");
        filedNameList.add("startTime");
        filedNameList.add("effectiveDate");
        filedNameList.add("projectId");
        filedNameList.add("supCompanyId");
        filedNameList.add("createTime");
        filedNameList.add("finishFlag");
        filedNameList.add("isEnable");
        filedNameList.add("updateTime");
        return filedNameList;
    }
    //#######非自动生成########

    @ApiModelProperty("ID")
    private String id;

    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("供应商ID")
    private String supCompanyId;

    @ApiModelProperty("证书类型名称")
    private String certificateTypeName;

    @ApiModelProperty("证书类型CODE值")
    private String certificateTypeCode;

    @ApiModelProperty("证书名称,类型")
    private String certificateName;

    @ApiModelProperty("认证机构")
    private String certificationAuthority;

    @ApiModelProperty("证书签发日期")
    private Date certificateCreateTime;

    @ApiModelProperty("证书开始时间")
    private Date startTime;

    @ApiModelProperty("结束时间")
    private Date endTime;

    @ApiModelProperty("上传时间")
    private Date createTime;

    @ApiModelProperty("有效天数(天)")
    private Integer effectiveDate;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("证书文件")
    private String certificateFile;

    @ApiModelProperty("完成标识符(0=未完成，1=已完成)")
    private Integer finishFlag;

    @ApiModelProperty("记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("适用于")
    private String patentDesc;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getCertificateTypeName() {
        return certificateTypeName;
    }

    public void setCertificateTypeName(String certificateTypeName) {
        this.certificateTypeName = certificateTypeName == null ? null : certificateTypeName.trim();
    }

    public String getCertificateTypeCode() {
        return certificateTypeCode;
    }

    public void setCertificateTypeCode(String certificateTypeCode) {
        this.certificateTypeCode = certificateTypeCode == null ? null : certificateTypeCode.trim();
    }

    public String getCertificateName() {
        return certificateName;
    }

    public void setCertificateName(String certificateName) {
        this.certificateName = certificateName == null ? null : certificateName.trim();
    }

    public String getCertificationAuthority() {
        return certificationAuthority;
    }

    public void setCertificationAuthority(String certificationAuthority) {
        this.certificationAuthority = certificationAuthority == null ? null : certificationAuthority.trim();
    }

    public Date getCertificateCreateTime() {
        return certificateCreateTime;
    }

    public void setCertificateCreateTime(Date certificateCreateTime) {
        this.certificateCreateTime = certificateCreateTime;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Integer effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getCertificateFile() {
        return certificateFile;
    }

    public void setCertificateFile(String certificateFile) {
        this.certificateFile = certificateFile == null ? null : certificateFile.trim();
    }

   /* public Integer getFinishFlag() {
        return finishFlag;
    }*/

    public void setFinishFlag(Integer finishFlag) {
        this.finishFlag = finishFlag;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getPatentDesc() {
        return patentDesc;
    }

    public void setPatentDesc(String patentDesc) {
        this.patentDesc = patentDesc == null ? null : patentDesc.trim();
    }
}