package com.els.base.certification.auth.service.impl;

import com.els.base.certification.auth.dao.CompanyAuthMapper;
import com.els.base.certification.auth.entity.CompanyAuth;
import com.els.base.certification.auth.entity.CompanyAuthExample;
import com.els.base.certification.auth.service.CompanyAuthService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("defaultCompanyAuthService")
public class CompanyAuthServiceImpl implements CompanyAuthService {

    @Resource
    private CompanyAuthMapper companyAuthMapper;

    @Cacheable(value="companyAuth", keyGenerator="redisKeyGenerator")
    @Override
    public Integer isFinish(Project project, Company company) {
        List<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);

        CompanyAuthExample companyAuthExample =new CompanyAuthExample();
        //如果数据为空，那么返回0
        companyAuthExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT);
        int count = this.companyAuthMapper.countByExample(companyAuthExample);
        if(count<=0){
            return 0;
        }

        companyAuthExample.clear();
        companyAuthExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT)
                .andFinishFlagIn(list);

        int finishCount = this.companyAuthMapper.countByExample(companyAuthExample);
        if(finishCount>0){
            return 0;
        }else{
            return 1;
        }
    }

    @CacheEvict(value={"companyAuth"}, allEntries=true)
    @Override
    public void deleteObjByIds(String projectId, Company company, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }
        CompanyAuthExample companyAuthExample =new CompanyAuthExample();
        companyAuthExample.createCriteria()
                .andProjectIdEqualTo(projectId)
                .andSupCompanyIdEqualTo(company.getId())
                .andIdIn(ids);
        CompanyAuth companyAuth =new CompanyAuth();
        companyAuth.setIsEnable(Constant.NO_INT);
        this.companyAuthMapper.updateByExampleSelective(companyAuth,companyAuthExample);
    }

    @CacheEvict(value={"companyAuth"}, allEntries=true)
    @Override
    public Integer batchInsert(String projectId, Company company, List<CompanyAuth> companyAuthList) {
        if (CollectionUtils.isEmpty(companyAuthList)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }

        CompanyAuthExample companyAuthExample =new CompanyAuthExample();
        companyAuthExample.createCriteria()
                .andProjectIdEqualTo(projectId)
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT);

        CompanyAuth companyAuth =new CompanyAuth();
        companyAuth.setIsEnable(Constant.NO_INT);

        List list  =  new ArrayList<Integer>();

        this.companyAuthMapper.updateByExampleSelective(companyAuth,companyAuthExample);

        for (CompanyAuth auth : companyAuthList) {
        	Assert.isNotBlank(auth.getCertificateTypeCode(), "有证书名称为空，请正确选择要填写的证书名称");
        	Assert.isNotNull(auth.getEndTime(), "有证书的有效日期为空，请选择证书的有效日期");
        	
        	if (StringUtils.isBlank(auth.getCertificateFile()) || 
        			"[]".equals(auth.getCertificateFile())) {
        		throw new CommonException("有证书没有上传文件，请上传之后再保存");
        	}
            auth.setId(null);
            auth.setProjectId(projectId);
            auth.setSupCompanyId(company.getId());
            auth.setIsEnable(Constant.YES_INT);
            auth.setUpdateTime(new Date());
            if(auth.getCreateTime()==null){
                auth.setCreateTime(new Date());
            }

            Integer finishFlag = auth.getFinishFlag();
            auth.setFinishFlag(finishFlag);
            this.companyAuthMapper.insertSelective(auth);

            list.add(finishFlag);
        }

        if(list.contains(Constant.NO_INT)){
            return 0;
        }else{
            return 1;
        }

    }

    @CacheEvict(value={"companyAuth"}, allEntries=true)
    @Override
    public void addObj(CompanyAuth t) {
        this.companyAuthMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyAuth"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.companyAuthMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyAuth"}, allEntries=true)
    @Override
    public void modifyObj(CompanyAuth t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.companyAuthMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="companyAuth", keyGenerator="redisKeyGenerator")
    @Override
    public CompanyAuth queryObjById(String id) {
        return this.companyAuthMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="companyAuth", keyGenerator="redisKeyGenerator")
    @Override
    public List<CompanyAuth> queryAllObjByExample(CompanyAuthExample example) {
        return this.companyAuthMapper.selectByExample(example);
    }

    @Cacheable(value="companyAuth", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CompanyAuth> queryObjByPage(CompanyAuthExample example) {
        PageView<CompanyAuth> pageView = example.getPageView();
        pageView.setQueryResult(this.companyAuthMapper.selectByExampleByPage(example));
        return pageView;
    }
}