package com.els.base.certification.business.service.impl;

import com.els.base.certification.business.dao.BusinessMapper;
import com.els.base.certification.business.entity.Business;
import com.els.base.certification.business.entity.BusinessExample;
import com.els.base.certification.business.service.BusinessService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultBusinessService")
public class BusinessServiceImpl implements BusinessService {
    @Resource
    protected BusinessMapper businessMapper;
    
    @CacheEvict(value={"business"}, allEntries=true)
    @Override
	public void insertObj(Company company, List<Business> businessList) {
		Assert.isNotEmpty(businessList, "新建的数据不能为空");
		// 如果原来有数据，先删除再添加
		BusinessExample example = new BusinessExample();
		example.createCriteria().andSupCompanyIdEqualTo(company.getId())
			.andIsEnableEqualTo(Constant.YES_INT);
		Business business = new Business();
		business.setIsEnable(Constant.NO_INT);
		this.businessMapper.updateByExampleSelective(business, example);
		
		businessList.forEach(busin ->{
			busin.setSupCompanyId(company.getId());
			busin.setIsEnable(Constant.YES_INT);
			busin.setCreateTime(new Date());
			busin.setUpdateTime(new Date());
			this.businessMapper.insertSelective(busin);
		});
		
	}
    
    @CacheEvict(value={"business"}, allEntries=true)
    @Override
	public void deleteObjByIds(String companyId, List<String> ids) {
		Assert.isNotEmpty(ids, "传入的数据ID不能为空");
		BusinessExample example = new BusinessExample();
		example.createCriteria().andSupCompanyIdEqualTo(companyId)
			.andIsEnableEqualTo(Constant.YES_INT)
			.andIdIn(ids);
		Business business = new Business();
		business.setIsEnable(Constant.NO_INT);
		this.businessMapper.updateByExampleSelective(business, example);
		
	}

    @CacheEvict(value={"business"}, allEntries=true)
    @Override
    public void addObj(Business t) {
        this.businessMapper.insertSelective(t);
    }

    @CacheEvict(value={"business"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.businessMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"business"}, allEntries=true)
    @Override
    public void modifyObj(Business t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.businessMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="business", keyGenerator="redisKeyGenerator")
    @Override
    public Business queryObjById(String id) {
        return this.businessMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="business", keyGenerator="redisKeyGenerator")
    @Override
    public List<Business> queryAllObjByExample(BusinessExample example) {
        return this.businessMapper.selectByExample(example);
    }

    @Cacheable(value="business", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<Business> queryObjByPage(BusinessExample example) {
        PageView<Business> pageView = example.getPageView();
        pageView.setQueryResult(this.businessMapper.selectByExampleByPage(example));
        return pageView;
    }

}