package com.els.base.certification.common;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.utils.reflect.ReflectUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;

import io.swagger.annotations.ApiModelProperty;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/**
 * 准入填写资料处理通用方法
 */
public abstract class AbstractCompany {

	Logger logger = LoggerFactory.getLogger(AbstractCompany.class);

	public Integer getFinishFlag() {
		return this.isFinished() ? Constant.YES_INT : Constant.NO_INT;
	}

	/**
     * 资料填写是否已完成，如果已完成，那么返回true，否则返回false
	 */
	@JsonIgnore
	public boolean isFinished() {
		try {
			
			Class<? extends AbstractCompany> objectClass = this.getClass();

			Field[] fields = objectClass.getDeclaredFields();
			if (ArrayUtils.isEmpty(fields)) {
				logger.info("属性数组为null，返回false");
				return false;
			}
			
			for (Field field : fields) {
				if (this.exculdeFieldNames().contains(field.getName())) {
					continue;
				}
				
				field.setAccessible(true);

				// 有一个为空，就是没有填完
				if (field.get(this) == null) {
					logger.info("属性值为null，返回false");
					return false;
				}

				// 如果类型是String
				if (field.getType().equals(String.class)) {
					String val = (String) ReflectUtils.getValue(this, field.getName());
					logger.debug("属性[{}]的值是[{}]", field.getName(), val);
					if (StringUtils.isBlank(val)) {
						logger.debug("字符串的值为空，返回false");
						return false;
					}
				}
			}
			
		} catch (IllegalAccessException e) {
			throw new CommonException("检查是否填完资料失败");
		} catch (Exception e) {
			throw new CommonException("检查是否填完资料失败");
		}
		return true;
	}
	
	protected List<String> exculdeFieldNames() {
		List<String> filedNameList = new ArrayList<>();
		filedNameList.add("id");
		return filedNameList;
	}

}
