package com.els.base.certification.company.entity;

import com.els.base.certification.process.entity.Process;
import com.els.base.company.entity.Company;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 供应商基本信息：陌生供应商，潜在供应商，合格供应商列表对象
 */
public class Supplier extends Company{
	
	//准入流程
	private Process process;

	public Process getProcess() {
		return process;
	}

	public void setProcess(Process process) {
		this.process = process;
	}

	//供应商基本信息根据Company表继承而来
	@ApiModelProperty(name = "供应商风险类描述")
    private  String businessTypeDesc;
	
	@ApiModelProperty(name = "供应商资查类描述")
    private  String classificationThreeDesc;
    //企业认证信息

    @ApiModelProperty(name = "ISO9001体系证书")
    private  String ISO9001Name;
    
    @ApiModelProperty(name = "ISO9001体系证书上传文件名")
    private  String ISO9001FileName;

    @ApiModelProperty(name = "ISO9001体系证书有效期")
    private Date ISO9001EndTime;

    @ApiModelProperty(name = "IATF16949体系证书")
    private  String IATF16949Name;
    
    @ApiModelProperty(name = "IATF16949体系证书上传文件名")
    private  String IATF16949FileName;

    @ApiModelProperty(name = "IATF16949体系证书有效期")
    private Date IATF16949EndTime;

    @ApiModelProperty(name = "ISO14000体系证书")
    private  String ISO14000Name;
    
    @ApiModelProperty(name = "ISO14000体系证书上传文件名")
    private  String ISO14000FileName;

    @ApiModelProperty(name = "ISO14000证书有效期")
    private Date ISO14000EndTime;


    //其他信息
    @ApiModelProperty(name = "评估报告/资格调查表")
    private  String evaluationReport ;

    @ApiModelProperty(name = "采购协议/采购合同")
    private  String purchaseContract;

    @ApiModelProperty(name = "ROHS协议(IQC)")
    private  String rohs;

    @ApiModelProperty(name = "质量保证协议(IQC)")
    private  String  qualityAssurance ;

    @ApiModelProperty(name = "反腐倡廉协议书")
    private  String antiCorruptionBid;

    @ApiModelProperty(name = "代理品牌")
    private  String  brand;


    //大类1-大类5 注册的时候填写的 IC类之类数据

    @ApiModelProperty("公司主营二类型1")
    private String secondCompanyType1;
    
    @ApiModelProperty("公司主营二类型1说明")
    private String secondCompanyTypeDesc1;

    @ApiModelProperty("公司主营二类型2")
    private String secondCompanyType2;
    
    @ApiModelProperty("公司主营二类型2说明")
    private String secondCompanyTypeDesc2;

    @ApiModelProperty("公司主营二类型3")
    private String secondCompanyType3;
    
    @ApiModelProperty("公司主营二类型3说明")
    private String secondCompanyTypeDesc3;

    @ApiModelProperty("公司主营二类型4")
    private String secondCompanyType4;
    
    @ApiModelProperty("公司主营二类型4说明")
    private String secondCompanyTypeDesc4;

    @ApiModelProperty("公司主营二类型5")
    private String secondCompanyType5;
    
    @ApiModelProperty("公司主营二类型5说明")
    private String secondCompanyTypeDesc5;

    //分类1-分类5
    
    @ApiModelProperty("公司主营一类说明")
    private String  firstCompanyTypeDesc;

    @ApiModelProperty("分类1")
    private String  firstCompanyType1;

    @ApiModelProperty("分类2")
    private String  firstCompanyType2;

    @ApiModelProperty("分类3")
    private String  firstCompanyType3;

    @ApiModelProperty("分类4")
    private String  firstCompanyType4;

    public String getFirstCompanyType1() {
        return firstCompanyType1;
    }

    public void setFirstCompanyType1(String firstCompanyType1) {
        this.firstCompanyType1 = firstCompanyType1;
    }

    public String getFirstCompanyType2() {
        return firstCompanyType2;
    }

    public void setFirstCompanyType2(String firstCompanyType2) {
        this.firstCompanyType2 = firstCompanyType2;
    }

    public String getFirstCompanyType3() {
        return firstCompanyType3;
    }

    public void setFirstCompanyType3(String firstCompanyType3) {
        this.firstCompanyType3 = firstCompanyType3;
    }

    public String getFirstCompanyType4() {
        return firstCompanyType4;
    }

    public void setFirstCompanyType4(String firstCompanyType4) {
        this.firstCompanyType4 = firstCompanyType4;
    }

    public String getISO9001Name() {
        return ISO9001Name;
    }

    public void setISO9001Name(String ISO9001Name) {
        this.ISO9001Name = ISO9001Name;
    }

    public Date getISO9001EndTime() {
        return ISO9001EndTime;
    }

    public void setISO9001EndTime(Date ISO9001EndTime) {
        this.ISO9001EndTime = ISO9001EndTime;
    }

    public String getIATF16949Name() {
        return IATF16949Name;
    }

    public void setIATF16949Name(String IATF16949Name) {
        this.IATF16949Name = IATF16949Name;
    }

    public Date getIATF16949EndTime() {
        return IATF16949EndTime;
    }

    public void setIATF16949EndTime(Date IATF16949EndTime) {
        this.IATF16949EndTime = IATF16949EndTime;
    }

    public String getISO14000Name() {
        return ISO14000Name;
    }

    public void setISO14000Name(String ISO14000Name) {
        this.ISO14000Name = ISO14000Name;
    }

    public Date getISO14000EndTime() {
        return ISO14000EndTime;
    }

    public void setISO14000EndTime(Date ISO14000EndTime) {
        this.ISO14000EndTime = ISO14000EndTime;
    }


    public String getEvaluationReport() {
        return evaluationReport;
    }

    public void setEvaluationReport(String evaluationReport) {
        this.evaluationReport = evaluationReport;
    }

    public String getPurchaseContract() {
        return purchaseContract;
    }

    public void setPurchaseContract(String purchaseContract) {
        this.purchaseContract = purchaseContract;
    }

    public String getRohs() {
        return rohs;
    }

    public void setRohs(String rohs) {
        this.rohs = rohs;
    }

    public String getQualityAssurance() {
        return qualityAssurance;
    }

    public void setQualityAssurance(String qualityAssurance) {
        this.qualityAssurance = qualityAssurance;
    }

    public String getAntiCorruptionBid() {
        return antiCorruptionBid;
    }

    public void setAntiCorruptionBid(String antiCorruptionBid) {
        this.antiCorruptionBid = antiCorruptionBid;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }


    public String getSecondCompanyType1() {
        return secondCompanyType1;
    }

    public void setSecondCompanyType1(String secondCompanyType1) {
        this.secondCompanyType1 = secondCompanyType1;
    }

    public String getSecondCompanyType2() {
        return secondCompanyType2;
    }

    public void setSecondCompanyType2(String secondCompanyType2) {
        this.secondCompanyType2 = secondCompanyType2;
    }

    public String getSecondCompanyType3() {
        return secondCompanyType3;
    }

    public void setSecondCompanyType3(String secondCompanyType3) {
        this.secondCompanyType3 = secondCompanyType3;
    }

    public String getSecondCompanyType4() {
        return secondCompanyType4;
    }

    public void setSecondCompanyType4(String secondCompanyType4) {
        this.secondCompanyType4 = secondCompanyType4;
    }

    public String getSecondCompanyType5() {
        return secondCompanyType5;
    }

    public void setSecondCompanyType5(String secondCompanyType5) {
        this.secondCompanyType5 = secondCompanyType5;
    }

	public String getISO9001FileName() {
		return ISO9001FileName;
	}

	public void setISO9001FileName(String iSO9001FileName) {
		ISO9001FileName = iSO9001FileName;
	}

	public String getIATF16949FileName() {
		return IATF16949FileName;
	}

	public void setIATF16949FileName(String iATF16949FileName) {
		IATF16949FileName = iATF16949FileName;
	}

	public String getISO14000FileName() {
		return ISO14000FileName;
	}

	public void setISO14000FileName(String iSO14000FileName) {
		ISO14000FileName = iSO14000FileName;
	}

	public String getSecondCompanyTypeDesc1() {
		return secondCompanyTypeDesc1;
	}

	public void setSecondCompanyTypeDesc1(String secondCompanyTypeDesc1) {
		this.secondCompanyTypeDesc1 = secondCompanyTypeDesc1;
	}

	public String getSecondCompanyTypeDesc2() {
		return secondCompanyTypeDesc2;
	}

	public void setSecondCompanyTypeDesc2(String secondCompanyTypeDesc2) {
		this.secondCompanyTypeDesc2 = secondCompanyTypeDesc2;
	}

	public String getSecondCompanyTypeDesc3() {
		return secondCompanyTypeDesc3;
	}

	public void setSecondCompanyTypeDesc3(String secondCompanyTypeDesc3) {
		this.secondCompanyTypeDesc3 = secondCompanyTypeDesc3;
	}

	public String getSecondCompanyTypeDesc4() {
		return secondCompanyTypeDesc4;
	}

	public void setSecondCompanyTypeDesc4(String secondCompanyTypeDesc4) {
		this.secondCompanyTypeDesc4 = secondCompanyTypeDesc4;
	}

	public String getSecondCompanyTypeDesc5() {
		return secondCompanyTypeDesc5;
	}

	public void setSecondCompanyTypeDesc5(String secondCompanyTypeDesc5) {
		this.secondCompanyTypeDesc5 = secondCompanyTypeDesc5;
	}

	public String getFirstCompanyTypeDesc() {
		return firstCompanyTypeDesc;
	}

	public void setFirstCompanyTypeDesc(String firstCompanyTypeDesc) {
		this.firstCompanyTypeDesc = firstCompanyTypeDesc;
	}

	public String getBusinessTypeDesc() {
		return businessTypeDesc;
	}

	public void setBusinessTypeDesc(String businessTypeDesc) {
		this.businessTypeDesc = businessTypeDesc;
	}

	public String getClassificationThreeDesc() {
		return classificationThreeDesc;
	}

	public void setClassificationThreeDesc(String classificationThreeDesc) {
		this.classificationThreeDesc = classificationThreeDesc;
	}
    
}
