package com.els.base.certification.contacts.entity;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.utils.reflect.ReflectUtils;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(value="联系人信息")
public class Contacts implements Serializable {
	Logger logger = LoggerFactory.getLogger(Contacts.class);
	//#######非自动生成########
	public Integer getFinishFlag() {
		try {
			Class<? extends Contacts> objectClass = this.getClass();
			Field[] fields = objectClass.getDeclaredFields();
			if (ArrayUtils.isEmpty(fields)) {
				logger.info("属性数组为null，返回0");
				return Constant.NO_INT;
			}

			for (Field field : fields) {
				if (this.exculdeFieldNames().contains(field.getName())) {
					continue;
				}

				field.setAccessible(true);

				// 有一个为空，就是没有填完
				if (field.get(this) == null) {
					logger.info("属性值为null，返回0");
					//return Constant.NO_INT;
					if (null != field.getAnnotation(ApiModelProperty.class)) {
						throw new CommonException(field.getAnnotation(ApiModelProperty.class).value() + "不能为空，请正确填写信息，谢谢！");
					} else {
						throw new CommonException("联系人信息没填写完整，请正确填写信息，谢谢！");
					}
				}

				// 如果类型是String
				if (field.getType().equals(String.class)) {
					String val = (String) ReflectUtils.getValue(this, field.getName());
					logger.debug("属性[{}]的值是[{}]", field.getName(), val);
					if (StringUtils.isBlank(val)) {
						logger.debug("字符串的值为空，返回0");
						 //return Constant.NO_INT;
						if (null != field.getAnnotation(ApiModelProperty.class)) {
							throw new CommonException(field.getAnnotation(ApiModelProperty.class).value() + "不能为空，请正确填写信息，谢谢！");
						} else {
							throw new CommonException("联系人信息没填写完整，请正确填写信息，谢谢！");
						}
					}
				}
			}

		} catch (IllegalAccessException e) {
			throw new CommonException("检查是否填完资料失败");
		}
		return Constant.YES_INT;
	}
	//忽略校验字段
	protected List<String> exculdeFieldNames(){
		List<String> filedNameList = new ArrayList<>();
		filedNameList.add("id");
		filedNameList.add("isEnable");
		filedNameList.add("createTime");
		filedNameList.add("supCompanyId");
		filedNameList.add("projectId");
		filedNameList.add("finishFlag");
		return filedNameList;
	}
	//#######非自动生成########
	@ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("姓名")
    private String name;

    @ApiModelProperty("性别")
    private String gender;

    @ApiModelProperty("职务")
    private String post;

    @ApiModelProperty("部门")
    private String department;

    @ApiModelProperty("办公电话")
    private String officePhone;

    @ApiModelProperty("手机号")
    private String mobilePhone;

    @ApiModelProperty("电子邮箱")
    private String email;

    @ApiModelProperty("传真")
    private String fax;
    
    @ApiModelProperty("供应商ID")
    private String supCompanyId;
    
    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("完成标识符(0=未完成，1=已完成)")
    private Integer finishFlag;

    @ApiModelProperty("记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;
    
    @ApiModelProperty("创建时间")
    private Date createTime;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender == null ? null : gender.trim();
    }

    public String getPost() {
        return post;
    }

    public void setPost(String post) {
        this.post = post == null ? null : post.trim();
    }

    public String getDepartment() {
        return department;
    }

    public void setDepartment(String department) {
        this.department = department == null ? null : department.trim();
    }

    public String getOfficePhone() {
        return officePhone;
    }

    public void setOfficePhone(String officePhone) {
        this.officePhone = officePhone == null ? null : officePhone.trim();
    }

    public String getMobilePhone() {
        return mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone == null ? null : mobilePhone.trim();
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email == null ? null : email.trim();
    }

    public String getFax() {
        return fax;
    }

    public void setFax(String fax) {
        this.fax = fax == null ? null : fax.trim();
    }
    
    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }
    
    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

  /*  public Integer getFinishFlag() {
        return finishFlag;
    }*/

    public void setFinishFlag(Integer finishFlag) {
        this.finishFlag = finishFlag;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }
    
    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}