package com.els.base.certification.contacts.service;

import java.util.List;

import com.els.base.certification.contacts.entity.Contacts;
import com.els.base.certification.contacts.entity.ContactsExample;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.core.service.BaseService;

public interface ContactsService extends BaseService<Contacts, ContactsExample, String> {
	/**
	 * 根据公司ID查询联系人信息
	 * @param companyId
	 * @return
	 */
	List<Contacts> queryAllContacts(String companyId);
	
	/**
	 * 批量删除联系人
	 * @param ids
	 */
	public void deleteObjByIds(List<String> ids);
	
	/**
	 *  @param id
	 * @param projectId
     * @param contacts
     */
	public Integer addContacts(String projectId, String companyId, List<Contacts> contacts);

	/**
	 * 判断资料是否填写完整
	 * @param project
	 * @param company
	 * @return
	 */
    Integer isFinish(Project project, Company company);
    
}