package com.els.base.certification.contrast.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

@ApiModel(value="潜在供应商对比表")
public class CompanyContrast implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("采购商id")
    private String purCompanyId;

    @ApiModelProperty("采购商SRM编码")
    private String purCompanySrmCode;

    @ApiModelProperty("采购商全称")
    private String purCompanyName;

    @ApiModelProperty("采购商简称")
    private String purCompanyShortName;

    @ApiModelProperty("单据号")
    private String contrastBillNo;

    @ApiModelProperty("物料编码")
    private String materialCode;

    @ApiModelProperty("物料类型")
    private String materialType;

    @ApiModelProperty("物料描述")
    private String materialDesc;

    @ApiModelProperty("制单人")
    private String createBillUserName;

    @ApiModelProperty("制单时间")
    private Date createBillTime;

    @ApiModelProperty("建议引入的供应商")
    private String suggestedSupplier;

    @ApiModelProperty("审批意见")
    private String approveSuggestion;

    @ApiModelProperty("供应商1的id")
    private String firstSupCompanyId;

    @ApiModelProperty("供应商1的SRM编码")
    private String firstSupCompanySrmCode;

    @ApiModelProperty("供应商1的全称")
    private String firstSupCompanyName;

    @ApiModelProperty("供应商1的简称")
    private String firstSupCompanyShortName;

    @ApiModelProperty("供应商2的id")
    private String secondSupCompanyId;

    @ApiModelProperty("供应商2的SRM编码")
    private String secondSupCompanySrmCode;

    @ApiModelProperty("供应商2的全称")
    private String secondSupCompanyName;

    @ApiModelProperty("供应商2的简称")
    private String secondSupCompanyShortName;

    @ApiModelProperty("供应商3的id")
    private String thirdSupCompanyId;

    @ApiModelProperty("供应商3的SRM编码")
    private String thirdSupCompanySrmCode;

    @ApiModelProperty("供应商3的全称")
    private String thirdSupCompanyName;

    @ApiModelProperty("供应商3的简称")
    private String thirdSupCompanyShortName;

    @ApiModelProperty("审批人")
    private String approveUserName;

    @ApiModelProperty("审批时间")
    private Date approveTime;

    @ApiModelProperty("审批状态（1=未审核,2=正在审核,3=审核通过,4=驳回）")
    private Integer approveStatus;

    @ApiModelProperty("确认状态(未确认=0，已确认=1,已拒绝=2，已作废=3)")
    private Integer confirmStatus;

    @ApiModelProperty("记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("推荐理由")
    private String suggestedReason;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurCompanyShortName() {
        return purCompanyShortName;
    }

    public void setPurCompanyShortName(String purCompanyShortName) {
        this.purCompanyShortName = purCompanyShortName == null ? null : purCompanyShortName.trim();
    }

    public String getContrastBillNo() {
        return contrastBillNo;
    }

    public void setContrastBillNo(String contrastBillNo) {
        this.contrastBillNo = contrastBillNo == null ? null : contrastBillNo.trim();
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    public String getMaterialType() {
        return materialType;
    }

    public void setMaterialType(String materialType) {
        this.materialType = materialType == null ? null : materialType.trim();
    }

    public String getMaterialDesc() {
        return materialDesc;
    }

    public void setMaterialDesc(String materialDesc) {
        this.materialDesc = materialDesc == null ? null : materialDesc.trim();
    }

    public String getCreateBillUserName() {
        return createBillUserName;
    }

    public void setCreateBillUserName(String createBillUserName) {
        this.createBillUserName = createBillUserName == null ? null : createBillUserName.trim();
    }

    public Date getCreateBillTime() {
        return createBillTime;
    }

    public void setCreateBillTime(Date createBillTime) {
        this.createBillTime = createBillTime;
    }

    public String getSuggestedSupplier() {
        return suggestedSupplier;
    }

    public void setSuggestedSupplier(String suggestedSupplier) {
        this.suggestedSupplier = suggestedSupplier == null ? null : suggestedSupplier.trim();
    }

    public String getApproveSuggestion() {
        return approveSuggestion;
    }

    public void setApproveSuggestion(String approveSuggestion) {
        this.approveSuggestion = approveSuggestion == null ? null : approveSuggestion.trim();
    }

    public String getFirstSupCompanyId() {
        return firstSupCompanyId;
    }

    public void setFirstSupCompanyId(String firstSupCompanyId) {
        this.firstSupCompanyId = firstSupCompanyId == null ? null : firstSupCompanyId.trim();
    }

    public String getFirstSupCompanySrmCode() {
        return firstSupCompanySrmCode;
    }

    public void setFirstSupCompanySrmCode(String firstSupCompanySrmCode) {
        this.firstSupCompanySrmCode = firstSupCompanySrmCode == null ? null : firstSupCompanySrmCode.trim();
    }

    public String getFirstSupCompanyName() {
        return firstSupCompanyName;
    }

    public void setFirstSupCompanyName(String firstSupCompanyName) {
        this.firstSupCompanyName = firstSupCompanyName == null ? null : firstSupCompanyName.trim();
    }

    public String getFirstSupCompanyShortName() {
        return firstSupCompanyShortName;
    }

    public void setFirstSupCompanyShortName(String firstSupCompanyShortName) {
        this.firstSupCompanyShortName = firstSupCompanyShortName == null ? null : firstSupCompanyShortName.trim();
    }

    public String getSecondSupCompanyId() {
        return secondSupCompanyId;
    }

    public void setSecondSupCompanyId(String secondSupCompanyId) {
        this.secondSupCompanyId = secondSupCompanyId == null ? null : secondSupCompanyId.trim();
    }

    public String getSecondSupCompanySrmCode() {
        return secondSupCompanySrmCode;
    }

    public void setSecondSupCompanySrmCode(String secondSupCompanySrmCode) {
        this.secondSupCompanySrmCode = secondSupCompanySrmCode == null ? null : secondSupCompanySrmCode.trim();
    }

    public String getSecondSupCompanyName() {
        return secondSupCompanyName;
    }

    public void setSecondSupCompanyName(String secondSupCompanyName) {
        this.secondSupCompanyName = secondSupCompanyName == null ? null : secondSupCompanyName.trim();
    }

    public String getSecondSupCompanyShortName() {
        return secondSupCompanyShortName;
    }

    public void setSecondSupCompanyShortName(String secondSupCompanyShortName) {
        this.secondSupCompanyShortName = secondSupCompanyShortName == null ? null : secondSupCompanyShortName.trim();
    }

    public String getThirdSupCompanyId() {
        return thirdSupCompanyId;
    }

    public void setThirdSupCompanyId(String thirdSupCompanyId) {
        this.thirdSupCompanyId = thirdSupCompanyId == null ? null : thirdSupCompanyId.trim();
    }

    public String getThirdSupCompanySrmCode() {
        return thirdSupCompanySrmCode;
    }

    public void setThirdSupCompanySrmCode(String thirdSupCompanySrmCode) {
        this.thirdSupCompanySrmCode = thirdSupCompanySrmCode == null ? null : thirdSupCompanySrmCode.trim();
    }

    public String getThirdSupCompanyName() {
        return thirdSupCompanyName;
    }

    public void setThirdSupCompanyName(String thirdSupCompanyName) {
        this.thirdSupCompanyName = thirdSupCompanyName == null ? null : thirdSupCompanyName.trim();
    }

    public String getThirdSupCompanyShortName() {
        return thirdSupCompanyShortName;
    }

    public void setThirdSupCompanyShortName(String thirdSupCompanyShortName) {
        this.thirdSupCompanyShortName = thirdSupCompanyShortName == null ? null : thirdSupCompanyShortName.trim();
    }

    public String getApproveUserName() {
        return approveUserName;
    }

    public void setApproveUserName(String approveUserName) {
        this.approveUserName = approveUserName == null ? null : approveUserName.trim();
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public Integer getApproveStatus() {
        return approveStatus;
    }

    public void setApproveStatus(Integer approveStatus) {
        this.approveStatus = approveStatus;
    }

    public Integer getConfirmStatus() {
        return confirmStatus;
    }

    public void setConfirmStatus(Integer confirmStatus) {
        this.confirmStatus = confirmStatus;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getSuggestedReason() {
        return suggestedReason;
    }

    public void setSuggestedReason(String suggestedReason) {
        this.suggestedReason = suggestedReason == null ? null : suggestedReason.trim();
    }
}