package com.els.base.certification.contrast.service.impl;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.els.base.certification.auth.entity.CompanyAuth;
import com.els.base.certification.auth.entity.CompanyAuthExample;
import com.els.base.certification.auth.service.CompanyAuthService;
import com.els.base.certification.contrast.dao.CompanyContrastMapper;
import com.els.base.certification.contrast.entity.CompanyContrast;
import com.els.base.certification.contrast.entity.CompanyContrastExample;
import com.els.base.certification.contrast.entity.CompanyContrastItem;
import com.els.base.certification.contrast.entity.CompanyContrastItemExample;
import com.els.base.certification.contrast.service.CompanyContrastItemService;
import com.els.base.certification.contrast.service.CompanyContrastService;
import com.els.base.certification.contrast.utils.CompanyContrastApproveEnum;
import com.els.base.certification.contrast.utils.CompanyContrastPrintUtils;
import com.els.base.certification.contrast.vo.CompanyContrastVO;
import com.els.base.certification.customer.entity.CompanyCustomer;
import com.els.base.certification.customer.entity.CompanyCustomerExample;
import com.els.base.certification.customer.service.CompanyCustomerService;
import com.els.base.certification.equipment.entity.CompanyEquipment;
import com.els.base.certification.equipment.entity.CompanyEquipmentExample;
import com.els.base.certification.equipment.service.CompanyEquipmentService;
import com.els.base.certification.finance.entity.CompanyFinance;
import com.els.base.certification.finance.entity.CompanyFinanceExample;
import com.els.base.certification.finance.service.CompanyFinanceService;
import com.els.base.certification.productservice.entity.CompanyProductService;
import com.els.base.certification.productservice.entity.CompanyProductServiceExample;
import com.els.base.certification.productservice.service.CompanyProductServiceService;
import com.els.base.certification.technology.entity.CompanyTechnology;
import com.els.base.certification.technology.entity.CompanyTechnologyExample;
import com.els.base.certification.technology.service.CompanyTechnologyService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;

@Service("defaultCompanyContrastService")
public class CompanyContrastServiceImpl implements CompanyContrastService,ITaskListener {
	private static final Logger logger = LoggerFactory.getLogger(CompanyContrastServiceImpl.class);
	
	private static SimpleDateFormat formatter = new SimpleDateFormat( "yyyy-MM-dd");
	
	@Resource
    private CompanyContrastItemService companyContrastItemService;
	
	@Resource
    private CompanyService companyService;
	
	@Resource
    private WorkFlowService workFlowService;
	
	@Resource
    private DicGroupItemService dicGroupItemService;
	
	@Resource
	private CompanyProductServiceService companyProductServiceService;
	
	@Resource
	private CompanyTechnologyService companyTechnologyService;
	
	@Resource
	private CompanyCustomerService companyCustomerService;
	
	@Resource
    private CompanyFinanceService companyFinanceService;
	
	@Resource
    private CompanyEquipmentService companyEquipmentService;
	
	@Resource
    private CompanyAuthService companyAuthService;
	
	@Resource
    protected CompanyContrastMapper companyContrastMapper;

    @CacheEvict(value={"companyContrast"}, allEntries=true)
    @Override
    public void addObj(CompanyContrast t) {
        this.companyContrastMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyContrast"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.companyContrastMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyContrast"}, allEntries=true)
    @Override
    public void modifyObj(CompanyContrast t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.companyContrastMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="companyContrast", keyGenerator="redisKeyGenerator")
    @Override
    public CompanyContrast queryObjById(String id) {
        return this.companyContrastMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="companyContrast", keyGenerator="redisKeyGenerator")
    @Override
    public List<CompanyContrast> queryAllObjByExample(CompanyContrastExample example) {
        return this.companyContrastMapper.selectByExample(example);
    }

    @Cacheable(value="companyContrast", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CompanyContrast> queryObjByPage(CompanyContrastExample example) {
        PageView<CompanyContrast> pageView = example.getPageView();
        pageView.setQueryResult(this.companyContrastMapper.selectByExampleByPage(example));
        return pageView;
    }
    
    @Cacheable(value="companyContrast", keyGenerator="redisKeyGenerator")
	@Override
	public CompanyContrastItem generateCompanyContrastInfo(String supCompanyId,String materialType) {
		if(StringUtils.isEmpty(supCompanyId)){
			throw new CommonException("传递的供应商id为空!");
		}
		//查询供应商主数据
    	Company company = this.companyService.queryObjById(supCompanyId);
    	if(null == company){
    		throw new CommonException("查询的供应商为空!");
    	}
		
		//查询主要产品服务
		CompanyProductServiceExample companyProductServiceExample = new CompanyProductServiceExample();
		companyProductServiceExample.createCriteria()
				.andSupCompanyIdEqualTo(supCompanyId)
				.andIsEnableEqualTo(Constant.YES_INT);
		
		List<CompanyProductService> productServiceList = this.companyProductServiceService.queryAllObjByExample(companyProductServiceExample);
		
		//查询主要客户
		CompanyCustomerExample companyCustomerExample = new CompanyCustomerExample();
		companyCustomerExample.createCriteria()
				.andSupCompanyIdEqualTo(supCompanyId)
				.andIsEnableEqualTo(Constant.YES_INT);
		
		List<CompanyCustomer> companyCustomerList = this.companyCustomerService.queryAllObjByExample(companyCustomerExample);
		
		//查询主要技术
		CompanyTechnologyExample companyTechnologyExample = new CompanyTechnologyExample();
		companyTechnologyExample.createCriteria()
				.andSupCompanyIdEqualTo(supCompanyId)
				.andIsEnableEqualTo(Constant.YES_INT);
		
		List<CompanyTechnology> companyTechnologyList = this.companyTechnologyService.queryAllObjByExample(companyTechnologyExample);
		
		//查询财务信息
		CompanyFinanceExample companyFinanceExample = new CompanyFinanceExample();
		companyFinanceExample.createCriteria()
				.andSupCompanyIdEqualTo(supCompanyId)
				.andIsEnableEqualTo(Constant.YES_INT);
		List<CompanyFinance> financeList = this.companyFinanceService.queryAllObjByExample(companyFinanceExample);
		
		//检测设备
		CompanyEquipmentExample companyEquipmentExample = new CompanyEquipmentExample();
		companyEquipmentExample.createCriteria()
				.andSupCompanyIdEqualTo(supCompanyId)
				.andIsEnableEqualTo(Constant.YES_INT);
		
		List<CompanyEquipment> equipmentList = this.companyEquipmentService.queryAllObjByExample(companyEquipmentExample);
		
		
		//认证
		CompanyAuthExample companyAuthExample = new CompanyAuthExample();
		companyAuthExample.createCriteria()
				.andSupCompanyIdEqualTo(supCompanyId)
				.andIsEnableEqualTo(Constant.YES_INT);
		List<CompanyAuth> authList = this.companyAuthService.queryAllObjByExample(companyAuthExample);
		
		CompanyContrastItem item = this.completeData(materialType,company, productServiceList, 
				companyCustomerList, companyTechnologyList, financeList,equipmentList,authList);
		
		return item;
	}
    
    private CompanyContrastItem completeData(String materialType,Company company,List<CompanyProductService> productServiceList
    		,List<CompanyCustomer> companyCustomerList,List<CompanyTechnology> companyTechnologyList,
    		List<CompanyFinance> companyFinanceList,List<CompanyEquipment> equipmentList,List<CompanyAuth> authList){
    	CompanyContrastItem item = new CompanyContrastItem();
    	item.setId(UUIDGenerator.generateUUID());
    	item.setSupCompanyId(company.getId());
    	item.setSupCompanySrmCode(company.getCompanyCode());
    	item.setSupCompanyName(company.getCompanyFullName());
    	item.setSupCompanyShortName(company.getCompanyName());
    	item.setSupCompanyAddress(company.getAddress());
    	//成立时间
    	if(company.getCompanyEstablishmentTime() != null){
    		String establishTime = formatter.format(company.getCompanyEstablishmentTime());
    		item.setEstablishTime(establishTime);
    	}
    	
    	item.setRegisterCapital(company.getRegisteredCapital());
    	if(company.getTotalNumber() != null){
    		item.setEmployeeQuantity(company.getTotalNumber().toString());
    	}
    	if(CollectionUtils.isNotEmpty(companyFinanceList)){
    		//近三年销售额   
    		BigDecimal saleAmount = BigDecimal.ZERO;
    		BigDecimal profitRate = BigDecimal.ZERO;
    		for (CompanyFinance cf : companyFinanceList) {
    			//近三年销售额
    			if(StringUtils.isNotEmpty(cf.getBusinessVolume())){
    				saleAmount = saleAmount.add(new BigDecimal(cf.getBusinessVolume()));
    			}
    			//毛利率
    			if(StringUtils.isNotBlank(cf.getGrossProfitRate())){
    				profitRate = profitRate.add(new BigDecimal(cf.getGrossProfitRate()));
    			}
			}
    		item.setThreeYearSaleAmount(saleAmount.toString());
    		//毛利率取平均值 
    		profitRate = profitRate.divide(new BigDecimal(companyFinanceList.size()),2, BigDecimal.ROUND_HALF_UP);
    		item.setProfitRate(profitRate.toString());
    	}else{
    		item.setThreeYearSaleAmount("0");
    	}
    	
    	
    	if(CollectionUtils.isNotEmpty(productServiceList)){
    		CompanyProductService productService = productServiceList.get(0);
    		//主要产品
    		item.setMainProduct(productService.getProductServiceName());
    		//采购周期(欲竞投类产品供货周期)
    		item.setPurchaseCycle(company.getProductSupplyCycle());
    	}
    	
    	//价格水平
    	
    	if(CollectionUtils.isNotEmpty(companyCustomerList)){
    		CompanyCustomer companyCustomer = companyCustomerList.get(0);
    		//主要客户
    		item.setMainCustomer(companyCustomer.getCustomerName());
    		//汽车业务比例
    		if(companyCustomer.getCarIndustryPercent() != null){
    			item.setCarBusinessPercent(companyCustomer.getCarIndustryPercent().toString());
    		}
    		//汽车行业的主要客户
    		for (CompanyCustomer cc : companyCustomerList) {
    			if("汽车".equals(cc.getIndustry())){
    				//汽车行业主要客户
    				item.setCarIndustryMainCustomer(cc.getCustomerName());
    				//汽车类业务销售
    				item.setCarBusinessSaleAmount(cc.getTotalSalePercent().toString());
    				break;
    			}
			}
    	}
    	
    	
    	//汽车业务销售额
    	
    	//市场份额
    	
    	//主要应用领域
    	
    	//运输方式
    	if(StringUtils.isNotEmpty(company.getDeliveryMode())){
    		DicGroupItem deliveryModeDicItem = this.dicGroupItemService.queryItems("zr_deliverymode",company.getDeliveryMode());
    		if(null != deliveryModeDicItem){
    			item.setTransportStyle(deliveryModeDicItem.getName());
    		}
    	}
    	
//    	if("DEQ".equals(company.getDeliveryMode())){
//    		item.setTransportStyle("目的港码头交货");
//    	}else if("DAF".equals(company.getDeliveryMode())){
//    		item.setTransportStyle("边境交货");
//    	}else if("DES".equals(company.getDeliveryMode())){
//    		item.setTransportStyle("目的港船上交货");
//    	}else if("EXW".equals(company.getDeliveryMode())){
//    		item.setTransportStyle("工厂交货");
//    	}else if("DDU".equals(company.getDeliveryMode())){
//    		item.setTransportStyle("未完税交货");
//    	}else if("DDP".equals(company.getDeliveryMode())){
//    		item.setTransportStyle("完税后交货");
//    	}else if("FAS".equals(company.getDeliveryMode())){
//    		item.setTransportStyle("船边交货");
//    	}else{
//    		item.setTransportStyle("");
//    	}
    	
    	//月产能
    	if("1".equals(materialType)){
    		//标准件直接用月产能
    		if(company.getMonthlyCapacity() != null){
    			item.setMonthlyCapacity(company.getMonthlyCapacity().toString());
    		}
    	}else if("3".equals(materialType)){
    		//定制件要:产能/12
    		if(null != company.getProductCapacity()){
    			System.out.println(company.getProductCapacity());
    			BigDecimal result = company.getProductCapacity().divide(new BigDecimal(12),2, BigDecimal.ROUND_HALF_UP);
    			item.setMonthlyCapacity(result.toString());
    		}
    	}
    	
    	
    	//供货弹性
    	
    	//体系认证
    	if(CollectionUtils.isNotEmpty(authList)){
//    		IOS9001("ios9001","ISO9001体系证书"),
//    	    IATF16949("iatf16949","IATF16949体系证书"),
//    	    IOS14000("ios14000","ISO14000证书"),
//    	    LICENSE("license","营业执照/登记证书"),
//    	    PROXY_CARD("proxyCard","代理证/授权书"),
//    	    OTHER("other","其它证书") ;
    		String certificateTypeCode = authList.get(0).getCertificateTypeCode();
			if(StringUtils.isNotEmpty(certificateTypeCode)){
				if("ios9001".equals(certificateTypeCode)){
					item.setSystemCertification("ISO9001体系证书");
					item.setQualityCertification("ISO9001体系证书");
				}else if("iatf16949".equals(certificateTypeCode)){
					item.setSystemCertification("IATF16949体系证书");
					item.setQualityCertification("IATF16949体系证书");
				}else if("ios14000".equals(certificateTypeCode)){
					item.setSystemCertification("ISO14000证书");
					item.setQualityCertification("ISO14000证书");
				}else if("license".equals(certificateTypeCode)){
					item.setSystemCertification("营业执照/登记证书");
					item.setQualityCertification("营业执照/登记证书");
				}else if("proxyCard".equals(certificateTypeCode)){
					item.setSystemCertification("代理证/授权书");
					item.setQualityCertification("代理证/授权书");
				} else if ("15085".equals(certificateTypeCode)) {
					item.setSystemCertification("15085证书");
					item.setQualityCertification("15085证书");
				} else if ("iso22163".equals(certificateTypeCode)) {
					item.setSystemCertification("ISO/TS 22163证书");
					item.setQualityCertification("ISO/TS 22163证书");
				}else if("other".equals(certificateTypeCode)){
					item.setSystemCertification("其它证书");
					item.setQualityCertification("其它证书");
				}else{
					item.setSystemCertification("");
					item.setQualityCertification("");
				}
			}
    		
    	}
    	
    	//PPM表现
    	item.setPpmPerformance(company.getPpmPerformance());
    	//BD反馈时间
    	if(StringUtils.isNotBlank(company.getFeedbackTime())){
    		item.setBdFeedbackTime(company.getFeedbackTime());
    	}
    	//质量工程师数量
    	if(company.getQualityInspectorNumber() != null){
    		item.setQualityEngineerQuantity(company.getQualityInspectorNumber().toString());
    	}
    	//主要测试设备
    	if(CollectionUtils.isNotEmpty(equipmentList)){
    		CompanyEquipment companyEquipment = equipmentList.get(0);
    		item.setMainTestDevice(companyEquipment.getEquipmentName());
    	}
    	
    	//汽车客户质量服务经营
    	
    	//体质量系认证
    	
    	//研发工程师数量(工程技术人员数)
    	if(null != company.getTechnicianNumber()){
    		item.setDevelopEngineerQuantity(company.getTechnicianNumber().toString());
    	}
    	
    	if(CollectionUtils.isNotEmpty(companyTechnologyList)){
    		CompanyTechnology companyTechnology = companyTechnologyList.get(0);
    		//关键技术应用
    		item.setKeyTechnology(companyTechnology.getPivotalTechnology());
    		//核心技术 
    		item.setCoreTechnology(companyTechnology.getCentralTechnology());
    		//主要生产技术
    		item.setMainProductTechnology(companyTechnology.getMajorProductiveTechnology());
    		//主要开发软件
    		item.setMainDevelopSoftware(companyTechnology.getMajorDevelopSoftware());
    	}
    	
    	
    	//付款账期
    	if(StringUtils.isNotEmpty(company.getPayConditionsCode())){
    		DicGroupItem payAccountPeriodDicItem = this.dicGroupItemService.queryItems("zr_fukuanfangshi", company.getPayConditionsCode());
    		if(null != payAccountPeriodDicItem){
    			item.setPaymentAccountPeriod(payAccountPeriodDicItem.getName());
    		}
    	}
    	
		return item;
    }
    
    @CacheEvict(value={"companyContrast"}, allEntries=true)
	@Override
	public void deleteByIds(List<String> ids) {
		if(CollectionUtils.isEmpty(ids)){
			throw new CommonException("操作失败，数据不能为空!");
		}
		
//		example.createCriteria()
//			   .andIdIn(ids)
//		       .andConfirmStatusEqualTo(CompanyContrastConfirmStatusEnum.STATUS_ABOLISH.getStatus());
//		
//		if(this.companyContrastMapper.countByExample(example) > 0){
//			throw new CommonException("您选择的数据中包括已作废的单据,无法删除数据!");
//		}
		
		List<Integer> statusList = new ArrayList<>();
		statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_FAIL.getStatus());
		statusList.add(CompanyContrastApproveEnum.STATUS_APPROVING.getStatus());
		statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_SUCCESS.getStatus());
		statusList.add(CompanyContrastApproveEnum.STATUS_ABOLISH.getStatus());
		
		CompanyContrastExample example = new CompanyContrastExample();
		example.createCriteria()
			   .andIdIn(ids)
		       .andApproveStatusIn(statusList);
		if(this.companyContrastMapper.countByExample(example) > 0){
			throw new CommonException("您选择的数据中包括已作废或正在审批或审批成功或审批失败的单据,无法删除数据!");
		}
		
		CompanyContrast companyContrast = new CompanyContrast();
		companyContrast.setIsEnable(Constant.NO_INT);
		companyContrast.setUpdateTime(new Date());
		
		example.clear();
		example.createCriteria()
		       .andIdIn(ids);
		
		this.companyContrastMapper.updateByExampleSelective(companyContrast, example);
		
	}
    
    @Transactional
    @CacheEvict(value={"companyContrast"}, allEntries=true)
	@Override
	public void abolishByIds(List<String> ids) {
    	if(CollectionUtils.isEmpty(ids)){
			throw new CommonException("操作失败，数据不能为空!");
		}
    	
//		example.createCriteria()
//			   .andIdIn(ids)
//		       .andConfirmStatusEqualTo(CompanyContrastConfirmStatusEnum.STATUS_ABOLISH.getStatus());
//		
//		if(this.companyContrastMapper.countByExample(example) > 0){
//			throw new CommonException("您选择的数据中包括已作废的单据,无法作废数据!");
//		}
		
		List<Integer> statusList = new ArrayList<>();
		statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_FAIL.getStatus());
		statusList.add(CompanyContrastApproveEnum.STATUS_UN_APPROVE.getStatus());
		statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_SUCCESS.getStatus());
		statusList.add(CompanyContrastApproveEnum.STATUS_ABOLISH.getStatus());
		
		CompanyContrastExample example = new CompanyContrastExample();
		example.createCriteria()
			   .andIdIn(ids)
		       .andApproveStatusIn(statusList);
		if(this.companyContrastMapper.countByExample(example) > 0){
			throw new CommonException("您选择的数据中包括已作废或未审批或审批成功或审批失败的单据,无法作废数据!");
		}
		
		example.clear();
		example.createCriteria()
			   .andIdIn(ids);
		
		CompanyContrast companyContrast = new CompanyContrast();
		companyContrast.setApproveStatus(CompanyContrastApproveEnum.STATUS_ABOLISH.getStatus());
		companyContrast.setUpdateTime(new Date());
		
		this.companyContrastMapper.updateByExampleSelective(companyContrast, example);
		
		List<CompanyContrast> list = this.queryAllObjByExample(example);
		if(CollectionUtils.isEmpty(list)){
			logger.debug("查询的数据为空,无法作废单据!");
			return ;
		}
		this.stopWorkFlowProce(list);
    }
    
    private void stopWorkFlowProce(List<CompanyContrast> list){
    	for (CompanyContrast item : list) {
			this.workFlowService.stopProcess("qzgysdbb", item.getContrastBillNo());
		}
    }
    
    @Transactional
    @CacheEvict(value={"companyContrast"}, allEntries=true)
	@Override
	public void sendDataToApprove(List<String> ids) {
    	if(CollectionUtils.isEmpty(ids)){
			throw new CommonException("操作失败，数据不能为空!");
		}
    	
//		example.createCriteria()
//			   .andIdIn(ids)
//		       .andConfirmStatusEqualTo(CompanyContrastConfirmStatusEnum.STATUS_ABOLISH.getStatus());
//	
//		if(this.companyContrastMapper.countByExample(example) > 0){
//			throw new CommonException("您选择的数据中包括已作废的单据,无法发送审批单据!");
//		}
		
		List<Integer> statusList = new ArrayList<>();
		statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_FAIL.getStatus());
		statusList.add(CompanyContrastApproveEnum.STATUS_APPROVING.getStatus());
		statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_SUCCESS.getStatus());
		statusList.add(CompanyContrastApproveEnum.STATUS_ABOLISH.getStatus());
		
		CompanyContrastExample example = new CompanyContrastExample();
		example.createCriteria()
			   .andIdIn(ids)
		       .andApproveStatusIn(statusList);
		if(this.companyContrastMapper.countByExample(example) > 0){
			throw new CommonException("您选择的数据中包括已作废或正在审批或审批成功或审批失败的单据,无法发送审批单据!");
		}
		
		//加入审批流
		example.clear();
		example.createCriteria()
			   .andIdIn(ids);
		
		List<CompanyContrast> list = this.queryAllObjByExample(example);
		this.addToWorkFlow(list);
    }
    
    //加入到审批流程里
    private void addToWorkFlow(List<CompanyContrast> list){
    	if(CollectionUtils.isNotEmpty(list)){
			for (CompanyContrast it : list) {
				ProcessStartVO vo = ProcessStartVO.newInstance("qzgysdbb", it.getContrastBillNo(), it.getId(),"supComparisonTable?id="+it.getId());
				vo.setListenerClass(this.getClass());
				ProcessInstance startProcess = this.workFlowService.startProcess(vo);
				if(null != startProcess){
					//成功加入审批流
					CompanyContrast companyContrast = new CompanyContrast();
					companyContrast.setApproveStatus(CompanyContrastApproveEnum.STATUS_APPROVING.getStatus());
					companyContrast.setUpdateTime(new Date());
					companyContrast.setApproveTime(new Date());
					
					CompanyContrastExample example = new CompanyContrastExample();
					example.createCriteria()
						   .andIdEqualTo(it.getId());
					
					this.companyContrastMapper.updateByExampleSelective(companyContrast, example);
				}
			}
		}
    }
    
    /**
     * 记得清缓存
     */
    @CacheEvict(value={"companyContrast"}, allEntries=true)
	@Override
	public void listen(TaskOperateEvent event) {
    	if(null == event){
    		logger.debug("审批流返回监听事件为空!");
    		return ;
    	}
    	if(StringUtils.isEmpty(event.getBusinessId())){
    		logger.debug("审批流返回的业务id为空!");
    		return ;
    	}
    	CompanyContrast data = this.queryObjById(event.getBusinessId());
    	if(null == data){
    		logger.debug("审批流返回的业务id查询的单据为空!");
    		return ;
    	}
    	
		CompanyContrastExample example = new CompanyContrastExample();
		example.createCriteria()
				.andIdEqualTo(event.getBusinessId());
		
		CompanyContrast c = new CompanyContrast();
		c.setUpdateTime(new Date());
		c.setApproveUserName(event.getAssignee());
		
		if(StringUtils.isNotEmpty(data.getApproveSuggestion())){
			//如果审批意见是空的
			c.setApproveSuggestion(data.getApproveSuggestion()+"       ");
		}else{
			c.setApproveSuggestion("");
		}
		
		//设置审批意见
		if(StringUtils.isEmpty(event.getApproveDesc())){
			c.setApproveSuggestion(c.getApproveSuggestion()+event.getAssignee()+":"+"无");
		}else{
			c.setApproveSuggestion(c.getApproveSuggestion()+event.getAssignee()+":"+event.getApproveDesc());
		}
		
		
		if(event.isFinished() && event.isPass()){
			//审批流完成而且审批通过
			c.setApproveStatus(CompanyContrastApproveEnum.STATUS_APPROVE_SUCCESS.getStatus());
		}else if(event.isFinished() && !event.isPass()){
			//审批流完成但审批被驳回
			c.setApproveStatus(CompanyContrastApproveEnum.STATUS_APPROVE_FAIL.getStatus());
		}
		this.companyContrastMapper.updateByExampleSelective(c, example);
		
	}
    
    
    @CacheEvict(value={"companyContrast"}, allEntries=true)
	@Override
	public void setSuggestedSupplier(CompanyContrast companyContrast) {
		if(null == companyContrast){
			throw new CommonException("操作失败，数据不能为空!");
		}
		if(StringUtils.isEmpty(companyContrast.getId())){
			throw new CommonException("传递的数据的id为空!");
		}
		
//		example.createCriteria()
//			   .andIdEqualTo(companyContrast.getId())
//		       .andConfirmStatusEqualTo(CompanyContrastConfirmStatusEnum.STATUS_ABOLISH.getStatus());
//	
//		if(this.companyContrastMapper.countByExample(example) > 0){
//			throw new CommonException("已作废的单据无需再设置建议的供应商");
//		}
		
		List<Integer> statusList = new ArrayList<>();
		statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_FAIL.getStatus());
		statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_SUCCESS.getStatus());
		statusList.add(CompanyContrastApproveEnum.STATUS_ABOLISH.getStatus());
		
		CompanyContrastExample example = new CompanyContrastExample();
		example.createCriteria()
			   .andIdEqualTo(companyContrast.getId())
		 	   .andApproveStatusIn(statusList);
		if(this.companyContrastMapper.countByExample(example) > 0){
			throw new CommonException("审批通过或已驳回或已作废的单据无法再设置建议的供应商!");
		}
		
		companyContrast.setUpdateTime(new Date());
		
		this.companyContrastMapper.updateByPrimaryKeySelective(companyContrast);
	}
    
    @CacheEvict(value={"companyContrast"}, allEntries=true)
	@Override
	public void setApproveSuggestion(CompanyContrast companyContrast) {
    	if(null == companyContrast){
			throw new CommonException("操作失败，数据不能为空!");
		}
		if(StringUtils.isEmpty(companyContrast.getId())){
			throw new CommonException("传递的数据的id为空!");
		}
		
//		CompanyContrastExample example = new CompanyContrastExample();
//		example.createCriteria()
//			   .andIdEqualTo(companyContrast.getId())
//		       .andConfirmStatusEqualTo(CompanyContrastConfirmStatusEnum.STATUS_ABOLISH.getStatus());
//	
//		if(this.companyContrastMapper.countByExample(example) > 0){
//			throw new CommonException("已作废的单据无需再设置审批意见!");
//		}
		
//		List<Integer> statusList = new ArrayList<>();
//		statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_FAIL.getStatus());
//		statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_SUCCESS.getStatus());
//		
//		example.clear();
//		example.createCriteria()
//			   .andIdEqualTo(companyContrast.getId())
//		 	   .andApproveStatusIn(statusList);
//		if(this.companyContrastMapper.countByExample(example) > 0){
//			throw new CommonException("审批通过或已驳回的单据无法再设置审批意见!");
//		}
		
		companyContrast.setUpdateTime(new Date());
		this.companyContrastMapper.updateByPrimaryKeySelective(companyContrast);
	}
    
    @CacheEvict(value={"companyContrast"}, allEntries=true)
	@Override
	public void setCompanyContrastRemark(CompanyContrast companyContrast) {
    	if(null == companyContrast){
			throw new CommonException("操作失败，数据不能为空!");
		}
		if(StringUtils.isEmpty(companyContrast.getId())){
			throw new CommonException("传递的数据的id为空!");
		}
		
		companyContrast.setUpdateTime(new Date());
		
		this.companyContrastMapper.updateByPrimaryKeySelective(companyContrast);
	}
    
    @Transactional
    @CacheEvict(value={"companyContrast"}, allEntries=true)
	@Override
	public void create(CompanyContrastVO vo) {
		//保存头信息
    	this.addObj(vo);
    	
    	//保存行信息
    	List<CompanyContrastItem> list = vo.getCompanyContrastItemList();
    	for (CompanyContrastItem item : list) {
    		if(StringUtils.isEmpty(item.getCompanyContrastId())){
    			throw new CommonException("行数据中的头id为空,无法保存数据");
    		}
			companyContrastItemService.addObj(item);
		}
    }
    
//    @CacheEvict(value={"companyContrast"}, allEntries=true)
//	@Override
//	public void approveSuccess(List<String> ids) {
//		CompanyContrastExample example = new CompanyContrastExample();
//		example.createCriteria()
//			   .andIdIn(ids);
//		
//		CompanyContrast c = new CompanyContrast();
//		c.setApproveStatus(CompanyContrastApproveEnum.STATUS_APPROVE_SUCCESS.getStatus());
//		c.setUpdateTime(new Date());
//		
//		this.companyContrastMapper.updateByExampleSelective(c, example);
//    }
    
    @CacheEvict(value={"companyContrast"}, allEntries=true)
	@Override
	public void modifyData(CompanyContrast companyContrast) {
    	if(null == companyContrast){
    		throw new CommonException("传递参数为空!");
    	}
		if(StringUtils.isEmpty(companyContrast.getId())){
			throw new CommonException("传递的单据id为空!");
		}
		
//		example.createCriteria()
//			   .andIdEqualTo(companyContrast.getId())
//		       .andConfirmStatusEqualTo(CompanyContrastConfirmStatusEnum.STATUS_ABOLISH.getStatus());
//		
//		if(this.companyContrastMapper.countByExample(example) > 0){
//			throw new CommonException("该单据已作废,无法修改单据信息!");
//		}
		
		List<Integer> statusList = new ArrayList<>();
		statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_FAIL.getStatus());
		statusList.add(CompanyContrastApproveEnum.STATUS_APPROVING.getStatus());
		statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_SUCCESS.getStatus());
		statusList.add(CompanyContrastApproveEnum.STATUS_ABOLISH.getStatus());
	
		CompanyContrastExample example = new CompanyContrastExample();
		example.createCriteria()
			   .andIdEqualTo(companyContrast.getId())
		       .andApproveStatusIn(statusList);
		if(this.companyContrastMapper.countByExample(example) > 0){
			throw new CommonException("该单据正处于审批中或审批通过或驳回状态,无法修改数据!");
		}
		
		this.companyContrastMapper.updateByPrimaryKeySelective(companyContrast);
	}

	@Override
	public FileData print(String projectId, String companyId, List<CompanyContrast> data) {
		if(null == data){
			throw new CommonException("传递的数据为空!");
		}
		//批量打印的单据id
		List<String> ids = null;
		for (CompanyContrast item : data) {
			if(StringUtils.isEmpty(item.getId())){
				throw new CommonException("传递的参数列表中存在id为空!");
			}
			if(null == ids)
				ids = new ArrayList<>();
			//放到数组中
			ids.add(item.getId());
		}
		CompanyContrastExample example = new CompanyContrastExample();
		example.createCriteria()
			   .andIdIn(ids);
		List<CompanyContrast> dataList = this.queryAllObjByExample(example);
		if(null == dataList){
			throw new CommonException("查询到的数据为空,无法打印单据!");
		}
		
		//将对比表的数据放到voList中
		List<CompanyContrastVO> voList = new ArrayList<>();
		for(CompanyContrast c : dataList){
			CompanyContrastVO vo = new CompanyContrastVO();
			//将对比的头信息放到vo中
			BeanUtils.copyProperties(c,vo);
			//查询行信息
			CompanyContrastItemExample itemExample = new CompanyContrastItemExample();
			itemExample.createCriteria()
					.andCompanyContrastIdEqualTo(c.getId());
			List<CompanyContrastItem> itemList = this.companyContrastItemService.queryAllObjByExample(itemExample);
			vo.setCompanyContrastItemList(itemList);
			
			voList.add(vo);
		}
		//创造打印数据
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("voList", voList);
		
		//创建文件信息
		FileData fileData = null;
		
		try {
			fileData = CompanyContrastPrintUtils.generatePdf(projectId, companyId, params, "A4");
		} catch (Exception e) {
			throw new CommonException("生成pdf文件出错!");
		}
		
		return fileData;
	}
    
}